/*
 * Decompiled with CFR 0.152.
 */
package com.troblecodings.signals.core;

import com.google.gson.Gson;
import com.troblecodings.signals.OpenSignalsMain;
import com.troblecodings.signals.contentpacks.ContentPackException;
import com.troblecodings.signals.core.JsonEnum;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class JsonEnumHolder {
    private static final Gson GSON = new Gson();
    public static final Map<String, JsonEnum> PROPERTIES = JsonEnumHolder.getProperties();
    public static final JsonEnum ZS32 = PROPERTIES.get("zs32");

    private JsonEnumHolder() {
    }

    public static Map<String, JsonEnum> getProperties() {
        HashMap<String, JsonEnum> returnmap = new HashMap<String, JsonEnum>();
        OpenSignalsMain.contentPacks.getFiles("enumdefinition").forEach(entry -> {
            String file = (String)entry.getValue();
            Map map = (Map)GSON.fromJson(file, Map.class);
            if (map == null) {
                throw new IllegalStateException("Could not parse " + file);
            }
            map.forEach((name, list) -> {
                if (list.size() > 256) {
                    OpenSignalsMain.getLogger().info("Congratulations, you are probably one of the first people on earth to try to register more than 256 EnumValues. We don't want to ruin your work, but 256 is the maximum number of EnumValues!");
                    throw new ContentPackException("You have added to many EnumValues! Max. is 256!");
                }
                returnmap.put(name.toLowerCase(), new JsonEnum((String)name, (List<String>)list));
            });
        });
        returnmap.put(JsonEnum.BOOLEAN.getName(), JsonEnum.BOOLEAN);
        return returnmap;
    }
}

