/*
 * Decompiled with CFR 0.152.
 */
package com.troblecodings.signals.contentpacks;

import com.google.gson.Gson;
import com.troblecodings.signals.OpenSignalsMain;
import com.troblecodings.signals.SEProperty;
import com.troblecodings.signals.blocks.Signal;
import com.troblecodings.signals.contentpacks.ContentPackException;
import com.troblecodings.signals.core.SubsidiaryState;
import com.troblecodings.signals.parser.FunctionParsingInfo;
import com.troblecodings.signals.properties.PredicatedPropertyBase;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SubsidiarySignalParser {
    private String currentSignal;
    private Map<String, List<String>> allStates;
    public static final Map<Signal, Map<SubsidiaryState, PredicatedPropertyBase.ConfigProperty>> SUBSIDIARY_SIGNALS = new HashMap<Signal, Map<SubsidiaryState, PredicatedPropertyBase.ConfigProperty>>();
    private static final Gson GSON = new Gson();

    private static void loadSubsidiaryStates() {
        OpenSignalsMain.contentPacks.getFiles("signalconfigs/subsidiaryenums").forEach(entry -> {
            try {
                SubsidiaryEnumParser parser = (SubsidiaryEnumParser)GSON.fromJson((String)entry.getValue(), SubsidiaryEnumParser.class);
                parser.subsidiaryStates.forEach(state -> state.prepareData());
            }
            catch (Exception e) {
                OpenSignalsMain.getLogger().error("Please update your SubsidiaryEnumFile: " + (String)entry.getKey() + "!");
                OldSubsidiaryEnumParser parser = (OldSubsidiaryEnumParser)GSON.fromJson((String)entry.getValue(), OldSubsidiaryEnumParser.class);
                parser.subsidiaryStates.forEach(name -> new SubsidiaryState((String)name));
            }
        });
    }

    public static void loadAllSubsidiarySignals() {
        SubsidiarySignalParser.loadSubsidiaryStates();
        OpenSignalsMain.contentPacks.getFiles("signalconfigs/subsidiary").forEach(entry -> {
            SubsidiarySignalParser parser = (SubsidiarySignalParser)GSON.fromJson((String)entry.getValue(), SubsidiarySignalParser.class);
            Signal signal = Signal.SIGNALS.get(parser.currentSignal.toLowerCase());
            if (signal == null) {
                throw new ContentPackException("There doesn't exists a signal with the name '" + parser.currentSignal + "'! Valid Signals are: " + Signal.SIGNALS.keySet());
            }
            if (SUBSIDIARY_SIGNALS.containsKey((Object)signal)) {
                throw new ContentPackException("There already exists a Subsidiary Config for " + (Object)((Object)signal) + "!");
            }
            FunctionParsingInfo info = new FunctionParsingInfo(signal);
            parser.allStates.forEach((name, properties) -> SubsidiarySignalParser.convertToProperites(signal, info, properties, name));
        });
    }

    private static void convertToProperites(Signal signal, FunctionParsingInfo info, List<String> values, String enumName) {
        if (values == null) {
            return;
        }
        SubsidiaryState enumState = null;
        for (int i = 0; i < SubsidiaryState.ALL_STATES.size(); ++i) {
            SubsidiaryState current = SubsidiaryState.ALL_STATES.get(i);
            if (!current.getName().equalsIgnoreCase(enumName)) continue;
            enumState = current;
            break;
        }
        if (enumState == null) {
            throw new ContentPackException(enumName + " is not a valid Subsidiary State! Valid Subsidiary States: " + SubsidiaryState.ALL_STATES);
        }
        HashMap<SEProperty, String> allValues = new HashMap<SEProperty, String>();
        values.forEach(str -> {
            String[] value = str.split("\\.");
            allValues.put((SEProperty)info.getProperty(value[0]), value[1]);
        });
        Map properties = SUBSIDIARY_SIGNALS.computeIfAbsent(signal, _u -> new HashMap());
        properties.put(enumState, new PredicatedPropertyBase.ConfigProperty(t -> true, (Map<SEProperty, String>)allValues));
        SUBSIDIARY_SIGNALS.put(signal, properties);
    }

    private static class OldSubsidiaryEnumParser {
        private List<String> subsidiaryStates;

        private OldSubsidiaryEnumParser() {
        }
    }

    private static class SubsidiaryEnumParser {
        private List<SubsidiaryState> subsidiaryStates;

        private SubsidiaryEnumParser() {
        }
    }
}

