/*
 * Decompiled with CFR 0.152.
 */
package com.troblecodings.signals.contentpacks;

import com.google.gson.Gson;
import com.troblecodings.signals.OpenSignalsMain;
import com.troblecodings.signals.SEProperty;
import com.troblecodings.signals.blocks.Signal;
import com.troblecodings.signals.contentpacks.ContentPackException;
import com.troblecodings.signals.parser.FunctionParsingInfo;
import com.troblecodings.signals.parser.LogicParser;
import com.troblecodings.signals.parser.LogicalParserException;
import com.troblecodings.signals.properties.PredicatedPropertyBase;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;

public class OneSignalPredicateConfigParser {
    private String currentSignal;
    private Map<String, String> savedPredicates;
    private Map<String, List<String>> values;
    public static final Map<Signal, List<PredicatedPropertyBase.ConfigProperty>> DEFAULTCONFIGS = new HashMap<Signal, List<PredicatedPropertyBase.ConfigProperty>>();
    private static final Gson GSON = new Gson();

    public static void loadDefaultConfigs() {
        OneSignalPredicateConfigParser.loadOneSignalPredicateConfigs(DEFAULTCONFIGS, "signalconfigs/default");
    }

    public static void loadOneSignalPredicateConfigs(Map<Signal, List<PredicatedPropertyBase.ConfigProperty>> map, String internal) {
        List<Map.Entry<String, String>> list = OpenSignalsMain.contentPacks.getFiles(internal);
        list.forEach(entry -> OneSignalPredicateConfigParser.loadOneSignalPredicateConfigs(map, entry));
    }

    public static void loadOneSignalPredicateConfigs(Map<Signal, List<PredicatedPropertyBase.ConfigProperty>> map, Map.Entry<String, String> files) {
        OneSignalPredicateConfigParser parser = (OneSignalPredicateConfigParser)GSON.fromJson(files.getValue(), OneSignalPredicateConfigParser.class);
        Signal signal = Signal.SIGNALS.get(parser.currentSignal.toLowerCase());
        if (signal == null) {
            OpenSignalsMain.getLogger().warn("The signal '" + parser.currentSignal + "' doesn't exists! This config with the filename '" + files.getKey() + "' will be skiped!");
            return;
        }
        if (map.containsKey((Object)signal)) {
            throw new LogicalParserException("A signalconfig with the signals [" + signal.getSignalTypeName() + "] does alredy exists! '" + files.getKey() + "' tried to register a defaultconfig for the same signal!");
        }
        FunctionParsingInfo info = new FunctionParsingInfo(LogicParser.UNIVERSAL_TRANSLATION_TABLE, signal);
        ArrayList<PredicatedPropertyBase.ConfigProperty> properties = new ArrayList<PredicatedPropertyBase.ConfigProperty>();
        Map<String, String> savedPredicates = parser.savedPredicates;
        for (Map.Entry<String, List<String>> entry : parser.values.entrySet()) {
            String valueToParse = entry.getKey().toLowerCase();
            Predicate<Map<Class<?>, Object>> predicate = t -> true;
            if (valueToParse.contains("map(") && savedPredicates != null && !savedPredicates.isEmpty()) {
                char[] chars = entry.getKey().toCharArray();
                String names = "";
                boolean readKey = false;
                StringBuilder builder = new StringBuilder();
                String mapKey = "";
                for (char letter : chars) {
                    boolean isBracket;
                    String current = builder.append(letter).toString();
                    boolean isOpenBracket = current.equals("(");
                    boolean isCloseBracket = current.equals(")");
                    builder.setLength(0);
                    if (readKey) {
                        try {
                            if (isCloseBracket) {
                                valueToParse = valueToParse.replace("map(" + mapKey + ")", "(" + savedPredicates.get(mapKey).toLowerCase() + ")");
                                names = "";
                                mapKey = "";
                                readKey = false;
                                continue;
                            }
                            mapKey = mapKey + current;
                            continue;
                        }
                        catch (Exception e) {
                            throw new ContentPackException("Something went wrong with the predicate saver in " + files.getKey() + "! Did you used it correctly?");
                        }
                    }
                    if (current.equals("(") && names.equals("map")) {
                        readKey = true;
                        mapKey = "";
                        continue;
                    }
                    boolean bl = isBracket = isCloseBracket || isOpenBracket;
                    if (Character.isWhitespace(letter) || current.equals("!") || isBracket) {
                        names = "";
                        mapKey = "";
                        continue;
                    }
                    names = names + current;
                }
            }
            if (valueToParse != null && !valueToParse.isEmpty() && !valueToParse.equalsIgnoreCase("true")) {
                predicate = LogicParser.predicate(valueToParse, info);
            }
            HashMap<SEProperty, String> values = new HashMap<SEProperty, String>();
            for (String value : entry.getValue()) {
                String[] valuetoChange = value.split("\\.");
                SEProperty property = (SEProperty)info.getProperty(valuetoChange[0]);
                values.put(property, valuetoChange[1]);
            }
            properties.add(new PredicatedPropertyBase.ConfigProperty(predicate, (Map<SEProperty, String>)values));
        }
        map.put(signal, properties);
    }
}

