/*
 * Decompiled with CFR 0.152.
 */
package com.troblecodings.signals.blocks;

import com.google.common.collect.ImmutableList;
import com.troblecodings.signals.OpenSignalsMain;
import com.troblecodings.signals.SEProperty;
import com.troblecodings.signals.blocks.BasicBlock;
import com.troblecodings.signals.blocks.GhostBlock;
import com.troblecodings.signals.config.ConfigHandler;
import com.troblecodings.signals.core.JsonEnum;
import com.troblecodings.signals.core.RenderOverlayInfo;
import com.troblecodings.signals.core.SignalAngel;
import com.troblecodings.signals.core.SignalProperties;
import com.troblecodings.signals.core.StateInfo;
import com.troblecodings.signals.core.TileEntitySupplierWrapper;
import com.troblecodings.signals.enums.ChangeableStage;
import com.troblecodings.signals.handler.ClientSignalStateHandler;
import com.troblecodings.signals.handler.NameHandler;
import com.troblecodings.signals.handler.SignalBoxHandler;
import com.troblecodings.signals.handler.SignalStateHandler;
import com.troblecodings.signals.handler.SignalStateInfo;
import com.troblecodings.signals.init.OSItems;
import com.troblecodings.signals.items.Placementtool;
import com.troblecodings.signals.parser.ValuePack;
import com.troblecodings.signals.properties.PredicatedPropertyBase;
import com.troblecodings.signals.properties.SoundProperty;
import com.troblecodings.signals.tileentitys.SignalTileEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Signal
extends BasicBlock {
    public static Consumer<List<SEProperty>> nextConsumer = _u -> {};
    public static final Map<String, Signal> SIGNALS = new HashMap<String, Signal>();
    public static final List<Signal> SIGNAL_IDS = new ArrayList<Signal>();
    public static final PropertyEnum<SignalAngel> ANGEL = PropertyEnum.func_177709_a((String)"angel", SignalAngel.class);
    public static final SEProperty CUSTOMNAME = new SEProperty("customname", JsonEnum.BOOLEAN, "false", ChangeableStage.AUTOMATICSTAGE, t -> true, 0);
    public static final TileEntitySupplierWrapper SUPPLIER = SignalTileEntity::new;
    protected final SignalProperties prop;
    private final int id;
    private List<SEProperty> signalProperties;
    private final Map<SEProperty, Integer> signalPropertiesToInt = new HashMap<SEProperty, Integer>();

    public Signal(SignalProperties prop) {
        super(Material.field_151576_e);
        this.prop = prop;
        this.id = SIGNAL_IDS.size();
        SIGNAL_IDS.add(this);
        this.func_180632_j(this.func_176223_P().func_177226_a(ANGEL, (Comparable)((Object)SignalAngel.ANGEL0)));
        prop.placementtool.addSignal(this);
        for (int i = 0; i < this.signalProperties.size(); ++i) {
            SEProperty property = this.signalProperties.get(i);
            this.signalPropertiesToInt.put(property, i);
        }
        this.func_149715_a((float)ConfigHandler.lightEmission / 15.0f);
    }

    public int getID() {
        return this.id;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        TileEntity te = source.func_175625_s(pos);
        if (te == null || !(te instanceof SignalTileEntity)) {
            return field_185505_j;
        }
        World world = te.func_145831_w();
        SignalStateInfo info = new SignalStateInfo(world, pos, this);
        Map<SEProperty, String> properties = world.field_72995_K ? ClientSignalStateHandler.getClientStates(new StateInfo(info.world, info.pos)) : ((SignalTileEntity)te).getProperties();
        return field_185505_j.func_72321_a(0.0, (double)this.getHeight(properties), 0.0);
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return this.func_185496_a(blockState, worldIn, pos);
    }

    public static ItemStack pickBlock(EntityPlayer player, Item item) {
        if (!Minecraft.func_71410_x().field_71474_y.field_74322_I.func_151470_d()) {
            return new ItemStack(item);
        }
        for (int k = 0; k < InventoryPlayer.func_70451_h(); ++k) {
            if (!player.field_71071_by.func_70301_a(k).func_77973_b().equals(item)) continue;
            player.field_71071_by.field_70461_c = k;
            return ItemStack.field_190927_a;
        }
        return new ItemStack(item);
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return Signal.pickBlock(player, this.prop.placementtool);
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        int index = 15 - (MathHelper.func_76128_c((double)((double)(placer.func_70079_am() * 16.0f / 360.0f) - 0.5)) & 0xF);
        return this.func_176223_P().func_177226_a(ANGEL, (Comparable)((Object)SignalAngel.values()[index]));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(ANGEL, (Comparable)((Object)SignalAngel.values()[meta]));
    }

    public int func_176201_c(IBlockState state) {
        return ((SignalAngel)((Object)state.func_177229_b(ANGEL))).ordinal();
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_185907_a(rot);
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185902_a(mirrorIn);
    }

    @Override
    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return layer.equals((Object)BlockRenderLayer.CUTOUT_MIPPED);
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess acess, BlockPos pos) {
        AtomicReference<IExtendedBlockState> blockState = new AtomicReference<IExtendedBlockState>((IExtendedBlockState)super.getExtendedState(state, acess, pos));
        SignalTileEntity tile = (SignalTileEntity)acess.func_175625_s(pos);
        if (tile == null) {
            return (IBlockState)blockState.get();
        }
        World world = tile.func_145831_w();
        SignalStateInfo info = new SignalStateInfo(world, pos, this);
        Map<SEProperty, String> properties = world.field_72995_K ? ClientSignalStateHandler.getClientStates(new StateInfo(info.world, info.pos)) : tile.getProperties();
        properties.forEach((property, value) -> {
            IExtendedBlockState cfr_ignored_0 = (IExtendedBlockState)blockState.getAndUpdate(oldState -> oldState.withProperty((IUnlistedProperty)property, value));
        });
        return (IBlockState)blockState.get();
    }

    public boolean func_149751_l(IBlockState state) {
        return true;
    }

    @Override
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Override
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public int getIDFromProperty(SEProperty property) {
        return this.signalPropertiesToInt.get(property);
    }

    protected BlockStateContainer func_180661_e() {
        ArrayList<SEProperty> properties = new ArrayList<SEProperty>();
        nextConsumer.accept(properties);
        nextConsumer = _u -> {};
        properties.add(CUSTOMNAME);
        this.signalProperties = ImmutableList.copyOf(properties);
        return new ExtendedBlockState((Block)this, new IProperty[]{ANGEL}, this.signalProperties.toArray(new IUnlistedProperty[this.signalProperties.size()]));
    }

    public List<SEProperty> getProperties() {
        return this.signalProperties;
    }

    public String getSignalTypeName() {
        return this.getRegistryName().func_110623_a();
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        super.func_180663_b(worldIn, pos, state);
        GhostBlock.destroyUpperBlock(worldIn, pos);
        if (!worldIn.field_72995_K) {
            SignalStateInfo info = new SignalStateInfo(worldIn, pos, this);
            SignalStateHandler.sendRemoved(info);
            NameHandler.sendRemoved(new StateInfo(worldIn, pos));
            new Thread(() -> {
                SignalStateHandler.setRemoved(new SignalStateInfo(worldIn, pos, this));
                NameHandler.setRemoved(new StateInfo(worldIn, pos));
                SignalBoxHandler.onPosRemove(new StateInfo(worldIn, pos));
            }, "Signal:breakBlock").start();
        }
    }

    public int getHeight(Map<SEProperty, String> map) {
        for (PredicatedPropertyBase.PredicateProperty<Integer> property : this.prop.signalHeights) {
            if (!property.test(map)) continue;
            return (Integer)property.state;
        }
        return this.prop.defaultHeight;
    }

    public boolean canHaveCustomname(Map<SEProperty, String> map) {
        return this.prop.customNameRenderHeight != -1.0f || !this.prop.customRenderHeights.isEmpty();
    }

    @Override
    public Optional<String> getSupplierWrapperName() {
        return Optional.of("signal");
    }

    public String toString() {
        return this.func_149739_a();
    }

    public final boolean canBeLinked() {
        return this.prop.canLink;
    }

    @SideOnly(value=Side.CLIENT)
    public int colorMultiplier(IBlockState state, IBlockAccess worldIn, BlockPos pos, int tintIndex) {
        return this.prop.colors.get(tintIndex);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasCostumColor() {
        return !this.prop.colors.isEmpty();
    }

    @SideOnly(value=Side.CLIENT)
    public void renderOverlay(RenderOverlayInfo info) {
        if (this.prop.autoscale) {
            this.renderScaleOverlay(info, this.prop.customNameRenderHeight);
            return;
        }
        this.renderOverlay(info, this.prop.customNameRenderHeight);
    }

    @SideOnly(value=Side.CLIENT)
    public void renderScaleOverlay(RenderOverlayInfo info, float renderHeight) {
        BlockPos pos;
        Map<SEProperty, String> map = ClientSignalStateHandler.getClientStates(new StateInfo(info.tileEntity.func_145831_w(), info.tileEntity.func_174877_v()));
        String customNameState = map.get(CUSTOMNAME);
        if (customNameState == null || customNameState.equalsIgnoreCase("FALSE")) {
            return;
        }
        float customRenderHeight = renderHeight;
        for (PredicatedPropertyBase.PredicateProperty<Float> property : this.prop.customRenderHeights) {
            if (property.predicate.test(map)) {
                customRenderHeight = ((Float)property.state).floatValue();
            }
            if (customRenderHeight != -1.0f) continue;
            return;
        }
        World world = info.tileEntity.func_145831_w();
        IBlockState state = world.func_180495_p(pos = info.tileEntity.func_174877_v());
        if (!(state.func_177230_c() instanceof Signal)) {
            return;
        }
        boolean doubleSidedText = false;
        for (PredicatedPropertyBase.PredicateProperty<Boolean> boolProp : this.prop.doubleSidedText) {
            if (!boolProp.predicate.test(map)) continue;
            doubleSidedText = (Boolean)boolProp.state;
        }
        SignalAngel face = (SignalAngel)((Object)state.func_177229_b(ANGEL));
        float angel = face.getDregree();
        GlStateManager.func_179141_d();
        GlStateManager.func_179140_f();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(info.x + 0.5), (double)(info.y + 0.75), (double)(info.z + 0.5));
        GlStateManager.func_179114_b((float)angel, (float)0.0f, (float)1.0f, (float)0.0f);
        this.renderSingleScaleOverlay(info);
        if (doubleSidedText) {
            GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            this.renderSingleScaleOverlay(info);
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179145_e();
    }

    @SideOnly(value=Side.CLIENT)
    public void renderSingleScaleOverlay(RenderOverlayInfo info) {
        String name = info.tileEntity.getNameWrapper();
        float nameWidth = info.font.func_78256_a(name);
        float scale = Math.min(1.0f / (22.0f * (nameWidth / this.prop.signWidth)), 0.1f);
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)(-scale), (float)(-scale), (float)1.0f);
        GlStateManager.func_179109_b((float)(-nameWidth / 2.0f), (float)0.0f, (float)-0.32f);
        info.font.func_78276_b(name, 0, 0, this.prop.textColor);
        GlStateManager.func_179121_F();
    }

    @SideOnly(value=Side.CLIENT)
    public void renderOverlay(RenderOverlayInfo info, float renderHeight) {
        BlockPos pos;
        float customRenderHeight = renderHeight;
        Map<SEProperty, String> map = ClientSignalStateHandler.getClientStates(new StateInfo(info.tileEntity.func_145831_w(), info.tileEntity.func_174877_v()));
        String customNameState = map.get(CUSTOMNAME);
        if (customNameState == null || customNameState.equalsIgnoreCase("FALSE")) {
            return;
        }
        for (PredicatedPropertyBase.PredicateProperty<Float> property : this.prop.customRenderHeights) {
            if (!property.predicate.test(map)) continue;
            customRenderHeight = ((Float)property.state).floatValue();
        }
        if (customRenderHeight == -1.0f) {
            return;
        }
        World world = info.tileEntity.func_145831_w();
        IBlockState state = world.func_180495_p(pos = info.tileEntity.func_174877_v());
        if (!(state.func_177230_c() instanceof Signal)) {
            return;
        }
        boolean doubleSidedText = false;
        for (PredicatedPropertyBase.PredicateProperty<Boolean> boolProp : this.prop.doubleSidedText) {
            if (!boolProp.predicate.test(map)) continue;
            doubleSidedText = (Boolean)boolProp.state;
        }
        String name = info.tileEntity.getNameWrapper();
        String[] splitNames = name.split("\\[n\\]");
        SignalAngel angle = (SignalAngel)((Object)state.func_177229_b(ANGEL));
        float scale = this.prop.signScale;
        GlStateManager.func_179141_d();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(info.x + 0.5), (double)(info.y + (double)customRenderHeight), (double)(info.z + 0.5));
        GlStateManager.func_179114_b((float)angle.getDregree(), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)(-0.015f * scale), (float)(-0.015f * scale), (float)(0.015f * scale));
        this.renderSingleOverlay(info, splitNames);
        if (doubleSidedText) {
            GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            this.renderSingleOverlay(info, splitNames);
        }
        GlStateManager.func_179121_F();
    }

    @SideOnly(value=Side.CLIENT)
    public void renderSingleOverlay(RenderOverlayInfo info, String[] splitNames) {
        float signWidth = this.prop.signWidth;
        float offsetX = this.prop.offsetX;
        float offsetZ = this.prop.offsetY;
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)offsetX, (float)0.0f, (float)(-4.2f + offsetZ));
        for (int j = 0; j < splitNames.length; ++j) {
            String name = splitNames[j];
            float nameWidth = info.font.func_78256_a(name);
            float center = (signWidth - nameWidth) / 2.0f;
            info.font.func_78279_b(name, (int)center - 10, j * 10, (int)signWidth, this.prop.textColor);
        }
        GlStateManager.func_179121_F();
    }

    public Placementtool getPlacementtool() {
        return this.prop.placementtool;
    }

    public int getDefaultDamage() {
        return this.prop.defaultItemDamage;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        Item item = player.func_184614_ca().func_77973_b();
        if (!(state.func_177230_c() instanceof Signal) || item.equals((Object)OSItems.LINKING_TOOL) || item.equals((Object)OSItems.MULTI_LINKING_TOOL)) {
            return false;
        }
        SignalStateInfo stateInfo = new SignalStateInfo(world, pos, this);
        Map<SEProperty, String> states = SignalStateHandler.getStates(stateInfo);
        boolean customname = this.canHaveCustomname(states);
        if (player.func_184614_ca().func_77973_b().equals(OSItems.MANIPULATOR) && (this.canBeLinked() || customname)) {
            if (world.field_72995_K) {
                return true;
            }
            OpenSignalsMain.handler.invokeGui(Signal.class, player, world, pos, "signal");
            return true;
        }
        if (this.loadRedstoneOutput(world, stateInfo, states)) {
            world.func_180501_a(pos, state, 3);
            world.func_175685_c(pos, (Block)this, true);
            world.markAndNotifyBlock(pos, null, state, state, 3);
        }
        return true;
    }

    private boolean loadRedstoneOutput(World worldIn, SignalStateInfo info, Map<SEProperty, String> properties) {
        if (!this.prop.redstoneOutputs.isEmpty()) {
            for (ValuePack pack : this.prop.redstoneOutputs) {
                if (!properties.containsKey(pack.property) || !pack.predicate.test(properties)) continue;
                SignalStateHandler.setState(info, pack.property, Boolean.toString(Boolean.valueOf(properties.get(pack.property)) == false));
                return true;
            }
        }
        return false;
    }

    public boolean hasRedstoneOut() {
        return !this.prop.redstoneOutputs.isEmpty() || !this.prop.redstoneOutputPacks.isEmpty();
    }

    public boolean func_149744_f(IBlockState state) {
        return this.hasRedstoneOut();
    }

    public int func_176211_b(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return this.func_180656_a(blockState, blockAccess, pos, side);
    }

    public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        if (!this.hasRedstoneOut() || !(blockAccess instanceof World)) {
            return 0;
        }
        SignalStateInfo stateInfo = new SignalStateInfo((World)blockAccess, pos, this);
        Map<SEProperty, String> properties = SignalStateHandler.getStates(stateInfo);
        for (List valuePacks : ImmutableList.of(this.prop.redstoneOutputPacks, this.prop.redstoneOutputs)) {
            for (ValuePack pack : valuePacks) {
                if (!properties.containsKey(pack.property) || !pack.predicate.test(properties) || properties.get(pack.property).equalsIgnoreCase(pack.property.getDefault())) continue;
                return 15;
            }
        }
        return 0;
    }

    public void getUpdate(World world, BlockPos pos) {
        if (this.prop.sounds.isEmpty()) {
            return;
        }
        SignalStateInfo stateInfo = new SignalStateInfo(world, pos, this);
        SignalStateHandler.runTaskWhenSignalLoaded(stateInfo, (info, properties, _u) -> {
            SoundProperty sound = this.getSound(properties);
            if (sound.duration < 1) {
                return;
            }
            if (sound.duration == 1) {
                world.func_184133_a(null, pos, (SoundEvent)sound.state, SoundCategory.BLOCKS, 1.0f, 1.0f);
            } else {
                if (world.func_184145_b(pos, (Block)this)) {
                    return;
                }
                if (sound.predicate.test(properties)) {
                    world.func_175684_a(pos, (Block)this, 1);
                }
            }
        });
    }

    public SoundProperty getSound(Map<SEProperty, String> map) {
        for (SoundProperty property : this.prop.sounds) {
            if (!property.predicate.test(map)) continue;
            return property;
        }
        return new SoundProperty(null, t -> true, 0);
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (this.prop.sounds.isEmpty() || worldIn.field_72995_K) {
            return;
        }
        SignalStateInfo stateInfo = new SignalStateInfo(worldIn, pos, this);
        SignalStateHandler.runTaskWhenSignalLoaded(stateInfo, (info, properties, _u) -> {
            SoundProperty sound = this.getSound(properties);
            if (sound.duration <= 1) {
                return;
            }
            worldIn.func_184133_a(null, pos, (SoundEvent)sound.state, SoundCategory.BLOCKS, 1.0f, 1.0f);
            worldIn.func_175684_a(pos, (Block)this, sound.duration);
        });
    }

    @Override
    public Optional<TileEntitySupplierWrapper> getSupplierWrapper() {
        return Optional.of(SUPPLIER);
    }

    @Override
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new SignalTileEntity();
    }
}

