/*
 * Decompiled with CFR 0.152.
 */
package com.troblecodings.guilib.ecs.entitys.render;

import com.troblecodings.guilib.ecs.entitys.BufferWrapper;
import com.troblecodings.guilib.ecs.entitys.DrawInfo;
import com.troblecodings.guilib.ecs.entitys.UIComponent;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class UITexture
extends UIComponent {
    private final double u;
    private final double v;
    private final double mu;
    private final double mv;
    private final ResourceLocation texture;

    public UITexture(TextureAtlasSprite sprite) {
        this.texture = TextureMap.field_110575_b;
        this.u = sprite.func_94209_e();
        this.v = sprite.func_94206_g();
        this.mu = sprite.func_94212_f();
        this.mv = sprite.func_94210_h();
    }

    public UITexture(ResourceLocation texture) {
        this(texture, 0.0, 0.0, 1.0, 1.0);
    }

    public UITexture(ResourceLocation texture, double u, double v, double maxU, double maxV) {
        this.texture = texture;
        this.u = u;
        this.v = v;
        this.mu = maxU;
        this.mv = maxV;
    }

    @Override
    public void draw(DrawInfo info) {
        info.depthOn();
        info.blendOn();
        info.alphaOn();
        info.applyColor();
        info.applyTexture(this.texture);
        double w = this.parent.getWidth();
        double h = this.parent.getHeight();
        BufferWrapper bufferbuilder = info.builder(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.pos(0.0, h, 0.0).tex((float)this.u, (float)this.mv).end();
        bufferbuilder.pos(w, h, 0.0).tex((float)this.mu, (float)this.mv).end();
        bufferbuilder.pos(w, 0.0, 0.0).tex((float)this.mu, (float)this.v).end();
        bufferbuilder.pos(0.0, 0.0, 0.0).tex((float)this.u, (float)this.v).end();
        info.end();
        info.alphaOff();
        info.blendOff();
        info.depthOff();
        info.disableTexture();
    }

    @Override
    public void update() {
    }
}

