/*
 * Decompiled with CFR 0.152.
 */
package com.troblecodings.guilib.ecs.entitys.render;

import com.troblecodings.guilib.ecs.DrawUtil;
import com.troblecodings.guilib.ecs.entitys.DrawInfo;
import com.troblecodings.guilib.ecs.entitys.UIComponent;
import com.troblecodings.guilib.ecs.entitys.UIEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class UIButton
extends UIComponent {
    public static final int DEFAULT_COLOR = 0xE0E0E0;
    public static final int DEFAULT_DISABLED_COLOR = 0xA0A0A0;
    public static final int DEFAULT_HOVER_COLOR = 0xFFFFA0;
    public static final ResourceLocation BUTTON_TEXTURES = new ResourceLocation("textures/gui/widgets.png");
    private String text;
    private boolean enabled;
    private final FontRenderer fontrenderer;

    public UIButton(String text) {
        Minecraft mc = Minecraft.func_71410_x();
        this.setVisible(true);
        this.setEnabled(true);
        this.text = text;
        this.fontrenderer = mc.field_71466_p;
    }

    @Override
    public void draw(DrawInfo info) {
        if (this.visible) {
            info.applyTexture(BUTTON_TEXTURES);
            info.color();
            info.depthOff();
            int offsetV = this.enabled ? (this.parent.isHovered() ? 2 : 1) : 0;
            GuiUtils.drawTexturedModalRect((int)0, (int)0, (int)0, (int)(46 + offsetV * 20), (int)((int)this.parent.getWidth() / 2), (int)((int)this.parent.getHeight()), (float)0.0f);
            GuiUtils.drawTexturedModalRect((int)((int)this.parent.getWidth() / 2), (int)0, (int)(200 - (int)this.parent.getWidth() / 2), (int)(46 + offsetV * 20), (int)((int)this.parent.getWidth() / 2), (int)((int)this.parent.getHeight()), (float)0.0f);
            int colorUsed = this.enabled ? (this.parent.isHovered() ? 0xFFFFA0 : 0xE0E0E0) : 0xA0A0A0;
            DrawUtil.drawCenteredString(info, this.fontrenderer, this.text, (int)this.parent.getWidth() / 2, ((int)this.parent.getHeight() - 8) / 2, colorUsed);
        }
    }

    @Override
    public void update() {
    }

    @Override
    public void onAdd(UIEntity entity) {
        super.onAdd(entity);
        this.update();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }
}

