/*
 * Decompiled with CFR 0.152.
 */
package com.troblecodings.guilib.ecs.entitys;

import com.troblecodings.guilib.ecs.entitys.DrawInfo;
import com.troblecodings.guilib.ecs.entitys.UIComponent;
import com.troblecodings.guilib.ecs.entitys.UIEntity;
import com.troblecodings.guilib.ecs.interfaces.IBoxMode;
import java.util.function.IntConsumer;

public class UIScrollBox
extends UIComponent {
    private final IBoxMode mode;
    private final int spacer;
    private int wholeBounds = 0;
    private IntConsumer consumer;

    public UIScrollBox(IBoxMode mode, int spacer) {
        this.mode = mode;
        this.spacer = spacer;
    }

    public IntConsumer getConsumer() {
        return this.consumer;
    }

    public void setConsumer(IntConsumer consumer) {
        this.consumer = consumer;
    }

    @Override
    public void update() {
        this.wholeBounds = 0;
        for (UIEntity child : this.parent.children) {
            this.mode.setPos(child, this.wholeBounds);
            this.wholeBounds += this.mode.getBounds(child) + this.spacer;
            this.mode.post(child);
        }
        this.consumer.accept(this.wholeBounds);
    }

    public IBoxMode getMode() {
        return this.mode;
    }

    public int getWholeBounds() {
        return this.wholeBounds;
    }

    @Override
    public void draw(DrawInfo info) {
    }
}

