/*
 * Decompiled with CFR 0.152.
 */
package com.troblecodings.guilib.ecs.entitys;

import com.troblecodings.guilib.ecs.GuiConfigHandler;
import com.troblecodings.guilib.ecs.entitys.DrawInfo;
import com.troblecodings.guilib.ecs.entitys.UIEntity;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public abstract class UIComponent {
    protected UIEntity parent = null;
    protected boolean visible = true;
    protected int basicTextColor = GuiConfigHandler.basicTextColor;
    protected int infoTextColor = GuiConfigHandler.infoTextColor;
    protected int errorTextColor = GuiConfigHandler.errorTextColor;

    public abstract void draw(DrawInfo var1);

    public void exitDraw(DrawInfo info) {
    }

    public abstract void update();

    public void onAdd(UIEntity entity) {
        this.parent = entity;
    }

    public void onRemove(UIEntity entity) {
        this.parent = null;
    }

    public boolean hasParent() {
        return this.parent != null;
    }

    public void onClosed() {
    }

    public void postDraw(DrawInfo info) {
    }

    public void keyEvent(UIEntity.KeyEvent event) {
    }

    public void mouseEvent(UIEntity.MouseEvent event) {
    }

    public void updateEvent(UIEntity.UpdateEvent event) {
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public UIEntity getParent() {
        return this.parent;
    }

    public int getBasicTextColor() {
        return this.basicTextColor;
    }

    public int getInfoTextColor() {
        return this.infoTextColor;
    }

    public int getErrorTextColor() {
        return this.errorTextColor;
    }
}

