/*
 * Decompiled with CFR 0.152.
 */
package com.troblecodings.core.net;

import com.troblecodings.core.WriteBuffer;
import com.troblecodings.core.interfaces.INetworkSync;
import io.netty.buffer.Unpooled;
import java.nio.ByteBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.client.CPacketCustomPayload;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLEventChannel;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Logger;

public class NetworkHandler {
    private final FMLEventChannel channel = NetworkRegistry.INSTANCE.newEventDrivenChannel("guisyncnet");
    private static final String CHANNELNAME = "guisyncnet";

    public NetworkHandler(String modid, Logger logger) {
        this.channel.register((Object)this);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void clientEvent(FMLNetworkEvent.ClientCustomPacketEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_152344_a(() -> {
            Container menu = mc.field_71439_g.field_71070_bA;
            if (menu instanceof INetworkSync) {
                ((INetworkSync)menu).deserializeClient(event.getPacket().payload().nioBuffer());
            }
        });
    }

    @SubscribeEvent
    public void serverEvent(FMLNetworkEvent.ServerCustomPacketEvent event) {
        NetHandlerPlayServer handler = (NetHandlerPlayServer)event.getHandler();
        handler.field_147369_b.field_71133_b.func_152344_a(() -> {
            Container menu = handler.field_147369_b.field_71070_bA;
            if (menu instanceof INetworkSync) {
                ((INetworkSync)menu).deserializeServer(event.getPacket().payload().nioBuffer());
            }
        });
    }

    public void sendTo(EntityPlayer player, WriteBuffer buffer) {
        this.sendTo(player, buffer.build());
    }

    public void sendTo(EntityPlayer player, ByteBuffer buf) {
        PacketBuffer buffer = new PacketBuffer(Unpooled.copiedBuffer((ByteBuffer)((ByteBuffer)buf.position(0))));
        if (player instanceof EntityPlayerMP) {
            EntityPlayerMP server = (EntityPlayerMP)player;
            this.channel.sendTo(new FMLProxyPacket(buffer, CHANNELNAME), server);
        } else {
            this.channel.sendToServer(new FMLProxyPacket(new CPacketCustomPayload(CHANNELNAME, buffer)));
        }
    }
}

