/*
 * Decompiled with CFR 0.152.
 */
package com.animania.addons.extra.common.handler;

import com.animania.addons.extra.common.entity.amphibians.EntityAmphibian;
import com.animania.addons.extra.common.entity.amphibians.EntityFrogs;
import com.animania.addons.extra.common.entity.amphibians.EntityToad;
import com.animania.addons.extra.common.entity.peafowl.EntityAnimaniaPeacock;
import com.animania.addons.extra.common.entity.peafowl.EntityPeachickBase;
import com.animania.addons.extra.common.entity.peafowl.EntityPeacockBase;
import com.animania.addons.extra.common.entity.peafowl.PeacockType;
import com.animania.addons.extra.common.entity.rodents.EntityFerretBase;
import com.animania.addons.extra.common.entity.rodents.EntityFerretGrey;
import com.animania.addons.extra.common.entity.rodents.EntityFerretWhite;
import com.animania.addons.extra.common.entity.rodents.EntityHamster;
import com.animania.addons.extra.common.entity.rodents.EntityHedgehog;
import com.animania.addons.extra.common.entity.rodents.EntityHedgehogBase;
import com.animania.addons.extra.common.handler.ExtraAddonSoundHandler;
import com.animania.api.interfaces.IFoodEating;
import com.animania.common.entities.generic.ai.GenericAINearestAttackableTarget;
import com.animania.common.entities.generic.ai.GenericAITargetNonTamed;
import com.animania.common.handler.AddonInjectionHandler;
import com.animania.common.helper.AnimaniaHelper;
import com.animania.common.tileentities.TileEntityNest;
import com.animania.config.AnimaniaConfig;
import java.util.List;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

public class ExtraAddonInjectionHandler {
    public static String ID = "extra";

    public static void preInit() {
        AddonInjectionHandler.addInjection((String)ID, (String)"nestHatchPeafowl", args -> {
            TileEntityNest te = (TileEntityNest)args[0];
            World worldIn = (World)args[1];
            BlockPos pos = (BlockPos)args[2];
            IBlockState state = (IBlockState)args[3];
            Random rand = (Random)args[4];
            if (te.getBirdType() instanceof PeacockType) {
                List peacocks = AnimaniaHelper.getEntitiesInRange(EntityPeacockBase.class, (double)3.0, (World)worldIn, (BlockPos)pos);
                List nearbyPeacocks = AnimaniaHelper.getEntitiesInRange(EntityAnimaniaPeacock.class, (double)15.0, (World)worldIn, (BlockPos)pos);
                if (nearbyPeacocks.size() < AnimaniaConfig.careAndFeeding.entityBreedingLimit) {
                    PeacockType birdType = (PeacockType)te.getBirdType();
                    for (EntityPeacockBase peacock : peacocks) {
                        if (rand.nextInt(AnimaniaConfig.careAndFeeding.eggHatchChance) >= 1) continue;
                        PeacockType chickType = PeacockType.breed(peacock.type, birdType);
                        EntityPeachickBase chick = chickType.getChild(worldIn);
                        chick.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.2, (double)pos.func_177952_p() + 0.5);
                        AnimaniaHelper.spawnEntity((World)worldIn, (Entity)chick);
                        chick.func_184185_a(ExtraAddonSoundHandler.peacock1, 0.5f, 1.4f);
                        te.removeItem();
                        te.func_70296_d();
                        break;
                    }
                }
            }
            return null;
        });
        AddonInjectionHandler.addInjection((String)ID, (String)"attackFrogs", args -> {
            EntityCreature entity = (EntityCreature)args[0];
            if (entity instanceof EntityTameable) {
                entity.field_70715_bh.func_75776_a(2, (EntityAIBase)new GenericAITargetNonTamed((EntityTameable)entity, EntityAnimal.class, false, target -> target instanceof EntityFrogs || target instanceof EntityToad));
            } else {
                entity.field_70715_bh.func_75776_a(2, (EntityAIBase)new GenericAINearestAttackableTarget(entity, EntityAnimal.class, 80, false, false, target -> target instanceof EntityFrogs || target instanceof EntityToad));
            }
            return null;
        });
        AddonInjectionHandler.addInjection((String)ID, (String)"attackPeachicks", args -> {
            EntityCreature entity = (EntityCreature)args[0];
            if (entity instanceof EntityTameable) {
                entity.field_70715_bh.func_75776_a(2, (EntityAIBase)new GenericAITargetNonTamed((EntityTameable)entity, EntityAnimal.class, false, target -> target instanceof EntityPeachickBase));
            } else {
                entity.field_70715_bh.func_75776_a(2, (EntityAIBase)new GenericAINearestAttackableTarget(entity, EntityAnimal.class, 80, false, false, target -> target instanceof EntityPeachickBase));
            }
            return null;
        });
        AddonInjectionHandler.addInjection((String)ID, (String)"attackRodents", args -> {
            EntityCreature entity = (EntityCreature)args[0];
            if (entity instanceof EntityTameable) {
                entity.field_70715_bh.func_75776_a(2, (EntityAIBase)new GenericAITargetNonTamed((EntityTameable)entity, EntityAnimal.class, false, target -> target instanceof EntityHamster || target instanceof EntityFerretBase || target instanceof EntityHedgehogBase));
            } else {
                entity.field_70715_bh.func_75776_a(2, (EntityAIBase)new GenericAINearestAttackableTarget(entity, EntityAnimal.class, 80, false, false, target -> target instanceof EntityHamster || target instanceof EntityFerretBase || target instanceof EntityHedgehogBase));
            }
            return null;
        });
        AddonInjectionHandler.addInjection((String)ID, (String)"rodentEggEvent", args -> {
            Entity entity = (Entity)args[0];
            int x2 = (Integer)args[1];
            int y2 = (Integer)args[2];
            int z2 = (Integer)args[3];
            PlayerInteractEvent.RightClickItem event = (PlayerInteractEvent.RightClickItem)args[4];
            if (entity != null && x2 <= 3 && y2 <= 2 && z2 <= 3 && (entity instanceof EntityFerretWhite || entity instanceof EntityFerretGrey || entity instanceof EntityHedgehog)) {
                event.getEntityPlayer().func_184609_a(event.getHand());
                event.isCanceled();
                event.setCanceled(true);
            }
            return null;
        });
        AddonInjectionHandler.addInjection((String)ID, (String)"eatFrogs", args -> {
            Entity entity = (Entity)args[0];
            IFoodEating animal = (IFoodEating)args[1];
            if (entity instanceof EntityAmphibian) {
                animal.setFed(true);
            }
            return null;
        });
    }
}

