/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.libVulpes.util;

import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;
import zmaster587.libVulpes.LibVulpes;
import zmaster587.libVulpes.interfaces.IRecipe;
import zmaster587.libVulpes.recipe.NumberedOreDictStack;
import zmaster587.libVulpes.recipe.RecipesMachine;
import zmaster587.libVulpes.tile.TileEntityMachine;

public class XMLRecipeLoader {
    Document doc = null;
    String fileName = "";

    public boolean loadFile(File xmlFile) throws IOException {
        DocumentBuilder docBuilder;
        this.doc = null;
        try {
            docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            return false;
        }
        try {
            this.doc = docBuilder.parse(xmlFile);
        }
        catch (SAXException e) {
            e.printStackTrace();
            return false;
        }
        this.fileName = xmlFile.getAbsolutePath();
        return true;
    }

    public void registerRecipes(Class<? extends TileEntityMachine> clazz) {
        Node defaultNode;
        Node masterNode = this.doc.getElementsByTagName("Recipes").item(0);
        int recipeNum = 1;
        if (masterNode.hasAttributes() && (defaultNode = masterNode.getAttributes().getNamedItem("useDefault")) != null && defaultNode.getNodeValue().equals("false")) {
            RecipesMachine.getInstance().clearRecipes(clazz);
        }
        masterNode = masterNode.getChildNodes().item(1);
        while (masterNode != null) {
            try {
                int time = 200;
                int energy = 0;
                if (masterNode.getNodeType() != 1) {
                    masterNode = masterNode.getNextSibling();
                    continue;
                }
                if (!masterNode.getNodeName().equals("Recipe")) {
                    LibVulpes.logger.warn("Expected \"Recipe\" Node in " + this.fileName + ", found " + masterNode.getNodeName() + "!  Skipping.");
                    masterNode = masterNode.getNextSibling();
                    continue;
                }
                Node inputNode = null;
                Node outputNode = null;
                for (int i = 0; i < masterNode.getChildNodes().getLength(); ++i) {
                    Node node = masterNode.getChildNodes().item(i);
                    if (node.getNodeName().equals("input")) {
                        inputNode = node;
                        continue;
                    }
                    if (!node.getNodeName().equals("output")) continue;
                    outputNode = node;
                }
                if (outputNode == null) {
                    masterNode = masterNode.getNextSibling();
                    LibVulpes.logger.warn("Missing \"output\" Node in recipe " + recipeNum + " in " + this.fileName + "!  Skipping.");
                    ++recipeNum;
                    continue;
                }
                if (inputNode == null) {
                    masterNode = masterNode.getNextSibling();
                    LibVulpes.logger.warn("Missing \"input\" Node in recipe " + recipeNum + " in " + this.fileName + "!  Skipping.");
                    ++recipeNum;
                    continue;
                }
                LinkedList<Object> inputList = new LinkedList<Object>();
                for (int i = 0; i < inputNode.getChildNodes().getLength(); ++i) {
                    Node node = inputNode.getChildNodes().item(i);
                    if (node.getNodeType() != 1) continue;
                    Object obj = this.parseItemType(node, false);
                    if (obj == null) {
                        LibVulpes.logger.warn("Invalid item \"input\" (" + node.getNodeName() + " " + node.getTextContent() + ") in recipe " + recipeNum + " in " + this.fileName + "!  Skipping.");
                        continue;
                    }
                    inputList.add(obj);
                }
                LinkedList<Object> outputList = new LinkedList<Object>();
                for (int i = 0; i < outputNode.getChildNodes().getLength(); ++i) {
                    Node node = outputNode.getChildNodes().item(i);
                    if (node.getNodeType() != 1) continue;
                    Object obj = this.parseItemType(node, true);
                    if (obj == null) {
                        LibVulpes.logger.warn("Invalid item \"output\" (" + node.getNodeName() + " " + node.getTextContent() + ") in recipe " + recipeNum + " in " + this.fileName + "!  Skipping.");
                        continue;
                    }
                    outputList.add(obj);
                }
                if (masterNode.hasAttributes()) {
                    Node node = masterNode.getAttributes().getNamedItem("timeRequired");
                    if (node != null && !node.getNodeValue().isEmpty()) {
                        try {
                            time = Integer.parseInt(node.getNodeValue());
                        }
                        catch (NumberFormatException e) {
                            LibVulpes.logger.warn("Recipe " + recipeNum + " has no time value");
                        }
                    }
                    if ((node = masterNode.getAttributes().getNamedItem("power")) != null && !node.getNodeValue().isEmpty()) {
                        try {
                            energy = Integer.parseInt(node.getNodeValue());
                        }
                        catch (NumberFormatException e) {
                            LibVulpes.logger.warn("Recipe " + recipeNum + " has no power value");
                        }
                    }
                } else {
                    LibVulpes.logger.info("Recipe " + recipeNum + " has no time or power consumption");
                }
                if (outputList.isEmpty()) {
                    LibVulpes.logger.info("Output List empty in recipe " + recipeNum);
                } else {
                    RecipesMachine.getInstance().addRecipe(clazz, outputList, time, energy, inputList);
                    LibVulpes.logger.info("Sucessfully added recipe to " + clazz.getName() + " for " + ((Object)inputList).toString() + " -> " + ((Object)outputList).toString());
                }
            }
            catch (Exception e) {
                LibVulpes.logger.warn("Recipe entry #" + recipeNum + " load failed for '" + clazz.getCanonicalName() + "'!");
            }
            ++recipeNum;
            masterNode = masterNode.getNextSibling();
        }
    }

    public Object parseItemType(Node node, boolean output) {
        switch (node.getNodeName()) {
            case "itemStack": {
                String text = node.getTextContent();
                String[] splitStr = text.contains(";") ? text.split(";") : text.split(" ");
                String name = splitStr[0].trim();
                int meta = 0;
                int size = 1;
                if (splitStr.length > 1) {
                    try {
                        size = Integer.parseInt(splitStr[1].trim());
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (splitStr.length > 2) {
                    try {
                        meta = Integer.parseInt(splitStr[2].trim());
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                ItemStack stack = ItemStack.field_190927_a;
                Block block = Block.func_149684_b((String)name);
                if (block == null) {
                    Item item = Item.func_111206_d((String)name);
                    if (item != null) {
                        stack = new ItemStack(item, size, meta);
                    }
                } else {
                    stack = new ItemStack(block, size, meta);
                }
                return stack;
            }
            case "oreDict": {
                String text = node.getTextContent();
                String[] splitStr = text.contains(";") ? text.split(";") : text.split(" ");
                String name = splitStr[0].trim();
                if (!OreDictionary.doesOreNameExist((String)name)) break;
                Object ret = name;
                int number = 1;
                if (splitStr.length > 1) {
                    try {
                        number = Integer.parseInt(splitStr[1].trim());
                    }
                    catch (NumberFormatException stack) {
                        // empty catch block
                    }
                }
                if (splitStr.length >= 1) {
                    if (output) {
                        NonNullList list = OreDictionary.getOres((String)name);
                        if (!list.isEmpty()) {
                            ItemStack oreDict = (ItemStack)OreDictionary.getOres((String)name).get(0);
                            ret = new ItemStack(oreDict.func_77973_b(), number, oreDict.func_77960_j());
                        }
                    } else {
                        ret = new NumberedOreDictStack(name, number);
                    }
                }
                return ret;
            }
            case "fluidStack": {
                String text = node.getTextContent();
                String[] splitStr = text.contains(";") ? text.split(";") : text.split(" ");
                Fluid fluid = FluidRegistry.getFluid((String)splitStr[0].trim());
                if (fluid == null) break;
                int amount = 1000;
                if (splitStr.length > 1) {
                    try {
                        amount = Integer.parseInt(splitStr[1].trim());
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                return new FluidStack(fluid, amount);
            }
        }
        return null;
    }

    public static String writeRecipe(IRecipe recipe) {
        int index = 0;
        StringBuilder string = new StringBuilder("\t<Recipe timeRequired=\"" + recipe.getTime() + "\" power =\"" + recipe.getPower() + "\">\n\t\t<input>\n");
        for (List<ItemStack> list : recipe.getIngredients()) {
            String oreStr;
            if (list.isEmpty()) continue;
            ItemStack stack = list.get(0);
            if ((oreStr = recipe.getOreDictString(index++)) != null) {
                string.append("\t\t\t<oreDict>").append(oreStr).append(stack.func_190916_E() > 1 ? ";" + stack.func_190916_E() : "").append("</oreDict>\n");
                continue;
            }
            string.append("\t\t\t<itemStack>").append(stack.func_77973_b().delegate.name()).append(stack.func_190916_E() > 1 ? ";" + stack.func_190916_E() : (stack.func_77952_i() > 0 ? ";1" : "")).append(stack.func_77952_i() > 0 ? ";" + stack.func_77952_i() : "").append("</itemStack>\n");
        }
        for (FluidStack fluidStack : recipe.getFluidIngredients()) {
            string.append("\t\t\t<fluidStack>").append(FluidRegistry.getDefaultFluidName((Fluid)fluidStack.getFluid()).split(":")[1]).append(";").append(fluidStack.amount).append("</fluidStack>\n");
        }
        string.append("\t\t</input>\n\t\t<output>\n");
        for (ItemStack itemStack : recipe.getOutput()) {
            string.append("\t\t\t<itemStack>").append(itemStack.func_77973_b().delegate.name()).append(itemStack.func_190916_E() > 1 ? ";" + itemStack.func_190916_E() : (itemStack.func_77952_i() > 0 ? ";1" : "")).append(itemStack.func_77952_i() > 0 ? ";" + itemStack.func_77952_i() : "").append("</itemStack>\n");
        }
        for (FluidStack fluidStack : recipe.getFluidOutputs()) {
            string.append("\t\t\t<fluidStack>").append(FluidRegistry.getDefaultFluidName((Fluid)fluidStack.getFluid()).split(":")[1]).append(";").append(fluidStack.amount).append("</fluidStack>\n");
        }
        string.append("\t\t</output>\n\t</Recipe>");
        return string.toString();
    }
}

