/*
 * Decompiled with CFR 0.152.
 */
package bletch.tektopiatrader.entities;

import bletch.common.entities.EntityVendorBase;
import bletch.common.entities.ai.EntityAILeaveVillage;
import bletch.common.entities.ai.EntityAIVisitVillage;
import bletch.common.entities.ai.EntityAIWanderVillage;
import bletch.tektopiatrader.core.ModConfig;
import bletch.tektopiatrader.utils.LoggerUtils;
import java.util.ArrayList;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.World;
import net.tangotek.tektopia.Village;
import net.tangotek.tektopia.entities.EntityVillagerTek;
import net.tangotek.tektopia.tickjob.TickJob;

public class EntityTrader
extends EntityVendorBase {
    public static final String ENTITY_NAME = "trader";
    public static final String MODEL_NAME = "trader";
    public static final String RESOURCE_PATH = "trader";
    public static final String ANIMATION_MODEL_NAME = "trader_m";

    public EntityTrader(World worldIn) {
        super(worldIn, "tektopiatrader");
    }

    public void attachToVillage(Village village) {
        super.attachToVillage(village);
        LoggerUtils.instance.info("Attaching to village", true);
    }

    @Override
    protected void checkStuck() {
        if (this.firstCheck.func_177951_i((Vec3i)this.func_190671_u_()) < 20.0) {
            LoggerUtils.instance.info("Killing self...failed to find a way to the village.", true);
            this.func_70106_y();
        }
    }

    protected void detachVillage() {
        super.detachVillage();
        LoggerUtils.instance.info("Detaching from village", true);
    }

    public ITextComponent func_145748_c_() {
        TextComponentTranslation itextcomponent = new TextComponentTranslation("entity.trader.name", new Object[0]);
        itextcomponent.func_150256_b().func_150209_a(this.func_174823_aP());
        itextcomponent.func_150256_b().func_179989_a(this.func_189512_bd());
        return itextcomponent;
    }

    @Override
    protected void populateBuyingList() {
        if (this.vendorList == null && this.hasVillage()) {
            this.vendorList = new MerchantRecipeList();
            ArrayList<ItemStack> itemStackList = new ArrayList<ItemStack>();
            if (ModConfig.trader.trades != null && ModConfig.trader.trades.length > 0) {
                for (String tradeItem : ModConfig.trader.trades) {
                    Item item;
                    if (tradeItem == null || tradeItem.trim().equals("")) continue;
                    String[] itemParts = tradeItem.split("[*]");
                    String itemName = itemParts[0];
                    int quantity = 1;
                    if (itemParts.length > 1) {
                        try {
                            quantity = Integer.parseInt(itemParts[1]);
                        }
                        catch (NumberFormatException ex) {
                            quantity = 1;
                        }
                    }
                    if ((item = Item.func_111206_d((String)itemName)) == null) continue;
                    itemStackList.add(new ItemStack(item, quantity));
                }
            }
            if (itemStackList.size() == 0) {
                itemStackList.add(new ItemStack(Items.field_151042_j, 64));
                itemStackList.add(new ItemStack(Items.field_151043_k, 32));
                itemStackList.add(new ItemStack(Items.field_151045_i, 8));
                itemStackList.add(new ItemStack(Blocks.field_150451_bX, 8));
                itemStackList.add(new ItemStack(Blocks.field_150368_y, 8));
            }
            int tradesPerDay = Math.max(1, Math.min(99999, ModConfig.trader.tradesPerDay));
            for (ItemStack itemStack : itemStackList) {
                if (itemStack == null) continue;
                this.vendorList.add((Object)new MerchantRecipe(itemStack, ItemStack.field_190927_a, new ItemStack(Items.field_151166_bC, 1), 0, tradesPerDay));
            }
        }
    }

    @Override
    protected void setupAITasks() {
        this.addTask(30, new EntityAILeaveVillage(this, e -> !e.isWorkTime(), e -> e.getVillage().getEdgeNode(), EntityVillagerTek.MovementMode.WALK, null, () -> {
            LoggerUtils.instance.info("Killing self...left the village", true);
            this.func_70106_y();
        }));
        this.addTask(40, (EntityAIBase)new EntityAIWanderVillage(this, e -> e.isWorkTime(), 3, 60));
        this.addTask(50, new EntityAIVisitVillage(this, e -> e.isWorkTime() && !this.isTrading(), e -> e.getVillage().getLastVillagerPos(), EntityVillagerTek.MovementMode.WALK, null, null));
    }

    protected void setupServerJobs() {
        super.setupServerJobs();
        this.addJob(new TickJob(100, 0, false, () -> this.prepStuck()));
        this.addJob(new TickJob(400, 0, false, () -> this.checkStuck()));
        this.addJob(new TickJob(300, 100, true, () -> {
            if (!this.hasVillage() || !this.getVillage().isValid()) {
                LoggerUtils.instance.info("Killing self...no village", true);
                this.func_70106_y();
            }
        }));
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
    }

    static {
        EntityTrader.setupCraftStudioAnimations("tektopiatrader", ANIMATION_MODEL_NAME);
    }
}

