/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.providers;

import com.google.common.base.Strings;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import mcp.mobius.waila.api.ITaggedList;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.utils.InventoryUtils;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityEnderChest;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.ILockableContainer;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import snownee.jade.ModConfig;
import snownee.jade.Util;

public class ItemHandlerProvider
implements IWailaDataProvider {
    public static final ItemHandlerProvider INSTANCE = new ItemHandlerProvider();
    public static Set<String> INVENTORY_IGNORE = Collections.EMPTY_SET;

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        if (!config.getConfig("capability.inventoryinfo") || accessor.getTileEntity() == null || accessor.getTileEntity().getClass() == TileEntityFurnace.class) {
            return currenttip;
        }
        if (accessor.getNBTData().func_74764_b("locked") && accessor.getNBTData().func_74767_n("locked")) {
            currenttip.add(I18n.func_135052_a((String)"jade.locked", (Object[])new Object[0]));
        } else if (accessor.getNBTData().func_74764_b("handler")) {
            int handlerSize = accessor.getNBTData().func_74762_e("handlerSize");
            ItemStackHandler itemHandler = new ItemStackHandler();
            itemHandler.setSize(handlerSize);
            InventoryUtils.populateInv((IItemHandlerModifiable)itemHandler, (NBTTagList)accessor.getNBTData().func_150295_c("handler", 10));
            String renderString = "";
            int drawnCount = 0;
            int realSize = 0;
            for (int i = 0; i < itemHandler.getSlots(); ++i) {
                ItemStack stack = itemHandler.getStackInSlot(i);
                if (stack.func_190926_b()) continue;
                ++realSize;
            }
            boolean showName = realSize < 5;
            for (int i = 0; i < itemHandler.getSlots(); ++i) {
                ItemStack stack = itemHandler.getStackInSlot(i);
                if (stack.func_190926_b()) continue;
                if (i > 0 && (showName || drawnCount >= ModConfig.inventoryShowItemPreLine)) {
                    currenttip.add(renderString);
                    renderString = "";
                    drawnCount = 0;
                }
                renderString = renderString + Util.wailaStack(stack);
                if (showName) {
                    renderString = renderString + Util.offsetText(TextFormatting.WHITE + stack.func_82833_r(), 0, 4);
                }
                ++drawnCount;
            }
            if (!Strings.isNullOrEmpty((String)renderString)) {
                ((ITaggedList)currenttip).add((Object)renderString, (Object)"IItemHandler");
            }
        }
        return currenttip;
    }

    @Nonnull
    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, BlockPos pos) {
        if (te != null && !INVENTORY_IGNORE.contains(tag.func_74779_i("id")) && te.getClass() != TileEntityFurnace.class) {
            if ((player.func_70093_af() ? ModConfig.inventorySneakShowAmount : ModConfig.inventoryNormalShowAmount) == 0) {
                return tag;
            }
            tag.func_82580_o("Items");
            IItemHandler itemHandler = null;
            if (!ModConfig.bypassLockedContainer && !player.func_184812_l_() && !player.func_175149_v() && te instanceof ILockableContainer) {
                ILockableContainer ilockablecontainer = (ILockableContainer)te;
                if (ilockablecontainer.func_174893_q_() && !player.func_175146_a(ilockablecontainer.func_174891_i())) {
                    tag.func_74757_a("locked", true);
                    return tag;
                }
            } else if (te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
                itemHandler = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            } else if (te instanceof IInventory) {
                itemHandler = new InvWrapper((IInventory)te);
            } else if (te instanceof TileEntityEnderChest) {
                itemHandler = new InvWrapper((IInventory)player.func_71005_bN());
            }
            if (itemHandler != null) {
                int size = player.func_70093_af() ? ModConfig.inventorySneakShowAmount : ModConfig.inventoryNormalShowAmount;
                tag.func_74782_a("handler", (NBTBase)InventoryUtils.invToNBT((IItemHandler)itemHandler, (int)size));
                tag.func_74768_a("handlerSize", size);
            }
        }
        return tag;
    }
}

