/*
 * Decompiled with CFR 0.152.
 */
package thut.core.common.terrain;

import com.google.common.base.Predicate;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import thut.api.maths.Vector3;
import thut.api.terrain.BiomeType;
import thut.api.terrain.TerrainSegment;

public class ConfigTerrainChecker
implements TerrainSegment.ISubBiomeChecker {
    private final List<Predicate<IBlockState>> list;
    private final BiomeType subbiome;

    public ConfigTerrainChecker(List<Predicate<IBlockState>> list, BiomeType subbiome) {
        this.list = list;
        this.subbiome = subbiome;
    }

    private boolean apply(IBlockState state) {
        if (state.func_185904_a() == Material.field_151579_a) {
            return false;
        }
        for (Predicate<IBlockState> predicate : this.list) {
            if (!predicate.apply((Object)state)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getSubBiome(World world, Vector3 v, TerrainSegment segment, Chunk chunk, boolean caveAdjusted) {
        if (caveAdjusted) {
            Vector3 temp1 = Vector3.getNewVector();
            int x0 = segment.chunkX * 16;
            int y0 = segment.chunkY * 16;
            int z0 = segment.chunkZ * 16;
            int dx = (v.intX() - x0) / 4 * 4;
            int dy = (v.intY() - y0) / 4 * 4;
            int dz = (v.intZ() - z0) / 4 * 4;
            int x1 = x0 + dx;
            int y1 = y0 + dy;
            int z1 = z0 + dz;
            for (int i = x1; i < x1 + 4; ++i) {
                for (int j = y1; j < y1 + 4; ++j) {
                    for (int k = z1; k < z1 + 4; ++k) {
                        temp1.set(i, j, k);
                        if (!this.apply(temp1.getBlockState((IBlockAccess)world))) continue;
                        return this.subbiome.getType();
                    }
                }
            }
        }
        return -1;
    }
}

