/*
 * Decompiled with CFR 0.152.
 */
package thut.core.client.render.particle;

import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.entity.Entity;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class VanillaLikeParticle
extends Particle {
    ResourceLocation textureMap = null;

    protected VanillaLikeParticle(World worldIn, double xCoordIn, double yCoordIn, double zCoordIn) {
        super(worldIn, xCoordIn, yCoordIn, zCoordIn);
    }

    public void func_180434_a(BufferBuilder worldRendererIn, Entity entityIn, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
        if (this.textureMap != null) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(this.textureMap);
        }
        super.func_180434_a(worldRendererIn, entityIn, partialTicks, rotationX, rotationZ, rotationYZ, rotationXY, rotationXZ);
    }

    public static class ParticleAurora
    extends VanillaLikeParticle {
        private int speed = 2;
        private int start = 0;

        protected ParticleAurora(World worldIn, double xCoordIn, double yCoordIn, double zCoordIn) {
            super(worldIn, xCoordIn, yCoordIn, zCoordIn);
        }

        @Override
        public void func_180434_a(BufferBuilder worldRendererIn, Entity entityIn, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
            this.setColour();
            super.func_180434_a(worldRendererIn, entityIn, partialTicks, rotationX, rotationZ, rotationYZ, rotationXY, rotationXZ);
        }

        private void setColour() {
            int time = this.field_70546_d + this.start;
            int num = time / this.speed % 16;
            int rgba = EnumDyeColor.func_176764_b((int)num).func_193350_e();
            float red = (float)(rgba >> 16 & 0xFF) / 255.0f;
            float green = (float)(rgba >> 8 & 0xFF) / 255.0f;
            float blue = (float)(rgba & 0xFF) / 255.0f;
            this.func_70538_b(red, green, blue);
        }
    }

    public static class AuroraParticleFactory
    implements IParticleFactory {
        private ResourceLocation textureMap;

        public AuroraParticleFactory(ResourceLocation textureMap) {
            this.textureMap = textureMap;
        }

        public Particle func_178902_a(int particleID, World worldIn, double xCoordIn, double yCoordIn, double zCoordIn, double xSpeedIn, double ySpeedIn, double zSpeedIn, int ... args) {
            ParticleAurora particle = new ParticleAurora(worldIn, xCoordIn, yCoordIn, zCoordIn);
            particle.textureMap = this.textureMap;
            particle.start = (int)(worldIn.func_82737_E() % 100000L);
            if (args.length > 0) {
                int rgba = args[0];
                float alpha = (float)(rgba >> 24 & 0xFF) / 255.0f;
                float red = (float)(rgba >> 16 & 0xFF) / 255.0f;
                float green = (float)(rgba >> 8 & 0xFF) / 255.0f;
                float blue = (float)(rgba & 0xFF) / 255.0f;
                particle.func_82338_g(alpha);
                particle.func_70538_b(red, green, blue);
            }
            if (args.length > 1) {
                particle.func_187114_a(Math.max(2, args[1]));
            }
            return particle;
        }
    }

    public static class VanillaLikeParticleFactory
    implements IParticleFactory {
        private ResourceLocation textureMap;

        public VanillaLikeParticleFactory(ResourceLocation textureMap) {
            this.textureMap = textureMap;
        }

        public Particle func_178902_a(int particleID, World worldIn, double xCoordIn, double yCoordIn, double zCoordIn, double xSpeedIn, double ySpeedIn, double zSpeedIn, int ... args) {
            VanillaLikeParticle particle = new VanillaLikeParticle(worldIn, xCoordIn, yCoordIn, zCoordIn);
            particle.textureMap = this.textureMap;
            if (args.length > 0) {
                int rgba = args[0];
                float alpha = (float)(rgba >> 24 & 0xFF) / 255.0f;
                float red = (float)(rgba >> 16 & 0xFF) / 255.0f;
                float green = (float)(rgba >> 8 & 0xFF) / 255.0f;
                float blue = (float)(rgba & 0xFF) / 255.0f;
                particle.func_82338_g(alpha);
                particle.func_70538_b(red, green, blue);
            }
            if (args.length > 1) {
                particle.func_187114_a(Math.max(2, args[1]));
            }
            return particle;
        }
    }
}

