/*
 * Decompiled with CFR 0.152.
 */
package thut.core.client.render.animation;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import thut.core.client.render.animation.AnimationRegistry;
import thut.core.client.render.tabula.components.Animation;
import thut.core.client.render.tabula.components.AnimationComponent;

public class AnimationBuilder {
    public static Animation build(Node node, @Nullable AnimationRegistry.IPartRenamer renamer) {
        Animation ret = null;
        if (node.getAttributes().getNamedItem("type") == null) {
            return null;
        }
        String animName = node.getAttributes().getNamedItem("type").getNodeValue();
        ret = new Animation();
        ret.name = animName;
        ret.loops = true;
        if (node.getAttributes().getNamedItem("loops") != null) {
            ret.loops = Boolean.parseBoolean(node.getAttributes().getNamedItem("loops").getNodeValue());
        }
        NodeList parts = node.getChildNodes();
        for (int i = 0; i < parts.getLength(); ++i) {
            Node part = parts.item(i);
            if (!part.getNodeName().equals("part")) continue;
            NodeList components = part.getChildNodes();
            String partName = part.getAttributes().getNamedItem("name").getNodeValue();
            if (renamer != null) {
                String[] names = new String[]{partName};
                renamer.convertToIdents(names);
                partName = names[0];
            }
            ArrayList set = Lists.newArrayList();
            for (int j = 0; j < components.getLength(); ++j) {
                String[] vals;
                Node component = components.item(j);
                if (!component.getNodeName().equals("component")) continue;
                AnimationComponent comp = new AnimationComponent();
                Node temp = component.getAttributes().getNamedItem("name");
                if (temp != null) {
                    comp.name = temp.getNodeValue();
                }
                if ((temp = component.getAttributes().getNamedItem("rotChange")) != null) {
                    vals = temp.getNodeValue().split(",");
                    comp.rotChange[0] = Double.parseDouble(vals[0]);
                    comp.rotChange[1] = Double.parseDouble(vals[1]);
                    comp.rotChange[2] = Double.parseDouble(vals[2]);
                }
                if ((temp = component.getAttributes().getNamedItem("posChange")) != null) {
                    vals = temp.getNodeValue().split(",");
                    comp.posChange[0] = Double.parseDouble(vals[0]);
                    comp.posChange[1] = Double.parseDouble(vals[1]);
                    comp.posChange[2] = Double.parseDouble(vals[2]);
                }
                if ((temp = component.getAttributes().getNamedItem("scaleChange")) != null) {
                    vals = temp.getNodeValue().split(",");
                    comp.scaleChange[0] = Double.parseDouble(vals[0]);
                    comp.scaleChange[1] = Double.parseDouble(vals[1]);
                    comp.scaleChange[2] = Double.parseDouble(vals[2]);
                }
                if ((temp = component.getAttributes().getNamedItem("rotOffset")) != null) {
                    vals = temp.getNodeValue().split(",");
                    comp.rotOffset[0] = Double.parseDouble(vals[0]);
                    comp.rotOffset[1] = Double.parseDouble(vals[1]);
                    comp.rotOffset[2] = Double.parseDouble(vals[2]);
                }
                if ((temp = component.getAttributes().getNamedItem("posOffset")) != null) {
                    vals = temp.getNodeValue().split(",");
                    comp.posOffset[0] = Double.parseDouble(vals[0]);
                    comp.posOffset[1] = Double.parseDouble(vals[1]);
                    comp.posOffset[2] = Double.parseDouble(vals[2]);
                }
                if ((temp = component.getAttributes().getNamedItem("scaleOffset")) != null) {
                    vals = temp.getNodeValue().split(",");
                    comp.scaleOffset[0] = Double.parseDouble(vals[0]);
                    comp.scaleOffset[1] = Double.parseDouble(vals[1]);
                    comp.scaleOffset[2] = Double.parseDouble(vals[2]);
                }
                if ((temp = component.getAttributes().getNamedItem("length")) != null) {
                    comp.length = Integer.parseInt(temp.getNodeValue());
                }
                if ((temp = component.getAttributes().getNamedItem("startKey")) != null) {
                    comp.startKey = Integer.parseInt(temp.getNodeValue());
                }
                if ((temp = component.getAttributes().getNamedItem("opacityChange")) != null) {
                    comp.opacityChange = Double.parseDouble(temp.getNodeValue());
                }
                if ((temp = component.getAttributes().getNamedItem("opacityOffset")) != null) {
                    comp.opacityOffset = Double.parseDouble(temp.getNodeValue());
                }
                if ((temp = component.getAttributes().getNamedItem("hidden")) != null) {
                    comp.hidden = Boolean.parseBoolean(temp.getNodeValue());
                }
                set.add(comp);
            }
            if (set.isEmpty()) continue;
            ret.sets.put(partName, set);
        }
        return ret;
    }

    public static void processAnimations(List<Animation> list) {
        ArrayList oldList = Lists.newArrayList(list);
        HashMap splitAnims = Maps.newHashMap();
        for (Animation anim : oldList) {
            AnimationBuilder.splitAnimation(anim, splitAnims);
        }
        list.clear();
        for (List split : splitAnims.values()) {
            list.add(AnimationBuilder.mergeAnimations(split));
        }
    }

    private static void splitAnimation(Animation animIn, Map<Integer, List<Animation>> fill) {
        for (Map.Entry<String, ArrayList<AnimationComponent>> entry : animIn.sets.entrySet()) {
            String key = entry.getKey();
            ArrayList<AnimationComponent> comps = entry.getValue();
            int length = AnimationBuilder.length(comps);
            ArrayList anims = fill.get(length);
            if (anims == null) {
                anims = Lists.newArrayList();
                fill.put(length, anims);
            }
            Animation newAnim = new Animation();
            newAnim.name = animIn.name;
            newAnim.identifier = animIn.identifier;
            newAnim.loops = animIn.loops;
            newAnim.priority = animIn.priority;
            newAnim.sets.put(key, comps);
            anims.add(newAnim);
        }
    }

    private static void addTo(Animation animation, int priority, String part, ArrayList<AnimationComponent> parts) {
        if (animation.sets.containsKey(part) && animation.priority > priority) {
            System.err.println("Already have " + part + ", Skipping.");
        } else {
            animation.sets.put(part, parts);
        }
    }

    private static Animation mergeAnimations(List<Animation> list) {
        if (list.isEmpty()) {
            return null;
        }
        Animation newAnim = new Animation();
        newAnim.name = list.get((int)0).name;
        newAnim.identifier = list.get((int)0).identifier;
        newAnim.loops = list.get((int)0).loops;
        newAnim.priority = list.get((int)0).priority;
        for (Animation anim : list) {
            for (String part : anim.sets.keySet()) {
                AnimationBuilder.addTo(newAnim, anim.priority, part, anim.sets.get(part));
            }
        }
        return newAnim;
    }

    private static int length(List<AnimationComponent> comps) {
        int length = 0;
        for (AnimationComponent comp : comps) {
            length = Math.max(length, comp.startKey + comp.length);
        }
        return length;
    }
}

