/*
 * Decompiled with CFR 0.152.
 */
package thut.api.pathing;

import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import thut.api.maths.Vector3;
import thut.api.pathing.IPathingMob;
import thut.api.pathing.PathPoint;
import thut.api.pathing.ThutPath;
import thut.api.pathing.ThutPathFinder;

public class JPSPather
extends ThutPathFinder {
    public static int Int(double x) {
        return MathHelper.func_76128_c((double)x);
    }

    public JPSPather(IBlockAccess world, IPathingMob entity) {
        super(world, entity);
    }

    public Vector3 findNextLocation(IBlockAccess world, Vector3 e, Vector3 source, Vector3 direction, double range) {
        direction.norm();
        double xprev = source.x;
        double yprev = source.y;
        double zprev = source.z;
        for (double i = 0.0; i < range; i += 0.5) {
            PathPoint point;
            boolean clear;
            double dx = i * direction.x;
            double dy = i * direction.y;
            double dz = i * direction.z;
            double xtest = source.x + dx;
            double ytest = source.y + dy;
            double ztest = source.z + dz;
            if (ytest > 255.0) {
                return null;
            }
            int y = JPSPather.Int(ytest);
            int x = JPSPather.Int(xtest);
            int z = JPSPather.Int(ztest);
            if (!(x == JPSPather.Int(xprev) && y == JPSPather.Int(yprev) && z == JPSPather.Int(zprev) || (clear = this.isSafe(e, point = this.openPoint(x, y, z), direction)))) {
                return Vector3.getNewVector().set(JPSPather.Int(xtest), JPSPather.Int(ytest), JPSPather.Int(ztest));
            }
            yprev = ytest;
            xprev = xtest;
            zprev = ztest;
        }
        return null;
    }

    @Override
    protected int findOptions(Vector3 pokemob, PathPoint current, PathPoint end, PathPoint[] pathOptions) {
        int ret = 0;
        Vector3 here = Vector3.getNewVector().set((Object)current);
        Vector3 dest = Vector3.getNewVector().set((Object)end);
        Vector3 closestToDest = Vector3.getNewVector();
        this.getBlockedPoint(pokemob, here, dest, closestToDest);
        if (closestToDest.sameBlock(dest)) {
            if (!end.isFirst) {
                end.blockWeight = 1.0f;
                pathOptions[ret++] = end;
            }
        } else {
            ret = super.findOptions(pokemob, current, end, pathOptions);
            double size = pokemob.x * pokemob.z;
            if (size < 1.0) {
                size = 0.0;
            }
            if (ret >= 3 && closestToDest.distToSq(here) > 100.0) {
                current = this.openPoint(closestToDest.intX(), closestToDest.intY(), closestToDest.intZ());
                ret = super.findOptions(pokemob, current, end, pathOptions);
            }
        }
        return ret;
    }

    private void getBlockedPoint(Vector3 e, Vector3 here, Vector3 dest, Vector3 temp) {
        Vector3 direction = dest.subtract(here).norm();
        Vector3 t2 = this.findNextLocation(this.worldMap, e, here, direction, here.distanceTo(dest));
        if (t2 != null) {
            temp.set(t2);
            temp.addTo(0.5, 0.0, 0.5).addTo(direction.reverse().scalarMultBy(1.5));
        } else {
            temp.set(dest);
        }
    }

    @Override
    protected PathPoint getSubPath(Vector3 pokemob, PathPoint start, PathPoint end, ThutPath path, float distance) {
        long time;
        PathPoint[] pointf = new PathPoint[]{start, null, null};
        int tries = 0;
        PathPoint point = null;
        long starttime = System.nanoTime();
        do {
            if (!this.pathf.isPathEmpty()) {
                point = this.getPoint(pokemob, pointf, start, end, this.pathf, this.pathOptionsf, true);
            }
            if (point == end) {
                return point;
            }
            if (pointf[0].equals((Object)end)) {
                return pointf[0];
            }
            if (pointf[2] != null && pointf[2].equals((Object)end)) {
                return pointf[2];
            }
            if (this.pathf.isPathEmpty()) {
                // empty if block
            }
            if (!this.pathf.isPathEmpty()) continue;
            return pointf[2];
        } while ((time = System.nanoTime() - starttime) <= (long)this.PATHTIME && ++tries <= 1000);
        return pointf[2];
    }
}

