/*
 * Decompiled with CFR 0.152.
 */
package thut.api;

import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Set;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;

public class WorldCache
implements IBlockAccess {
    public static boolean synchronizeWorlds = true;
    public final World world;
    private final Long2ObjectMap<ChunkCache> map = new Long2ObjectOpenHashMap();
    final Set<ChunkCache> cache = Sets.newConcurrentHashSet();

    public WorldCache(World world_) {
        this.world = world_;
    }

    void addChunk(Chunk chunk) {
        long key = WorldCache.asLong(chunk.field_76635_g, chunk.field_76647_h);
        ChunkCache chunkcache = new ChunkCache(chunk);
        this.map.put(key, (Object)chunkcache);
        this.cache.add(chunkcache);
    }

    public boolean extendedLevelsInChunkCache() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Biome func_180494_b(BlockPos pos) {
        Biome ret = null;
        World world = this.world;
        synchronized (world) {
            ret = this.world.func_180494_b(pos);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IBlockState func_180495_p(BlockPos pos) {
        int i1;
        if (synchronizeWorlds) {
            World world = this.world;
            synchronized (world) {
                return this.world.func_180495_p(pos);
            }
        }
        int l = pos.func_177958_n() >> 4;
        long key = WorldCache.asLong(l, i1 = pos.func_177952_p() >> 4);
        ChunkCache chunk = (ChunkCache)this.map.get(key);
        if (chunk == null) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return chunk.getBlockState(pos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Chunk getChunk(int chunkX, int chunkZ) {
        if (synchronizeWorlds) {
            World world = this.world;
            synchronized (world) {
                return this.world.func_72964_e(chunkX, chunkZ);
            }
        }
        long key = WorldCache.asLong(chunkX, chunkZ);
        ChunkCache chunkcache = (ChunkCache)this.map.get(key);
        if (chunkcache == null) {
            return null;
        }
        return chunkcache.chunk;
    }

    public int func_175626_b(BlockPos pos, int p_175626_2_) {
        return 0;
    }

    public int func_175627_a(BlockPos pos, EnumFacing direction) {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TileEntity func_175625_s(BlockPos pos) {
        int i1;
        if (synchronizeWorlds) {
            World world = this.world;
            synchronized (world) {
                return this.world.func_175726_f(pos).func_177424_a(pos, Chunk.EnumCreateEntityType.CHECK);
            }
        }
        int l = pos.func_177958_n() >> 4;
        long key = WorldCache.asLong(l, i1 = pos.func_177952_p() >> 4);
        ChunkCache chunk = (ChunkCache)this.map.get(key);
        if (chunk == null) {
            return null;
        }
        return chunk.getTileEntity(pos, Chunk.EnumCreateEntityType.CHECK);
    }

    public WorldType func_175624_G() {
        return this.world.func_72912_H().func_76067_t();
    }

    public boolean func_175623_d(BlockPos pos) {
        IBlockState state = this.func_180495_p(pos);
        return state == null || state.func_177230_c().isAir(state, (IBlockAccess)this, pos);
    }

    public boolean isSideSolid(BlockPos pos, EnumFacing side, boolean _default) {
        int i1;
        int l = pos.func_177958_n() >> 4;
        long key = WorldCache.asLong(l, i1 = pos.func_177952_p() >> 4);
        ChunkCache chunk = (ChunkCache)this.map.get(key);
        if (chunk == null || chunk.isEmpty()) {
            return _default;
        }
        return this.func_180495_p(pos).func_193401_d((IBlockAccess)this, pos, side) == BlockFaceShape.SOLID;
    }

    void removeChunk(Chunk chunk) {
        long key = WorldCache.asLong(chunk.field_76635_g, chunk.field_76647_h);
        ChunkCache chunkcache = (ChunkCache)this.map.remove(key);
        if (chunkcache != null) {
            this.cache.remove(chunkcache);
        }
    }

    public static long asLong(int x, int z) {
        return (long)x & 0xFFFFFFFFL | ((long)z & 0xFFFFFFFFL) << 32;
    }

    public static class ChunkCache {
        Chunk chunk;

        public ChunkCache(Chunk chunk) {
            this.chunk = chunk;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IBlockState getBlockState(BlockPos pos) {
            IBlockState ret = null;
            Chunk chunk = this.chunk;
            synchronized (chunk) {
                ret = this.chunk.func_177435_g(pos);
                if (ret == null) {
                    return Blocks.field_150350_a.func_176223_P();
                }
            }
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TileEntity getTileEntity(BlockPos pos, Chunk.EnumCreateEntityType immediate) {
            TileEntity ret = null;
            Chunk chunk = this.chunk;
            synchronized (chunk) {
                ret = this.chunk.func_177424_a(pos, immediate);
            }
            return ret;
        }

        public boolean isEmpty() {
            return false;
        }
    }
}

