/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.api.transmitters.TransmissionType;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.GuiSideConfiguration;
import mekanism.client.gui.button.GuiButtonDisableableImage;
import mekanism.client.gui.button.GuiColorButton;
import mekanism.client.gui.button.GuiSideDataButton;
import mekanism.client.sound.SoundHandler;
import mekanism.common.Mekanism;
import mekanism.common.SideData;
import mekanism.common.base.ISideConfiguration;
import mekanism.common.inventory.container.ContainerNull;
import mekanism.common.network.PacketConfigurationUpdate;
import mekanism.common.network.PacketSimpleGui;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.prefab.TileEntityContainerBlock;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

@SideOnly(value=Side.CLIENT)
public class GuiTransporterConfig
extends GuiMekanismTile<TileEntityContainerBlock> {
    private Map<Integer, GuiSideConfiguration.GuiPos> slotPosMap = new HashMap<Integer, GuiSideConfiguration.GuiPos>();
    private ISideConfiguration configurable;
    private List<GuiSideDataButton> sideDataButtons = new ArrayList<GuiSideDataButton>();
    private GuiButton backButton;
    private GuiButton strictInputButton;
    private GuiButton colorButton;
    private int buttonID = 0;

    public GuiTransporterConfig(EntityPlayer player, ISideConfiguration tile) {
        super((TileEntityContainerBlock)((Object)tile), new ContainerNull(player, (TileEntityContainerBlock)((Object)tile)));
        this.field_147000_g = 95;
        this.configurable = tile;
        this.slotPosMap.put(0, new GuiSideConfiguration.GuiPos(54, 64));
        this.slotPosMap.put(1, new GuiSideConfiguration.GuiPos(54, 34));
        this.slotPosMap.put(2, new GuiSideConfiguration.GuiPos(54, 49));
        this.slotPosMap.put(3, new GuiSideConfiguration.GuiPos(39, 64));
        this.slotPosMap.put(4, new GuiSideConfiguration.GuiPos(39, 49));
        this.slotPosMap.put(5, new GuiSideConfiguration.GuiPos(69, 49));
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        this.backButton = new GuiButtonDisableableImage(this.buttonID++, this.field_147003_i + 6, this.field_147009_r + 6, 14, 14, 190, 14, -14, this.getGuiLocation());
        this.field_146292_n.add(this.backButton);
        this.strictInputButton = new GuiButtonDisableableImage(this.buttonID++, this.field_147003_i + 156, this.field_147009_r + 6, 14, 14, 204, 14, -14, this.getGuiLocation());
        this.field_146292_n.add(this.strictInputButton);
        this.colorButton = new GuiColorButton(this.buttonID++, this.field_147003_i + 122, this.field_147009_r + 49, 16, 16, () -> this.configurable.getEjector().getOutputColor());
        this.field_146292_n.add(this.colorButton);
        for (int i = 0; i < this.slotPosMap.size(); ++i) {
            GuiSideConfiguration.GuiPos guiPos = this.slotPosMap.get(i);
            EnumFacing facing = EnumFacing.func_82600_a((int)i);
            GuiSideDataButton button = new GuiSideDataButton(this.buttonID++, this.field_147003_i + guiPos.xPos, this.field_147009_r + guiPos.yPos, this.getGuiLocation(), i, () -> this.configurable.getConfig().getOutput(TransmissionType.ITEM, facing), () -> this.configurable.getEjector().getInputColor(facing));
            this.field_146292_n.add(button);
            this.sideDataButtons.add(button);
        }
    }

    protected void func_146284_a(GuiButton guibutton) throws IOException {
        super.func_146284_a(guibutton);
        TileEntity tile = (TileEntity)this.configurable;
        if (guibutton.field_146127_k == this.backButton.field_146127_k) {
            int guiId = Mekanism.proxy.getGuiId(tile.func_145838_q(), tile.func_145832_p());
            Mekanism.packetHandler.sendToServer(new PacketSimpleGui.SimpleGuiMessage(Coord4D.get(tile), 0, guiId));
        } else if (guibutton.field_146127_k == this.strictInputButton.field_146127_k) {
            Mekanism.packetHandler.sendToServer(new PacketConfigurationUpdate.ConfigurationUpdateMessage(PacketConfigurationUpdate.ConfigurationPacket.STRICT_INPUT, Coord4D.get(tile), 0, 0, null));
        } else if (guibutton.field_146127_k == this.colorButton.field_146127_k) {
            Mekanism.packetHandler.sendToServer(new PacketConfigurationUpdate.ConfigurationUpdateMessage(PacketConfigurationUpdate.ConfigurationPacket.EJECT_COLOR, Coord4D.get(tile), Keyboard.isKeyDown((int)42) ? 2 : 0, 0, null));
        } else {
            for (GuiSideDataButton button : this.sideDataButtons) {
                if (guibutton.field_146127_k != button.field_146127_k) continue;
                Mekanism.packetHandler.sendToServer(new PacketConfigurationUpdate.ConfigurationUpdateMessage(PacketConfigurationUpdate.ConfigurationPacket.INPUT_COLOR, Coord4D.get(tile), Keyboard.isKeyDown((int)42) ? 2 : 0, button.getSlotPosMapIndex(), null));
                break;
            }
        }
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        String text = LangUtils.localize("gui.configuration.transporter");
        this.field_146289_q.func_78276_b(text, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(text) / 2, 5, 0x404040);
        text = LangUtils.localize("gui.strictInput") + " (" + LangUtils.transOnOff(this.configurable.getEjector().hasStrictInput()) + ")";
        this.renderScaledText(text, 53, 17, 52480, 70);
        this.field_146289_q.func_78276_b(LangUtils.localize("gui.input"), 48, 81, 0x787878);
        this.field_146289_q.func_78276_b(LangUtils.localize("gui.output"), 114, 68, 0x787878);
        int xAxis = mouseX - this.field_147003_i;
        int yAxis = mouseY - this.field_147009_r;
        for (GuiSideDataButton button : this.sideDataButtons) {
            if (!button.func_146115_a()) continue;
            SideData data = button.getSideData();
            if (data == TileComponentConfig.EMPTY) break;
            EnumColor color = button.getColor();
            this.displayTooltip(color != null ? color.getColoredName() : LangUtils.localize("gui.none"), xAxis, yAxis);
            break;
        }
        if (this.strictInputButton.func_146115_a()) {
            this.displayTooltip(LangUtils.localize("gui.configuration.strictInput"), xAxis, yAxis);
        } else if (this.colorButton.func_146115_a()) {
            if (this.configurable.getEjector().getOutputColor() != null) {
                this.displayTooltip(this.configurable.getEjector().getOutputColor().getColoredName(), xAxis, yAxis);
            } else {
                this.displayTooltip(LangUtils.localize("gui.none"), xAxis, yAxis);
            }
        }
        super.func_146979_b(mouseX, mouseY);
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int button) throws IOException {
        super.func_73864_a(mouseX, mouseY, button);
        if (button == 1) {
            TileEntity tile = (TileEntity)this.configurable;
            if (this.colorButton.func_146115_a()) {
                SoundHandler.playSound(SoundEvents.field_187909_gi);
                Mekanism.packetHandler.sendToServer(new PacketConfigurationUpdate.ConfigurationUpdateMessage(PacketConfigurationUpdate.ConfigurationPacket.EJECT_COLOR, Coord4D.get(tile), 1, 0, null));
            } else {
                for (GuiSideDataButton sideDataButton : this.sideDataButtons) {
                    if (!sideDataButton.func_146115_a()) continue;
                    SoundHandler.playSound(SoundEvents.field_187909_gi);
                    Mekanism.packetHandler.sendToServer(new PacketConfigurationUpdate.ConfigurationUpdateMessage(PacketConfigurationUpdate.ConfigurationPacket.INPUT_COLOR, Coord4D.get(tile), 1, sideDataButton.getSlotPosMapIndex(), null));
                    break;
                }
            }
        }
    }

    @Override
    protected ResourceLocation getGuiLocation() {
        return MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiTransporterConfig.png");
    }
}

