/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.network;

import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import com.tiviacz.travelersbackpack.common.ServerActions;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class CycleToolPacket
implements IMessage {
    public int directionOfCycle;
    public int typeOfAction;

    public CycleToolPacket() {
    }

    public CycleToolPacket(int directionOfCycle, int typeOfAction) {
        this.directionOfCycle = directionOfCycle;
        this.typeOfAction = typeOfAction;
    }

    public void fromBytes(ByteBuf buf) {
        this.directionOfCycle = buf.readInt();
        this.typeOfAction = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.directionOfCycle);
        buf.writeInt(this.typeOfAction);
    }

    public static class Handler
    implements IMessageHandler<CycleToolPacket, IMessage> {
        public IMessage onMessage(CycleToolPacket message, MessageContext ctx) {
            EntityPlayerMP sendingPlayer = ctx.getServerHandler().field_147369_b;
            if (ctx.side.isServer() && sendingPlayer != null && CapabilityUtils.isWearingBackpack((EntityPlayer)sendingPlayer)) {
                WorldServer playerWorldServer = sendingPlayer.func_71121_q();
                if (message.typeOfAction == 0) {
                    playerWorldServer.func_152344_a(() -> ServerActions.cycleTool((EntityPlayer)sendingPlayer, message.directionOfCycle));
                }
                if (message.typeOfAction == 1) {
                    playerWorldServer.func_152344_a(() -> ServerActions.switchHoseMode((EntityPlayer)sendingPlayer, message.directionOfCycle));
                }
                if (message.typeOfAction == 2) {
                    playerWorldServer.func_152344_a(() -> ServerActions.toggleHoseTank((EntityPlayer)sendingPlayer));
                }
                if (message.typeOfAction == 3) {
                    playerWorldServer.func_152344_a(() -> ServerActions.emptyTank(message.directionOfCycle, (EntityPlayer)sendingPlayer, sendingPlayer.field_70170_p));
                }
            }
            return null;
        }
    }
}

