/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.common;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableMap;
import com.tiviacz.travelersbackpack.api.inventory.InventoryRecipe;
import com.tiviacz.travelersbackpack.gui.inventory.IInventoryTanks;
import com.tiviacz.travelersbackpack.util.LogHelper;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public class InventoryRecipesRegistry {
    public static BiMap<String, InventoryRecipe> RECIPE_REGISTRY = HashBiMap.create();
    private static int recipeIDCounter = 0;

    public static void initRecipes() {
        RECIPE_REGISTRY.clear();
    }

    public static int registerRecipe(InventoryRecipe recipe) {
        String className = recipe.getClass().getName();
        if (!RECIPE_REGISTRY.containsKey((Object)className) && recipe.isRecipeNonNull()) {
            RECIPE_REGISTRY.put((Object)className, (Object)recipe);
            recipe.setRecipeID(recipeIDCounter);
            LogHelper.info("Registered the class " + className + " as a InventoryRecipe for " + recipe.getStackIn().func_82833_r() + " with the ID " + recipeIDCounter, new Object[0]);
            return ++recipeIDCounter;
        }
        return -1;
    }

    public static Map<String, InventoryRecipe> getRegisteredInventoryRecipes() {
        return ImmutableMap.copyOf(RECIPE_REGISTRY);
    }

    public static boolean hasStackInInventoryRecipeAndCanProcess(EntityPlayer player, IInventoryTanks inv, ItemStack stackIn, FluidTank tank, int slotIn) {
        for (InventoryRecipe recipe : InventoryRecipesRegistry.getRegisteredInventoryRecipes().values()) {
            if (!stackIn.func_77969_a(recipe.getStackIn()) || !recipe.canProcess(tank, inv.func_70301_a(slotIn + 1))) continue;
            return recipe.processRecipe(player, inv, tank, slotIn, slotIn + 1);
        }
        return false;
    }

    public static InventoryRecipe getInventoryRecipe(ItemStack stackIn, FluidStack fluidstack, int amount, ItemStack stackOut) {
        for (InventoryRecipe recipe : InventoryRecipesRegistry.getRegisteredInventoryRecipes().values()) {
            if (stackIn != recipe.getStackIn() || fluidstack != recipe.getFluidStack() || amount != recipe.getAmount() || stackOut != recipe.getStackOut()) continue;
            return recipe;
        }
        return null;
    }
}

