/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.vehicle.jimphysics.solver.components;

import com.paneedah.weaponlib.vehicle.jimphysics.Engine;
import com.paneedah.weaponlib.vehicle.jimphysics.MechanicalClutch;
import com.paneedah.weaponlib.vehicle.jimphysics.Transmission;
import com.paneedah.weaponlib.vehicle.jimphysics.VehiclePhysUtil;
import com.paneedah.weaponlib.vehicle.jimphysics.engines.FlywheelSolver;
import com.paneedah.weaponlib.vehicle.jimphysics.solver.VehiclePhysicsSolver;

public class EngineSolver {
    public Engine engineTemplate;
    public VehiclePhysicsSolver solver;
    public FlywheelSolver flywheel = new FlywheelSolver(30.0, 0.2, 0.01);
    public double previousRPM;
    public double rpm;

    public EngineSolver(VehiclePhysicsSolver solver, Engine engineTemplate) {
        this.engineTemplate = engineTemplate;
        this.solver = solver;
    }

    public double getDriveTorque() {
        if (!this.solver.vehicle.isVehicleRunning()) {
            return 0.0;
        }
        Transmission t = this.solver.transmission;
        MechanicalClutch clutch = t.getClutch();
        double gearRatio = t.getCurrentGearRatio();
        double finalDriveRatio = t.getDifferentialRatio();
        int redline = this.engineTemplate.getRedline();
        int idleRPM = this.engineTemplate.getIdleRPM();
        int technicalRPM = (int)VehiclePhysUtil.getEngineRPM(this.solver.rearAxel.getWheelAngularVelocity(), gearRatio, finalDriveRatio);
        if (clutch.getSlippage() == 1.0 && !t.inNeutral()) {
            this.rpm = technicalRPM;
            if (this.rpm < (double)idleRPM) {
                this.rpm = idleRPM;
            }
        } else if (clutch.getSlippage() == 0.0 || t.inNeutral()) {
            if (this.rpm < (double)idleRPM) {
                this.rpm = this.engineTemplate.getIdleRPM();
            }
            if (this.rpm > (double)redline) {
                this.rpm = redline;
            }
            double rTorque = this.engineTemplate.getTorqueAtRPM(this.rpm) * this.solver.vehicle.throttle - 200.0;
            this.rpm += rTorque / this.flywheel.inertia * this.solver.timeStep * 60.0 / (Math.PI * 2);
            if (this.rpm < (double)idleRPM) {
                this.rpm = this.engineTemplate.getIdleRPM();
            }
        } else {
            if (this.rpm > (double)redline) {
                this.rpm = redline;
            }
            double tracTorqueAtAxel = this.solver.getTractionTorque();
            double tTorque = tracTorqueAtAxel / (gearRatio * finalDriveRatio);
            double rTorque = this.engineTemplate.getTorqueAtRPM(this.rpm) * this.solver.vehicle.throttle * (1.0 - clutch.getSlippage()) - tTorque * clutch.getSlippage();
            this.rpm += rTorque / this.flywheel.inertia * this.solver.timeStep * 60.0 / (Math.PI * 2);
            if (this.rpm < (double)idleRPM) {
                this.rpm = idleRPM;
            }
        }
        if (this.rpm > (double)redline) {
            this.rpm = redline;
            return 0.0;
        }
        double efficiency = this.solver.configuration.getDriveTrainEfficiency();
        double torque = this.engineTemplate.getTorqueAtRPM(this.rpm);
        double drvT = VehiclePhysUtil.getDriveTorque(torque, gearRatio, finalDriveRatio, efficiency) * this.solver.vehicle.throttle;
        drvT *= clutch.getSlippage();
        if (t.inNeutral()) {
            drvT = 0.0;
        }
        if (clutch.getSlippage() != 1.0 && clutch.getSlippage() != 0.0) {
            drvT *= 10.0;
        }
        return drvT;
    }
}

