/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.vehicle.jimphysics;

public class MechanicalClutch {
    public double engagementPoint = 0.4;
    public double currentPressure = 0.0;
    public double pedalPressure = 0.0;

    public MechanicalClutch(double engagementPoint) {
        this.engagementPoint = engagementPoint;
    }

    public void applyPedalPressure(double p) {
        this.pedalPressure = p;
        this.updatePedalPressure();
    }

    public void addPedalPressure(double p) {
        this.pedalPressure += p;
        if (this.pedalPressure > 1.0) {
            this.pedalPressure = 1.0;
        }
        this.updatePedalPressure();
    }

    public void removePressure(double p) {
        this.pedalPressure -= p;
        if (this.pedalPressure < 0.0) {
            this.pedalPressure = 0.0;
        }
        this.updatePedalPressure();
    }

    public double getPedalPressure() {
        return this.pedalPressure;
    }

    public void updatePedalPressure() {
        this.currentPressure = 1.0 - this.pedalPressure;
    }

    public double getSlippage() {
        this.updatePedalPressure();
        if (this.currentPressure <= this.engagementPoint) {
            return 0.0;
        }
        double mu = (this.currentPressure - this.engagementPoint) / (1.0 - this.engagementPoint);
        return mu;
    }

    public MechanicalClutch clone() {
        return new MechanicalClutch(this.engagementPoint);
    }
}

