/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.vehicle.jimphysics;

import java.util.ArrayList;
import java.util.LinkedHashMap;

public class Engine {
    private int maxRPM = 0;
    private int redlineRPM = 0;
    private int idleRPM = 0;
    private String engineName;
    private String engineBrand;
    public LinkedHashMap<Double, Double> torqueCurve = new LinkedHashMap();

    public Engine(String name, String engineBrand, int maxRPM, int redLine, int idleRPM) {
        this.engineName = name;
        this.engineBrand = engineBrand;
        this.maxRPM = maxRPM;
        this.redlineRPM = redLine;
        this.idleRPM = idleRPM;
        this.setupTorqueCurve();
    }

    public void addPoint(double rpm, double nm) {
        this.torqueCurve.put(rpm, nm);
    }

    public void setupTorqueCurve() {
    }

    public double getTorqueAtRPM(double rpm) {
        if (rpm < (double)this.getIdleRPM()) {
            return 0.0;
        }
        if (this.torqueCurve.containsKey(rpm)) {
            return this.torqueCurve.get(rpm);
        }
        double firstBound = 0.0;
        double secondBound = 0.0;
        ArrayList<Double> keys = new ArrayList<Double>();
        keys.addAll(this.torqueCurve.keySet());
        for (int f = 0; f < keys.size() - 1; ++f) {
            double min = (Double)keys.get(f);
            double max = (Double)keys.get(f + 1);
            if (!(min < rpm) || !(rpm < max)) continue;
            firstBound = min;
            secondBound = max;
        }
        double t1 = this.torqueCurve.get(firstBound);
        double t2 = this.torqueCurve.get(secondBound);
        double tStep = (rpm - firstBound) / (secondBound - firstBound);
        double stepped = t1 + (t2 - t1) * tStep;
        return stepped;
    }

    public int getIdleRPM() {
        return this.idleRPM;
    }

    public String getEngineBrand() {
        return this.engineBrand;
    }

    public String getEngineName() {
        return this.engineName;
    }

    public int getMaxRPM() {
        return this.maxRPM;
    }

    public int getRedline() {
        return this.redlineRPM;
    }
}

