/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.vehicle;

import java.util.Arrays;

public abstract class VehicleSuspensionStrategy {
    protected float rate;
    protected float amplitude;

    public abstract void update(double var1, double var3);

    public float getRate() {
        return this.rate;
    }

    public float getAmplitude() {
        return this.amplitude;
    }

    public static class StepSuspensionStrategy
    extends VehicleSuspensionStrategy {
        private Threshold[] thresholds;

        public StepSuspensionStrategy(float ... data) {
            if (data.length % 3 != 0) {
                throw new IllegalArgumentException();
            }
            this.thresholds = new Threshold[Math.round((float)data.length / 3.0f)];
            int i = 0;
            int j = 0;
            while (i < data.length) {
                this.thresholds[j] = new Threshold();
                this.thresholds[j].speed = data[i];
                this.thresholds[j].rate = data[i + 1];
                this.thresholds[j].amplitude = data[i + 2];
                i += 3;
                ++j;
            }
            Arrays.sort(this.thresholds);
        }

        @Override
        public void update(double speed, double yawDelta) {
            this.amplitude = 0.0f;
            this.rate = 0.0f;
            for (int i = 0; i < this.thresholds.length && speed > (double)this.thresholds[i].speed; ++i) {
                this.rate = this.thresholds[i].rate;
                this.amplitude = this.thresholds[i].amplitude;
            }
        }

        private class Threshold
        implements Comparable<Threshold> {
            float speed;
            float rate;
            float amplitude;

            private Threshold() {
            }

            @Override
            public int compareTo(Threshold o) {
                return Float.compare(this.speed, o.speed);
            }
        }
    }
}

