/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.vehicle;

import com.paneedah.mwc.proxies.ClientProxy;
import com.paneedah.weaponlib.KeyBindings;
import com.paneedah.weaponlib.animation.jim.KeyStateAnimator;
import com.paneedah.weaponlib.render.ScreenRenderer;
import com.paneedah.weaponlib.vehicle.EntityVehicle;
import com.paneedah.weaponlib.vehicle.GearShiftPattern;
import com.paneedah.weaponlib.vehicle.SimpleAnimationTimer;
import com.paneedah.weaponlib.vehicle.jimphysics.InterpolationKit;
import com.paneedah.weaponlib.vehicle.jimphysics.Transmission;
import java.awt.Color;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import org.lwjgl.opengl.GL11;

public class VehicleCustomGUI
extends Gui {
    public static final ScaledResolution SCALE_RES = new ScaledResolution(ClientProxy.MC);
    public static ModelBase keyModel;
    public static ModelBase lockModel;
    public static ResourceLocation keyTex;
    public static ResourceLocation lockTex;
    public KeyStateAnimator keyAnimator = new KeyStateAnimator();
    public float prevRPMAngle = 0.0f;
    public SimpleAnimationTimer sat = null;
    public int oldPOV = 0;
    public int progess = 0;

    public static void setLockAndKeyModels(ModelBase key, ModelBase lock, ResourceLocation keyT, ResourceLocation lockT) {
        keyModel = key;
        lockModel = lock;
        keyTex = lockT;
        lockTex = keyT;
    }

    public void renderNeedle(Color c, double x, double y, double length, double width, float startAngle, float angle, float prevAngle) {
        float red = (float)c.getRed() / 255.0f;
        float blue = (float)c.getBlue() / 255.0f;
        float green = (float)c.getGreen() / 255.0f;
        float alpha = (float)c.getAlpha() / 255.0f;
        double tW = width / 2.0;
        GL11.glPushMatrix();
        GlStateManager.func_179090_x();
        GlStateManager.func_179097_i();
        GlStateManager.func_179141_d();
        GlStateManager.func_179147_l();
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        double interpolatedAng = prevAngle + (angle - prevAngle) * ClientProxy.MC.func_184121_ak();
        GlStateManager.func_179137_b((double)x, (double)y, (double)0.0);
        GlStateManager.func_179114_b((float)((float)interpolatedAng), (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)startAngle, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179137_b((double)-12.0, (double)0.0, (double)0.0);
        Tessellator t = Tessellator.func_178181_a();
        BufferBuilder bb = t.func_178180_c();
        bb.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        bb.func_181662_b(-length, tW, 0.0).func_181666_a(red, green, blue, alpha).func_181675_d();
        bb.func_181662_b(0.0, tW, 0.0).func_181666_a(red, green, blue, alpha).func_181675_d();
        bb.func_181662_b(0.0, -tW, 0.0).func_181666_a(red, green, blue, alpha).func_181675_d();
        bb.func_181662_b(-length, -tW, 0.0).func_181666_a(red, green, blue, alpha).func_181675_d();
        t.func_78381_a();
        GL11.glDisable((int)2881);
        GlStateManager.func_179118_c();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
        GlStateManager.func_179126_j();
        GL11.glPopMatrix();
    }

    public void renderHalfCircle(Color c, double x, double y, int outerRadius, int innerRadius, double beginAngle, double finishAngle) {
        float red = (float)c.getRed() / 255.0f;
        float blue = (float)c.getBlue() / 255.0f;
        float green = (float)c.getGreen() / 255.0f;
        float alpha = (float)c.getAlpha() / 255.0f;
        GL11.glPushMatrix();
        GlStateManager.func_179090_x();
        GlStateManager.func_179097_i();
        GlStateManager.func_179141_d();
        GlStateManager.func_179147_l();
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        Tessellator t = Tessellator.func_178181_a();
        BufferBuilder bb = t.func_178180_c();
        double endAng = 0.0;
        bb.func_181668_a(5, DefaultVertexFormats.field_181706_f);
        for (double a = beginAngle; a < finishAngle; a += 6.0) {
            double cos = -Math.cos(Math.toRadians(a)) * (double)outerRadius;
            double sin = -Math.sin(Math.toRadians(a)) * (double)outerRadius;
            double cosI = -Math.cos(Math.toRadians(a)) * (double)innerRadius;
            double sinI = -Math.sin(Math.toRadians(a)) * (double)innerRadius;
            bb.func_181662_b(x + cos, y + sin, 0.0).func_181666_a(red, green, blue, alpha).func_181675_d();
            bb.func_181662_b(x + cosI, y + sinI, 0.0).func_181666_a(red, green, blue, 1.0f).func_181675_d();
            endAng = a;
        }
        if (endAng != finishAngle) {
            double cos = -Math.cos(Math.toRadians(finishAngle)) * (double)outerRadius;
            double sin = -Math.sin(Math.toRadians(finishAngle)) * (double)outerRadius;
            double cosI = -Math.cos(Math.toRadians(finishAngle)) * (double)innerRadius;
            double sinI = -Math.sin(Math.toRadians(finishAngle)) * (double)innerRadius;
            bb.func_181662_b(x + cos, y + sin, 0.0).func_181666_a(red, green, blue, alpha).func_181675_d();
            bb.func_181662_b(x + cosI, y + sinI, 0.0).func_181666_a(red, green, blue, 1.0f).func_181675_d();
        }
        t.func_78381_a();
        GlStateManager.func_179118_c();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
        GlStateManager.func_179126_j();
        GL11.glPopMatrix();
    }

    public void drawShiftPattern(EntityVehicle vehicle, double x, double y) {
        Transmission transmission = vehicle.solver.transmission;
        GearShiftPattern pattern = vehicle.getSolver().getPhysConf().getShiftPattern();
        GL11.glPushMatrix();
        GlStateManager.func_179141_d();
        int old = 0;
        if (transmission.shiftTimer > 0) {
            old = transmission.shiftTimer - 1;
        }
        Vec3d on2 = pattern.doAnimation(old, transmission.maxShiftTime, transmission.startGear, transmission.targetGear).func_186678_a(30.25);
        Vec3d oN = pattern.doAnimation(transmission.shiftTimer, transmission.maxShiftTime, transmission.startGear, transmission.targetGear).func_186678_a(30.25);
        oN = GearShiftPattern.interpVec3d(on2, oN, ClientProxy.MC.func_184121_ak());
        double nX = oN.field_72449_c;
        double nZ = -oN.field_72450_a;
        GL11.glPushMatrix();
        GlStateManager.func_179090_x();
        GlStateManager.func_179097_i();
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glTranslated((double)(x + 6.5), (double)(y + 6.5), (double)0.0);
        GL11.glScaled((double)30.5, (double)30.5, (double)30.5);
        pattern.renderPattern(Color.decode("#d2dae2"), x, y);
        GlStateManager.func_179098_w();
        GlStateManager.func_179126_j();
        GL11.glPopMatrix();
        ResourceLocation loc = new ResourceLocation("mwc:textures/gui/caricons.png");
        ClientProxy.MC.func_110434_K().func_110577_a(loc);
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glTranslated((double)(x + nX), (double)(y + nZ), (double)0.0);
        GL11.glScaled((double)0.8, (double)0.8, (double)0.8);
        this.func_73729_b(0, 0, 0, 0, 17, 17);
        GlStateManager.func_179118_c();
        GL11.glPopMatrix();
    }

    public void drawSpeedometer(EntityVehicle vehicle, double x, double y, int maxRPM, int gear, double rpm, double speed, double ratio) {
        GL11.glPushMatrix();
        double scale = (double)new ScaledResolution(ClientProxy.MC).func_78326_a() / 640.0;
        if (this.sat == null) {
            this.sat = new SimpleAnimationTimer(150, false);
        }
        if (ClientProxy.MC.field_71474_y.field_74320_O != this.oldPOV) {
            this.oldPOV = ClientProxy.MC.field_71474_y.field_74320_O;
            if (this.sat.isComplete()) {
                this.sat.reset();
            }
        }
        if (!this.sat.isComplete()) {
            this.sat.tick();
        }
        float lowestAng = -45.0f;
        float maxAng = 180.0f;
        float newRPMAngle = (float)(0.0 + ((double)(maxAng + 45.0f) - 0.0) * (rpm / (double)maxRPM));
        float prevRPMAngle = (float)(0.0 + ((double)(maxAng + 45.0f) - 0.0) * (vehicle.solver.getPreviousRPM() / (double)maxRPM));
        GlStateManager.func_179097_i();
        GL11.glEnable((int)2881);
        GL11.glHint((int)3155, (int)4352);
        GL11.glDisable((int)2881);
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)0.0);
        GL11.glScaled((double)0.85, (double)0.85, (double)0.85);
        int thousands = maxRPM / 1000;
        double an = 360.0 / (double)thousands;
        double radius = 50.0;
        double bA = -45.0;
        double eA = 180.0;
        for (int n = 0; n <= thousands; ++n) {
            double pA = (double)n * an / 360.0;
            double actualAngle = bA + (eA - bA) * pA;
            double cos = -Math.cos(Math.toRadians(actualAngle)) * radius;
            double sin = -Math.sin(Math.toRadians(actualAngle)) * radius;
            int color = 0;
            color = n < 6 ? 0xFFFFFF : 12597547;
            this.func_73732_a(ClientProxy.MC.field_71466_p, "" + n, (int)cos, (int)sin - 4, color);
        }
        GL11.glPopMatrix();
        GL11.glEnable((int)2881);
        this.renderHalfCircle(Color.decode("#FFFFFF"), x, y, 50, 48, lowestAng, this.sat.smoothInterpDouble(-45.0, 133.0));
        this.renderHalfCircle(Color.decode("#c23616"), x, y, 50, 48, 135.0, this.sat.smoothInterpDouble(135.0, maxAng));
        this.renderHalfCircle(Color.decode("#4cd137"), x, y, 10, 9, 0.0, this.sat.smoothInterpDouble(0.0, 360.0));
        Transmission transmission = vehicle.solver.transmission;
        GearShiftPattern pattern = vehicle.getSolver().getPhysConf().getShiftPattern();
        this.renderHalfCircle(Color.decode("#7f8fa6"), x, y, 12, 11, lowestAng, this.sat.smoothInterpDouble(lowestAng, maxAng + 4.0f));
        this.renderNeedle(Color.decode("#FFFFFF"), x, y, 35.0, 1.0, lowestAng, newRPMAngle, prevRPMAngle);
        GL11.glDisable((int)2881);
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)0.0);
        GL11.glScaled((double)1.5, (double)1.5, (double)1.5);
        if (transmission.isReverseGear) {
            this.func_73732_a(ClientProxy.MC.field_71466_p, "R", 0, -4, 1092740);
        } else if (transmission.inNeutral()) {
            this.func_73732_a(ClientProxy.MC.field_71466_p, "N", 0, -4, 13162213);
        } else {
            this.func_73732_a(ClientProxy.MC.field_71466_p, "" + gear, 0, -4, 5034295);
        }
        double valie = Math.floor(vehicle.getSolver().rearAxel.leftWheel.wheelAngularVelocity);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)0.0);
        GL11.glScaled((double)2.0, (double)2.0, (double)2.0);
        int fixedSpeed = (int)Math.round(speed * 3.6);
        this.func_73732_a(ClientProxy.MC.field_71466_p, "" + fixedSpeed, 20, 2, 13162213);
        GL11.glPushMatrix();
        GL11.glScaled((double)0.4, (double)0.4, (double)0.4);
        this.func_73732_a(ClientProxy.MC.field_71466_p, "km/h", 53, 25, 13162213);
        GL11.glPopMatrix();
        GL11.glPopMatrix();
        GL11.glPopMatrix();
        this.prevRPMAngle = newRPMAngle;
    }

    public void renderKeyAndLock(EntityVehicle vehicle, double x, double y, double ratio) {
        GL11.glPushMatrix();
        double pM = Math.sin(vehicle.field_70173_aa / 2) * 3.0;
        double ppM = Math.sin((vehicle.field_70173_aa - 1) / 2) * 3.0;
        double iPM = InterpolationKit.interpolateValue(ppM, pM, ClientProxy.MC.func_184121_ak());
        this.keyAnimator.tick();
        GL11.glTranslated((double)x, (double)y, (double)0.0);
        GL11.glRotated((double)-150.0, (double)0.0, (double)1.0, (double)0.0);
        GL11.glRotated((double)25.0, (double)1.0, (double)0.0, (double)0.0);
        GL11.glScaled((double)0.9, (double)0.9, (double)0.9);
        Vec3d iR = this.keyAnimator.getInterpolatedRotation();
        Vec3d iP = this.keyAnimator.getInterpolatedPosition();
        lockModel.func_78086_a(null, (float)iR.field_72450_a, 0.0f, 0.0f);
        ScreenRenderer.renderModelOnScreen(0.0, 0.0, 0.0, 30, 0.0, 0.0, 0.0, lockModel, keyTex);
        double add = 0.0;
        if (this.keyAnimator.currentPosition.func_72433_c() == 0.0) {
            add = iPM;
        }
        ScreenRenderer.renderModelOnScreen(0.0 + iP.field_72450_a, -24.0 + iP.field_72448_b, -50.0 + iP.field_72449_c + add, 30, 0.0 + iR.field_72450_a, 0.0 + iR.field_72448_b, 0.0 + iR.field_72449_c, keyModel, lockTex);
        GL11.glPopMatrix();
    }

    public void renderGUI(EntityVehicle vehicle) {
        ScaledResolution sr = new ScaledResolution(ClientProxy.MC);
        double width = sr.func_78326_a();
        double height = sr.func_78328_b();
        double x = width;
        double y = height;
        GL11.glPushMatrix();
        double ratio = width * height / 216960.0;
        GL11.glScaled((double)ratio, (double)ratio, (double)ratio);
        x /= ratio;
        y /= ratio;
        this.renderKeyAndLock(vehicle, (x -= 75.0) - 80.0, (y -= 50.0) - 68.0, ratio);
        if (!vehicle.isVehicleRunning()) {
            this.func_73732_a(ClientProxy.MC.field_71466_p, "Press " + KeyBindings.vehicleTurnOff.getDisplayName(), (int)x - 80, (int)y - 78, 13162213);
        }
        this.drawSpeedometer(vehicle, x, y, vehicle.solver.configuration.getEngine().getMaxRPM(), vehicle.solver.transmission.getCurrentGear(), vehicle.solver.getCurrentRPM(), vehicle.getRealSpeed(), ratio);
        GL11.glPopMatrix();
    }
}

