/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.tracking;

import com.paneedah.mwc.proxies.ClientProxy;
import com.paneedah.mwc.utils.ModReference;
import com.paneedah.weaponlib.compatibility.CompatiblePlayerEntityTrackerProvider;
import com.paneedah.weaponlib.tracking.TrackableEntity;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.world.World;

public class LivingEntityTracker {
    private Supplier<World> world;
    private Map<UUID, TrackableEntity> trackableEntities = new LinkedHashMap<UUID, TrackableEntity>();

    public static final LivingEntityTracker getTracker(EntityLivingBase player) {
        return CompatiblePlayerEntityTrackerProvider.getTracker(player);
    }

    public LivingEntityTracker(Supplier<World> world) {
        this.world = world;
    }

    public LivingEntityTracker() {
    }

    void init(Supplier<World> world) {
        this.world = world;
    }

    public void addTrackableEntity(TrackableEntity te) {
        this.update();
        this.trackableEntities.put(te.getEntity().getPersistentID(), te);
    }

    public boolean updateTrackableEntity(Entity entity) {
        this.update();
        TrackableEntity te = this.trackableEntities.get(entity.getPersistentID());
        if (te != null) {
            te.setEntitySupplier(() -> entity);
            return true;
        }
        return false;
    }

    public Collection<TrackableEntity> getTrackableEntitites() {
        return Collections.unmodifiableCollection(this.trackableEntities.values());
    }

    public void update() {
        Iterator<TrackableEntity> it = this.trackableEntities.values().iterator();
        while (it.hasNext()) {
            TrackableEntity te = it.next();
            if (!te.isExpired()) continue;
            it.remove();
        }
    }

    public TrackableEntity getTrackableEntity(int index) {
        Collection<TrackableEntity> values = this.trackableEntities.values();
        int i = 0;
        TrackableEntity result = null;
        for (TrackableEntity te : values) {
            if (i == index) {
                result = te;
                break;
            }
            ++i;
        }
        return result;
    }

    public void write(ByteBuf buf) {
        this.update();
        buf.writeInt(this.trackableEntities.size());
        for (TrackableEntity te : this.trackableEntities.values()) {
            te.serialize(buf, this.world);
        }
    }

    private void init(ByteBuf buf) {
        int trackableEntitiesSize = buf.readInt();
        for (int i = 0; i < trackableEntitiesSize; ++i) {
            try {
                TrackableEntity te = TrackableEntity.fromBuf(buf, this.world);
                this.trackableEntities.put(te.getUuid(), te);
                continue;
            }
            catch (RuntimeException e) {
                ModReference.LOG.error("Failed to deserialize trackable entity {}", (Object)e.toString(), (Object)e);
            }
        }
    }

    public byte[] toByteArray() {
        ByteBuf buf = Unpooled.buffer();
        this.write(buf);
        return buf.array();
    }

    public static LivingEntityTracker fromByteArray(byte[] bytes, Supplier<World> world) {
        ByteBuf buf = Unpooled.wrappedBuffer((byte[])bytes);
        LivingEntityTracker tracker = new LivingEntityTracker(world);
        if (bytes != null && bytes.length > 0) {
            tracker.init(buf);
        } else {
            ModReference.LOG.warn("Cannot deserialize tracker from empty byte array");
        }
        return tracker;
    }

    public static LivingEntityTracker read(ByteBuf buf) {
        LivingEntityTracker tracker = new LivingEntityTracker(() -> ClientProxy.MC.field_71439_g.field_70170_p);
        tracker.init(buf);
        return tracker;
    }
}

