/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.render.bgl.weather;

import com.paneedah.mwc.proxies.ClientProxy;
import com.paneedah.mwc.utils.MWCUtil;
import com.paneedah.weaponlib.animation.ClientValueRepo;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.client.IRenderHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ModernWeatherRenderer
extends IRenderHandler {
    private static final int RAIN_SEARCH_AREA = 4;
    private float[][] rainPositions = new float[64][5];
    private Vec3d previousPosition;
    public static final ResourceLocation RAIN_LIGHT = new ResourceLocation("mwc", "textures/environment/lightrain.png");
    public static final ResourceLocation RAIN_MEDIUM = new ResourceLocation("mwc", "textures/environment/mediumrain.png");
    public static final ResourceLocation RAIN_HEAVY = new ResourceLocation("mwc", "textures/environment/heavyrain.png");
    public static final ResourceLocation RAIN_INSANE = new ResourceLocation("mwc", "textures/environment/insanerain.png");

    public static boolean isRainingOrSnowing(BlockPos pos) {
        float f2 = ClientProxy.MC.field_71441_e.func_180494_b(pos).func_180626_a(pos);
        int j2 = ClientProxy.MC.field_71441_e.func_175725_q(pos).func_177956_o();
        return ClientProxy.MC.field_71441_e.func_72959_q().func_76939_a(f2, j2) >= 0.15f;
    }

    public boolean shouldRecalculateRainVectors(EntityPlayer player) {
        boolean positionFlag;
        if ((double)player.field_70170_p.func_72867_j(ClientProxy.MC.func_184121_ak()) == 0.0) {
            return false;
        }
        if (this.previousPosition == null) {
            this.previousPosition = player.func_174791_d();
            return true;
        }
        boolean bl = positionFlag = player.func_174791_d().field_72450_a != this.previousPosition.field_72450_a || player.func_174791_d().field_72448_b != this.previousPosition.field_72448_b || player.func_174791_d().field_72449_c != this.previousPosition.field_72449_c;
        if (positionFlag) {
            this.previousPosition = player.func_174791_d();
        }
        return positionFlag;
    }

    public void recalculateRainVectors(EntityPlayer player, Vec3d interpolatedPosition) {
        int count = 0;
        for (int x = -4; x < 4; ++x) {
            for (int y = -4; y < 4; ++y) {
                BlockPos rainPosition = new BlockPos(interpolatedPosition.field_72450_a + (double)x, player.func_174791_d().field_72448_b, interpolatedPosition.field_72449_c + (double)y);
                boolean rainStatus = ModernWeatherRenderer.isRainingOrSnowing(rainPosition);
                Biome biome = ClientProxy.MC.field_71441_e.func_180494_b(rainPosition);
                if (rainStatus && !biome.func_76738_d() || !rainStatus && !biome.func_76746_c()) {
                    this.rainPositions[count] = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
                    return;
                }
                int worldPos = ClientProxy.MC.field_71441_e.func_189649_b(rainPosition.func_177958_n(), rainPosition.func_177952_p());
                this.rainPositions[count] = new float[]{1.0f, (float)rainPosition.func_177958_n() + 1.0f, worldPos, rainPosition.func_177952_p(), rainStatus ? 1.0f : 0.0f};
                ++count;
            }
        }
    }

    public double getRandom(double scalar) {
        return Math.random() * scalar - scalar / 2.0;
    }

    public double getTrueHeight(BlockPos pos) {
        return ClientProxy.MC.field_71441_e.func_175645_m(pos).func_177956_o();
    }

    public void render(float partialTicks, WorldClient world, Minecraft MC) {
        int i;
        float rainStrength = MC.field_71441_e.func_72867_j(MC.func_184121_ak());
        if ((double)rainStrength == 0.0) {
            return;
        }
        double lateralSize = 1.0;
        double thinness = 5.0;
        double verticalSize = 64.0;
        float textureScale = 48.0f;
        float timer = 0.0f;
        GlStateManager.func_179129_p();
        Vec3d iP = MWCUtil.getInterpolatedPlayerPos();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(-iP.field_72450_a), (double)(-iP.field_72448_b), (double)(-iP.field_72449_c));
        GlStateManager.func_179147_l();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)rainStrength);
        Tessellator t = Tessellator.func_178181_a();
        MC.func_110434_K().func_110577_a(RAIN_HEAVY);
        timer = -ClientValueRepo.TICKER.getLerpedFloat() / 3.0f;
        BufferBuilder bb = t.func_178180_c();
        bb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        for (i = 0; i < this.rainPositions.length; ++i) {
            if ((double)this.rainPositions[i][0] == 0.0 || this.rainPositions[i][4] == 0.0f) continue;
            bb.func_181662_b((double)this.rainPositions[i][1] - lateralSize, (double)this.rainPositions[i][2] + verticalSize, (double)this.rainPositions[i][3] + lateralSize).func_187315_a(0.0, (double)(0.0f + timer)).func_181675_d();
            bb.func_181662_b((double)this.rainPositions[i][1], (double)this.rainPositions[i][2] + verticalSize, (double)this.rainPositions[i][3]).func_187315_a(1.0 * thinness, (double)(0.0f + timer)).func_181675_d();
            bb.func_181662_b((double)this.rainPositions[i][1], (double)this.rainPositions[i][2], (double)this.rainPositions[i][3]).func_187315_a(1.0 * thinness, (double)(1.0f * textureScale + timer)).func_181675_d();
            bb.func_181662_b((double)this.rainPositions[i][1] - lateralSize, (double)this.rainPositions[i][2], (double)this.rainPositions[i][3] + lateralSize).func_187315_a(0.0, (double)(1.0f * textureScale + timer)).func_181675_d();
            bb.func_181662_b((double)this.rainPositions[i][1], (double)this.rainPositions[i][2] + verticalSize, (double)this.rainPositions[i][3] + lateralSize).func_187315_a(0.0, (double)(0.0f + timer)).func_181675_d();
            bb.func_181662_b((double)this.rainPositions[i][1] - lateralSize, (double)this.rainPositions[i][2] + verticalSize, (double)this.rainPositions[i][3]).func_187315_a(1.0 * thinness, (double)(0.0f + timer)).func_181675_d();
            bb.func_181662_b((double)this.rainPositions[i][1] - lateralSize, (double)this.rainPositions[i][2], (double)this.rainPositions[i][3]).func_187315_a(1.0 * thinness, (double)(1.0f * textureScale + timer)).func_181675_d();
            bb.func_181662_b((double)this.rainPositions[i][1], (double)this.rainPositions[i][2], (double)this.rainPositions[i][3] + lateralSize).func_187315_a(0.0, (double)(1.0f * textureScale + timer)).func_181675_d();
        }
        t.func_78381_a();
        MC.func_110434_K().func_110577_a(new ResourceLocation("mwc:textures/environment/christmassnow.png"));
        timer = -ClientValueRepo.TICKER.getLerpedFloat() / 25.0f;
        bb = t.func_178180_c();
        bb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        for (i = 0; i < this.rainPositions.length; ++i) {
            if ((double)this.rainPositions[i][0] == 0.0 || this.rainPositions[i][4] == 1.0f) continue;
            bb.func_181662_b((double)this.rainPositions[i][1] - lateralSize, (double)this.rainPositions[i][2] + verticalSize, (double)this.rainPositions[i][3] + lateralSize).func_187315_a(0.0, (double)(0.0f + timer)).func_181675_d();
            bb.func_181662_b((double)this.rainPositions[i][1], (double)this.rainPositions[i][2] + verticalSize, (double)this.rainPositions[i][3]).func_187315_a(1.0 * thinness, (double)(0.0f + timer)).func_181675_d();
            bb.func_181662_b((double)this.rainPositions[i][1], (double)this.rainPositions[i][2], (double)this.rainPositions[i][3]).func_187315_a(1.0 * thinness, (double)(1.0f * textureScale + timer)).func_181675_d();
            bb.func_181662_b((double)this.rainPositions[i][1] - lateralSize, (double)this.rainPositions[i][2], (double)this.rainPositions[i][3] + lateralSize).func_187315_a(0.0, (double)(1.0f * textureScale + timer)).func_181675_d();
            bb.func_181662_b((double)this.rainPositions[i][1], (double)this.rainPositions[i][2] + verticalSize, (double)this.rainPositions[i][3] + lateralSize).func_187315_a(0.0, (double)(0.0f + timer)).func_181675_d();
            bb.func_181662_b((double)this.rainPositions[i][1] - lateralSize, (double)this.rainPositions[i][2] + verticalSize, (double)this.rainPositions[i][3]).func_187315_a(1.0 * thinness, (double)(0.0f + timer)).func_181675_d();
            bb.func_181662_b((double)this.rainPositions[i][1] - lateralSize, (double)this.rainPositions[i][2], (double)this.rainPositions[i][3]).func_187315_a(1.0 * thinness, (double)(1.0f * textureScale + timer)).func_181675_d();
            bb.func_181662_b((double)this.rainPositions[i][1], (double)this.rainPositions[i][2], (double)this.rainPositions[i][3] + lateralSize).func_187315_a(0.0, (double)(1.0f * textureScale + timer)).func_181675_d();
        }
        t.func_78381_a();
        GlStateManager.func_179121_F();
        GlStateManager.func_179089_o();
    }
}

