/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.render.bgl.math;

import org.lwjgl.util.vector.Quaternion;

public class AngleKit {
    private static double rad(double deg) {
        return Math.toRadians(deg);
    }

    private static double deg(double rad) {
        return Math.toDegrees(rad);
    }

    private static float rad(float deg) {
        return (float)Math.toRadians(deg);
    }

    private static float deg(float rad) {
        return (float)Math.toDegrees(rad);
    }

    public static EulerAngle eulerFromQuat(Quaternion q1, Format format) {
        double t0 = 2.0 * (double)(q1.w * q1.x + q1.y * q1.z);
        double t1 = 1.0 - 2.0 * (double)(q1.x * q1.x + q1.y * q1.y);
        double roll = Math.atan2(t0, t1);
        double t2 = 2.0 * (double)(q1.w * q1.y - q1.z * q1.x);
        if (t2 > 1.0) {
            t2 = 1.0;
        }
        if (t2 < -1.0) {
            t2 = -1.0;
        }
        double pitch = Math.asin(t2);
        double t3 = 2.0 * (double)(q1.w * q1.z + q1.x * q1.y);
        double t4 = 1.0 - 2.0 * (double)(q1.y * q1.y + q1.z * q1.z);
        double yaw = Math.atan2(t3, t4);
        if (format == Format.DEGREES) {
            yaw = AngleKit.deg(yaw);
            pitch = AngleKit.deg(pitch);
            roll = AngleKit.deg(roll);
        }
        return new EulerAngle(format, pitch, yaw, roll);
    }

    public static Quaternion quatFromEuler(EulerAngle euler) {
        return AngleKit.quatFromEuler(euler.getYaw(), euler.getPitch(), euler.getRoll(), euler.getFormat());
    }

    public static Quaternion quatFromEuler(float yaw, float pitch, float roll, Format format) {
        return AngleKit.quatFromEuler((double)yaw, (double)pitch, (double)roll, format);
    }

    public static Quaternion quatFromEuler(double yaw, double pitch, double roll, Format format) {
        Quaternion quat = new Quaternion();
        if (format == Format.DEGREES) {
            yaw = AngleKit.rad(yaw);
            pitch = AngleKit.rad(pitch);
            roll = AngleKit.rad(roll);
        }
        quat.x = (float)(Math.sin(roll / 2.0) * Math.cos(pitch / 2.0) * Math.cos(yaw / 2.0) - Math.cos(roll / 2.0) * Math.sin(pitch / 2.0) * Math.sin(yaw / 2.0));
        quat.y = (float)(Math.cos(roll / 2.0) * Math.sin(pitch / 2.0) * Math.cos(yaw / 2.0) + Math.sin(roll / 2.0) * Math.cos(pitch / 2.0) * Math.sin(yaw / 2.0));
        quat.z = (float)(Math.cos(roll / 2.0) * Math.cos(pitch / 2.0) * Math.sin(yaw / 2.0) - Math.sin(roll / 2.0) * Math.sin(pitch / 2.0) * Math.cos(yaw / 2.0));
        quat.w = (float)(Math.cos(roll / 2.0) * Math.cos(pitch / 2.0) * Math.cos(yaw / 2.0) + Math.sin(roll / 2.0) * Math.sin(pitch / 2.0) * Math.sin(yaw / 2.0));
        return quat;
    }

    public static Quaternion slerp(Quaternion v0, Quaternion v1, float t) {
        double dot = Quaternion.dot((Quaternion)v0, (Quaternion)v1);
        if (dot < 0.0) {
            v1 = new Quaternion(-v1.x, -v1.y, -v1.z, -v1.w);
            dot = -dot;
        }
        double DOT_THRESHOLD = 0.9999999;
        if (dot > 0.9999999) {
            Quaternion result = new Quaternion(v0.x + t * v1.x, v0.y + t * v1.y, v0.z + t * v1.z, v0.w + t * v1.w);
            result.normalise();
            return result;
        }
        double theta_0 = Math.acos(dot);
        double theta = theta_0 * (double)t;
        double sin_theta = Math.sin(theta);
        double sin_theta_0 = Math.sin(theta_0);
        float s0 = (float)(Math.cos(theta) - dot * sin_theta / sin_theta_0);
        float s1 = (float)(sin_theta / sin_theta_0);
        return new Quaternion(s0 * v0.x + s1 * v1.x, s0 * v0.y + s1 * v1.y, s0 * v0.z + s1 * v1.z, s0 * v0.w + s1 * v1.w);
    }

    public static AxisAngle convertEulerToAxisAngle(EulerAngle euler) {
        return AngleKit.convertEulerToAxisAngle(euler.getYaw(), euler.getPitch(), euler.getRoll(), euler.getFormat());
    }

    public static AxisAngle convertEulerToAxisAngle(double yaw, double pitch, double roll, Format format) {
        return AngleKit.convertEulerToAxisAngle((float)yaw, (float)pitch, (float)roll, format);
    }

    public static AxisAngle convertEulerToAxisAngle(float yaw, float pitch, float roll, Format format) {
        if (format == Format.DEGREES) {
            yaw = AngleKit.rad(yaw);
            pitch = AngleKit.rad(pitch);
            roll = AngleKit.rad(roll);
        }
        float c1 = (float)Math.cos((double)yaw / 2.0);
        float c2 = (float)Math.cos((double)pitch / 2.0);
        float c3 = (float)Math.cos((double)roll / 2.0);
        float s1 = (float)Math.sin((double)yaw / 2.0);
        float s2 = (float)Math.sin((double)pitch / 2.0);
        float s3 = (float)Math.sin((double)roll / 2.0);
        float x = s1 * s2 * c3 + c1 * c2 * s3;
        float y = s1 * c2 * c3 + c1 * s2 * s3;
        float z = c1 * s2 * c3 - s1 * c2 * s3;
        float angle = (float)(2.0 * Math.acos(c1 * c2 * c3 - s1 * s2 * s3));
        float length = x * x + y * y + z * z;
        if ((double)length < 0.001) {
            x = 1.0f;
            y = 0.0f;
            z = 0.0f;
        } else {
            length = (float)Math.sqrt(length);
        }
        x /= length;
        y /= length;
        z /= length;
        if (format == Format.DEGREES) {
            angle = AngleKit.deg(angle);
        }
        return new AxisAngle(format, angle, x, y, z);
    }

    public static AxisAngle quatToAxisAngle(Format format, Quaternion q0) {
        double z;
        double y;
        double x;
        if (q0.w > 1.0f) {
            q0.normalise();
        }
        double angle = 2.0 * Math.acos(q0.w);
        double s = Math.sqrt(1.0f - q0.w * q0.w);
        if (s < 0.001) {
            x = q0.x;
            y = q0.y;
            z = q0.z;
        } else {
            x = (double)q0.x / s;
            y = (double)q0.y / s;
            z = q0.z / 2.0f;
        }
        if (format == Format.DEGREES) {
            angle = AngleKit.deg(angle);
        }
        return new AxisAngle(format, angle, x, y, z);
    }

    public static class EulerAngle {
        private Format format;
        private double x;
        private double y;
        private double z;

        public EulerAngle(Format format, double x, double y, double z) {
            this.format = format;
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public boolean isRadians() {
            return this.format == Format.RADIANS;
        }

        public boolean isDegrees() {
            return this.format == Format.DEGREES;
        }

        public Format getFormat() {
            return this.format;
        }

        public EulerAngle toRadians() {
            if (this.format == Format.RADIANS) {
                return this;
            }
            return new EulerAngle(Format.RADIANS, AngleKit.rad(this.x), AngleKit.rad(this.y), AngleKit.rad(this.z));
        }

        public EulerAngle toDegrees() {
            if (this.format == Format.DEGREES) {
                return this;
            }
            return new EulerAngle(Format.DEGREES, AngleKit.deg(this.x), AngleKit.deg(this.y), AngleKit.deg(this.z));
        }

        public double getPitch() {
            return this.x;
        }

        public double getRoll() {
            return this.z;
        }

        public double getYaw() {
            return this.y;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public double getZ() {
            return this.z;
        }

        public EulerAngle slerp(EulerAngle a1, double t) {
            Quaternion q0 = this.asQuaternion();
            Quaternion q1 = a1.asQuaternion();
            Quaternion result = AngleKit.slerp(q0, q1, (float)t);
            return AngleKit.eulerFromQuat(result, this.getFormat());
        }

        public AxisAngle asAxisAngle() {
            return AngleKit.convertEulerToAxisAngle(this);
        }

        public Quaternion asQuaternion() {
            return AngleKit.quatFromEuler(this);
        }

        public String toString() {
            return "(" + this.x + ", " + this.y + ", " + this.z + ")";
        }
    }

    public static class AxisAngle {
        private Format format;
        private double angle;
        private double x;
        private double y;
        private double z;

        public AxisAngle(Format format, double angle, double x, double y, double z) {
            this.format = format;
            this.angle = angle;
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public boolean isRadians() {
            return this.format == Format.RADIANS;
        }

        public boolean isDegrees() {
            return this.format == Format.DEGREES;
        }

        public Format getFormat() {
            return this.format;
        }

        public AxisAngle toRadians() {
            if (this.format == Format.RADIANS) {
                return this;
            }
            return new AxisAngle(Format.RADIANS, AngleKit.rad(this.angle), this.x, this.y, this.z);
        }

        public AxisAngle toDegrees() {
            if (this.format == Format.DEGREES) {
                return this;
            }
            return new AxisAngle(Format.DEGREES, AngleKit.deg(this.angle), this.x, this.y, this.z);
        }

        public double getAngle() {
            return this.angle;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public double getZ() {
            return this.z;
        }

        public String toString() {
            return "(" + this.angle + ", [" + this.x + ", " + this.y + ", " + this.z + "])";
        }
    }

    public static enum Format {
        DEGREES,
        RADIANS;

    }
}

