/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.render.bgl;

import com.paneedah.mwc.proxies.ClientProxy;
import com.paneedah.weaponlib.ClientEventHandler;
import com.paneedah.weaponlib.shader.jim.Shader;
import java.util.ArrayList;
import java.util.Map;
import java.util.Stack;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;

public class LightManager {
    public static final int MAX_POINT_LIGHTS = 32;
    private ArrayList<PointLight> lights = new ArrayList();

    public void update() {
        this.lights.clear();
        for (Map.Entry<Integer, Stack<Long>> registry : ClientEventHandler.muzzleFlashMap.entrySet()) {
            Entity entity;
            if (registry.getValue().empty() || !((entity = ClientProxy.MC.field_71441_e.func_73045_a(registry.getKey().intValue())) instanceof EntityPlayer)) continue;
            EntityPlayer player = (EntityPlayer)entity;
            this.addLight((float)player.field_70165_t, (float)player.field_70163_u + 0.6f, (float)player.field_70161_v, 1.0f, 0.623f, 0.262f, 0.05f, 0.009f, 0.032f);
        }
    }

    public void addLight(float x, float y, float z, float r, float g, float b, float constant, float linear, float quadratic) {
        this.lights.clear();
        if (this.lights.size() < 1) {
            float lightlevel = 0.0f;
            lightlevel = (float)ClientProxy.MC.field_71441_e.func_175699_k(new BlockPos((double)x, (double)y, (double)z)) * ClientProxy.MC.field_71441_e.func_72971_b(1.0f);
            if (lightlevel > 8.0f) {
                return;
            }
            float mult = 1.0f / (4.0f * lightlevel);
            if (Double.isInfinite(mult)) {
                mult = 1.0f;
            }
            this.lights.add(new PointLight(x, y, z, r, g, b, constant /= mult, linear, quadratic));
        }
    }

    public ArrayList<PointLight> getLights() {
        return this.lights;
    }

    public void updateUniforms(Shader shader) {
        shader.uniform1i("totalActiveLights", this.lights.size());
        for (int i = 0; i < this.lights.size(); ++i) {
            PointLight light = this.lights.get(i);
            shader.uniform3f("lights[" + i + "].attenuation", light.constant, light.linear, light.quadratic);
            shader.uniform3f("lights[" + i + "].position", light.position[0], light.position[1], light.position[2]);
            shader.uniform3f("lights[" + i + "].baseColor", light.color[0], light.color[1], light.color[2]);
        }
    }

    public static class PointLight {
        private boolean tempLight;
        private long creationDate;
        private double life;
        private float constant;
        private float linear;
        private float quadratic;
        private float[] position = new float[3];
        private float[] color = new float[3];

        public PointLight(float x, float y, float z, float r, float g, float b, float constant, float linear, float quadratic) {
            this.constant = constant;
            this.linear = linear;
            this.quadratic = quadratic;
            this.color = new float[]{r, g, b};
            this.position = new float[]{x, y, z};
        }

        public PointLight(float x, float y, float z, float r, float g, float b, float constant, float linear, float quadratic, double life) {
            this(x, y, z, r, g, b, constant, linear, quadratic);
            this.tempLight = true;
            this.creationDate = System.currentTimeMillis();
            this.life = life;
        }
    }
}

