/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.render;

import com.paneedah.mwc.proxies.ClientProxy;
import com.paneedah.weaponlib.render.WavefrontModel;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.resources.IResource;
import net.minecraft.util.ResourceLocation;

public class WavefrontLoader {
    private static final String HEADER_OBJECT = "o";
    private static final String HEADER_VERTEX = "v";
    private static final String HEADER_TEX_COORD = "vt";
    private static final String HEADER_LIGHT_COORD = "vn";
    private static final String HEADER_FACE = "f";
    private static final String OBJ_MODEL_LOCATION = "mwc:models/obj/";

    public static WavefrontModel load(String modelName) {
        return WavefrontLoader.load(new ResourceLocation(OBJ_MODEL_LOCATION + modelName + ".obj"));
    }

    public static WavefrontModel loadSubModel(String model, String subModel) {
        return WavefrontLoader.loadSubModel(model, subModel, false);
    }

    public static WavefrontModel loadSubModel(String model, String subModel, boolean vaoMode) {
        BufferedReader br = WavefrontLoader.createBufferedReader(new ResourceLocation(OBJ_MODEL_LOCATION + model + ".obj"));
        boolean startRead = false;
        ArrayList<String> lines = new ArrayList<String>();
        try {
            while (br.ready()) {
                String line = br.readLine();
                if (line.startsWith(HEADER_OBJECT)) {
                    if (!line.split(" ")[1].equals(subModel)) break;
                    startRead = true;
                    startRead = true;
                }
                if (startRead) {
                    lines.add(line);
                }
                if (startRead || !line.startsWith(HEADER_VERTEX) && !line.startsWith(HEADER_LIGHT_COORD) && !line.startsWith(HEADER_TEX_COORD)) continue;
                lines.add(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return WavefrontLoader.process(lines, vaoMode);
    }

    public static WavefrontModel loadWeaponModel(String model, List<String> objectNames, boolean vaoMode) {
        BufferedReader br = WavefrontLoader.createBufferedReader(new ResourceLocation(OBJ_MODEL_LOCATION + model + ".obj"));
        boolean startRead = false;
        ArrayList<String> lines = new ArrayList<String>();
        try {
            while (br.ready()) {
                String line = br.readLine();
                if (line.startsWith(HEADER_OBJECT)) {
                    String objectName = line.split(" ")[1];
                    startRead = objectNames.contains(objectName);
                }
                if (startRead) {
                    lines.add(line);
                }
                if (startRead || !line.startsWith(HEADER_VERTEX) && !line.startsWith(HEADER_LIGHT_COORD) && !line.startsWith(HEADER_TEX_COORD)) continue;
                lines.add(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return WavefrontLoader.process(lines, vaoMode);
    }

    public static WavefrontModel load(ResourceLocation loc) {
        BufferedReader br = WavefrontLoader.createBufferedReader(loc);
        ArrayList<String> lines = new ArrayList<String>();
        try {
            while (br.ready()) {
                lines.add(br.readLine());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return WavefrontLoader.process(lines, false);
    }

    private static BufferedReader createBufferedReader(ResourceLocation loc) {
        IResource resource = null;
        try {
            resource = ClientProxy.MC.func_110442_L().func_110536_a(loc);
        }
        catch (IOException e) {
            System.err.println("Could not load obj file " + loc.func_110623_a());
            return null;
        }
        InputStream is = resource.func_110527_b();
        return new BufferedReader(new InputStreamReader(is));
    }

    private static WavefrontModel process(ArrayList<String> unprocessed, boolean vaoMode) {
        WavefrontModel model = new WavefrontModel();
        ArrayList<String[]> preprocesFace = new ArrayList<String[]>();
        for (String rawLine : unprocessed) {
            String[] line;
            if (rawLine.length() == 0 || !(line = rawLine.split(" "))[0].equals(HEADER_OBJECT) && !line[0].equals(HEADER_VERTEX) && !line[0].equals(HEADER_LIGHT_COORD) && !line[0].equals(HEADER_TEX_COORD) && !line[0].equals(HEADER_FACE)) continue;
            switch (line[0]) {
                case "v": {
                    float[] vertex = new float[3];
                    for (int i = 1; i < line.length; ++i) {
                        vertex[i - 1] = Float.parseFloat(line[i]) * 0.2f;
                    }
                    model.vertex.add(vertex);
                    break;
                }
                case "vt": {
                    float[] texCoord = new float[2];
                    for (int i = 1; i < line.length; ++i) {
                        texCoord[i - 1] = Float.parseFloat(line[i]);
                    }
                    model.texcoord.add(texCoord);
                    break;
                }
                case "f": {
                    preprocesFace.add(line);
                    break;
                }
                case "vn": {
                    float[] normal = new float[3];
                    for (int i = 1; i < line.length; ++i) {
                        normal[i - 1] = Float.parseFloat(line[i]);
                    }
                    model.normals.add(normal);
                }
            }
        }
        for (String[] ar : preprocesFace) {
            model.buildIndexBuffer(ar);
        }
        if (!vaoMode) {
            model.build();
        } else {
            model.buildVAO();
        }
        return model;
    }
}

