/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.render;

import com.paneedah.mwc.proxies.ClientProxy;
import java.util.LinkedList;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import org.lwjgl.opengl.GL11;

public class RadarChart {
    private static final double TRANSITION_TIME = 200.0;
    private static final double TYPE_TIME = 100.0;
    private static final double TWO_PI = Math.PI * 2;
    private String name;
    private String[] titleList;
    private float[] color;
    private float radius;
    private int sides;
    private double increment;
    private double rotation;
    private long textTypeTimestamp = System.currentTimeMillis();
    private boolean textLock = false;
    private long lastStateStamp = System.nanoTime();
    private LinkedList<float[]> states = new LinkedList();
    private double mu = 1.0;

    public RadarChart(String name, int chartColor, float chartAlpha, float radius, int sides) {
        this.name = name;
        float r = (float)((double)((chartColor & 0xFF0000) >> 16) / 255.0);
        float g = (float)((double)((chartColor & 0xFF00) >> 8) / 255.0);
        float b = (float)((double)(chartColor & 0xFF) / 255.0);
        this.color = new float[]{r, g, b, chartAlpha};
        this.radius = radius;
        this.sides = sides;
        this.increment = Math.PI * 2 / (double)sides;
        this.rotation = this.increment * 0.25;
    }

    public RadarChart withTitles(String[] list) {
        this.titleList = list;
        return this;
    }

    public void uploadSet(float[] set) {
        if (this.states.size() == 1) {
            this.lastStateStamp = System.currentTimeMillis();
        }
        if (this.states.size() > 2) {
            this.states.removeLast();
        }
        this.states.add(set);
    }

    public void randomizeData() {
        this.uploadSet(new float[]{(float)Math.random(), (float)Math.random(), (float)Math.random(), (float)Math.random(), (float)Math.random()});
    }

    public double getPointRadius(double angle) {
        if (this.states.isEmpty()) {
            return 0.0;
        }
        int index = angle == 0.0 ? 0 : (int)Math.floor(angle / this.increment);
        float value = 0.0f;
        if (this.states.size() > 1) {
            float current = this.states.get(1)[index];
            float previous = this.states.peek()[index];
            float alpha = (float)(this.mu * this.mu * (3.0 - 2.0 * this.mu));
            value = previous + (current - previous) * alpha;
        } else {
            value = this.states.peek()[index];
        }
        return value;
    }

    public void render(double x, double y, int mouseX, int mouseY, double scale) {
        double point;
        double a;
        if (this.states.size() > 1) {
            this.mu = (double)(System.currentTimeMillis() - this.lastStateStamp) / 250.0;
            if (this.mu >= 1.0) {
                this.lastStateStamp = System.currentTimeMillis();
                this.states.pop();
                this.mu = 0.0;
            }
        } else {
            this.mu = 1.0;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)0.0);
        GlStateManager.func_179114_b((float)((float)(-Math.toDegrees(0.3141592653589793))), (float)0.0f, (float)0.0f, (float)1.0f);
        Tessellator t = Tessellator.func_178181_a();
        BufferBuilder bb = t.func_178180_c();
        GL11.glLineWidth((float)1.0f);
        bb.func_181668_a(3, DefaultVertexFormats.field_181706_f);
        for (double m = 0.0; m <= 1.0; m += 0.2) {
            for (double a2 = 0.0; a2 <= Math.PI * 2; a2 += this.increment) {
                bb.func_181662_b(Math.cos(a2) * (double)this.radius * m, Math.sin(a2) * (double)this.radius * m, 0.0).func_181666_a(1.0f, 1.0f, 1.0f, this.color[3]).func_181675_d();
            }
        }
        t.func_78381_a();
        GL11.glLineWidth((float)1.0f);
        bb.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        for (a = 0.0; a <= Math.PI * 2; a += this.increment) {
            bb.func_181662_b(0.0, 0.0, 0.0).func_181666_a(1.0f, 1.0f, 1.0f, this.color[3]).func_181675_d();
            bb.func_181662_b(Math.cos(a) * (double)this.radius, Math.sin(a) * (double)this.radius, 0.0).func_181666_a(1.0f, 1.0f, 1.0f, this.color[3]).func_181675_d();
        }
        t.func_78381_a();
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        bb.func_181668_a(6, DefaultVertexFormats.field_181706_f);
        bb.func_181662_b(0.0, 0.0, 0.0).func_181666_a(this.color[0], this.color[1], this.color[2], this.color[3]).func_181675_d();
        for (a = 0.0; a < Math.PI * 2; a += this.increment) {
            point = this.getPointRadius(a);
            bb.func_181662_b(Math.cos(a) * (double)this.radius * point, Math.sin(a) * (double)this.radius * point, 0.0).func_181666_a(this.color[0], this.color[1], this.color[2], this.color[3]).func_181675_d();
        }
        bb.func_181662_b((double)this.radius * this.getPointRadius(0.0), 0.0, 0.0).func_181666_a(this.color[0], this.color[1], this.color[2], this.color[3]).func_181675_d();
        t.func_78381_a();
        GL11.glLineWidth((float)3.0f);
        bb.func_181668_a(3, DefaultVertexFormats.field_181706_f);
        for (a = 0.0; a < Math.PI * 2; a += this.increment) {
            point = this.getPointRadius(a);
            bb.func_181662_b(Math.cos(a) * (double)this.radius * point, Math.sin(a) * (double)this.radius * point, 0.0).func_181666_a(this.color[0], this.color[1], this.color[2], this.color[3]).func_181675_d();
        }
        double point2 = this.getPointRadius(0.0);
        bb.func_181662_b((double)this.radius * point2, 0.0, 0.0).func_181666_a(this.color[0], this.color[1], this.color[2], this.color[3]).func_181675_d();
        t.func_78381_a();
        GlStateManager.func_179121_F();
        GlStateManager.func_179098_w();
        double textRadius = (double)this.radius * 1.1;
        for (double a3 = 0.0; a3 < Math.PI * 2; a3 += this.increment) {
            String text = this.titleList[(int)Math.floor(a3 / this.increment)];
            double d1 = (double)mouseX - x * scale;
            double d2 = (double)mouseY - y * scale;
            double distance = Math.sqrt(d1 * d1 + d2 * d2);
            try {
                if (distance < (double)this.radius) {
                    double diff = System.currentTimeMillis() - this.textTypeTimestamp;
                    if (diff > 100.0 && !this.textLock) {
                        this.textLock = true;
                        this.textTypeTimestamp = System.currentTimeMillis();
                    }
                    if (diff < 100.0) {
                        text = text.substring(1, (int)Math.max(Math.floor((double)(text.length() - 1) * (diff / 100.0)), 1.0));
                    }
                } else {
                    this.textLock = false;
                    text = text.charAt(0) + "";
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            double angle = a3 - this.rotation;
            double textCenter = ClientProxy.MC.field_71466_p.func_78256_a(text) / 2;
            double centerHeight = (double)ClientProxy.MC.field_71466_p.field_78288_b / 2.0;
            ClientProxy.MC.field_71466_p.func_175063_a(text, (float)(Math.cos(angle) * textRadius + x - textCenter), (float)(Math.sin(angle) * textRadius + y - centerHeight), 0xFFFFFF);
        }
    }
}

