/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.numerical;

import com.paneedah.weaponlib.numerical.ISimulator;

public class SynchronizedSimulator {
    private ISimulator simulator;
    private long previousFrameTime = System.currentTimeMillis();
    private double accumulator;
    private double dt;
    private double remainder;

    public SynchronizedSimulator(ISimulator simulator, double dt) {
        this.simulator = simulator;
        this.dt = dt;
    }

    public void update() {
        long newTime = System.currentTimeMillis();
        double frameTime = (double)(newTime - this.previousFrameTime) / 1000.0;
        this.previousFrameTime = newTime;
        if (frameTime > 0.25) {
            frameTime = 0.25;
        }
        this.accumulator += frameTime;
        while (this.accumulator >= this.dt) {
            this.simulator.update(this.dt);
            this.accumulator -= this.dt;
        }
        this.remainder = this.accumulator;
    }

    public double getRemainder() {
        return this.remainder;
    }
}

