/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.numerical;

import com.paneedah.mwc.proxies.ClientProxy;
import com.paneedah.weaponlib.animation.MatrixHelper;

public class SpringValue {
    public double springConstant;
    public double mass;
    public double damping;
    public double velocity;
    public double position;
    public double waitingForce;
    public double prevPosition = 0.0;

    public SpringValue(double k, double mass, double damp) {
        this.springConstant = k;
        this.mass = mass;
        this.damping = damp;
    }

    public void applyForce(double force) {
        this.waitingForce = force;
    }

    public void update(double dt) {
        double force = -this.springConstant * this.position;
        double dampingForce = this.damping * this.velocity;
        this.waitingForce = 0.0;
        double netForce = (force += this.waitingForce) - dampingForce;
        double acceleration = netForce / this.mass;
        this.prevPosition = this.position;
        this.velocity += acceleration * dt;
        this.position += this.velocity * dt;
        if (this.isImpossibleDouble(this.position) || this.isImpossibleDouble(this.velocity) || this.isImpossibleDouble(this.waitingForce)) {
            this.resetSpring();
        }
    }

    private boolean isImpossibleDouble(double value) {
        return Double.isNaN(value) || Double.isInfinite(value);
    }

    public void resetSpring() {
        this.velocity = 0.0;
        this.position = 0.0;
        this.waitingForce = 0.0;
    }

    public double getSpringConstant() {
        return this.springConstant;
    }

    public void configure(double k, double mass, double dampening) {
        this.springConstant = k;
        this.mass = mass;
        this.damping = dampening;
    }

    public void setSpringConstant(double springConstant) {
        this.springConstant = springConstant;
    }

    public double getMass() {
        return this.mass;
    }

    public void setMass(double mass) {
        this.mass = mass;
    }

    public double getDamping() {
        return this.damping;
    }

    public void setDamping(double damping) {
        this.damping = damping;
    }

    public double getVelocity() {
        return this.velocity;
    }

    public void setVelocity(double velocity) {
        this.velocity = velocity;
    }

    public double getPosition() {
        return this.position;
    }

    public double getLerpedPosition() {
        return this.getLerpedPosition(ClientProxy.MC.func_184121_ak());
    }

    public double getLerpedPosition(double mu) {
        return MatrixHelper.solveLerp((float)this.prevPosition, (float)this.position, ClientProxy.MC.func_184121_ak());
    }

    public float getLerpedFloat() {
        return (float)this.getLerpedPosition();
    }

    public void setPosition(double position) {
        this.position = position;
    }
}

