/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.melee;

import com.paneedah.mwc.MWC;
import com.paneedah.mwc.network.NetworkPermitManager;
import com.paneedah.mwc.network.messages.BloodClientMessage;
import com.paneedah.mwc.network.messages.MeleeAttackMessage;
import com.paneedah.mwc.proxies.ClientProxy;
import com.paneedah.mwc.utils.ModReference;
import com.paneedah.weaponlib.CommonModContext;
import com.paneedah.weaponlib.ModContext;
import com.paneedah.weaponlib.melee.MeleeState;
import com.paneedah.weaponlib.melee.PlayerMeleeInstance;
import com.paneedah.weaponlib.state.Aspect;
import com.paneedah.weaponlib.state.StateManager;
import io.redstudioragnarok.redcore.vectors.Vector3F;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MeleeAttackAspect
implements Aspect<MeleeState, PlayerMeleeInstance> {
    private static final long STUB_DURATION = 250L;
    private static final long HEAVY_STUB_DURATION = 250L;
    private static final long ALERT_TIMEOUT = 300L;
    private static Predicate<PlayerMeleeInstance> attackTimeoutExpired = instance -> System.currentTimeMillis() > instance.getStateUpdateTimestamp() + 250L;
    private static Predicate<PlayerMeleeInstance> heavyAttackTimeoutExpired = instance -> System.currentTimeMillis() > instance.getStateUpdateTimestamp() + 250L;
    private static Predicate<PlayerMeleeInstance> attackCooldownTimeoutExpired = instance -> System.currentTimeMillis() > instance.getLastAttackTimestamp() + instance.getWeapon().getAttackCooldownTimeout();
    private static Predicate<PlayerMeleeInstance> heavyAttackCooldownTimeoutExpired = instance -> System.currentTimeMillis() > instance.getLastAttackTimestamp() + instance.getWeapon().getHeavyAttackCooldownTimeout();
    private static Predicate<PlayerMeleeInstance> readyToStab = instance -> System.currentTimeMillis() > instance.getStateUpdateTimestamp() + instance.getWeapon().getPrepareStubTimeout();
    private static Predicate<PlayerMeleeInstance> readyToHeavyStab = instance -> System.currentTimeMillis() > instance.getStateUpdateTimestamp() + instance.getWeapon().getPrepareHeavyStubTimeout();
    private static final Set<MeleeState> allowedAttackFromStates = new HashSet<MeleeState>(Arrays.asList(MeleeState.READY));
    private static final Set<MeleeState> allowedUpdateFromStates = new HashSet<MeleeState>(Arrays.asList(MeleeState.ATTACKING, MeleeState.HEAVY_ATTACKING, MeleeState.ATTACKING_STABBING, MeleeState.HEAVY_ATTACKING_STABBING, MeleeState.ALERT));
    private ModContext modContext;
    private StateManager<MeleeState, ? super PlayerMeleeInstance> stateManager;

    public MeleeAttackAspect(CommonModContext modContext) {
        this.modContext = modContext;
    }

    @Override
    public void setPermitManager(NetworkPermitManager permitManager) {
    }

    @Override
    public void setStateManager(StateManager<MeleeState, ? super PlayerMeleeInstance> stateManager) {
        this.stateManager = stateManager;
        stateManager.in(this).change(MeleeState.READY).to(MeleeState.ATTACKING).when(attackCooldownTimeoutExpired).manual().in(this).change(MeleeState.ATTACKING).to(MeleeState.ATTACKING_STABBING).withAction(i -> this.attack((PlayerMeleeInstance)i, false)).when(readyToStab).automatic().in(this).change(MeleeState.ATTACKING_STABBING).to(MeleeState.READY).withAction(i -> i.setLastAttackTimestamp(System.currentTimeMillis())).when(attackTimeoutExpired).automatic().in(this).change(MeleeState.READY).to(MeleeState.HEAVY_ATTACKING).when(heavyAttackCooldownTimeoutExpired).manual().in(this).change(MeleeState.HEAVY_ATTACKING).to(MeleeState.HEAVY_ATTACKING_STABBING).withAction(i -> this.attack((PlayerMeleeInstance)i, true)).when(readyToHeavyStab).automatic().in(this).change(MeleeState.HEAVY_ATTACKING_STABBING).to(MeleeState.READY).withAction(i -> i.setLastAttackTimestamp(System.currentTimeMillis())).when(heavyAttackTimeoutExpired).automatic();
    }

    void onAttackButtonClick(EntityPlayer player) {
        PlayerMeleeInstance weaponInstance = this.modContext.getPlayerItemInstanceRegistry().getMainHandItemInstance((EntityLivingBase)player, PlayerMeleeInstance.class);
        if (weaponInstance != null) {
            this.stateManager.changeStateFromAnyOf(this, weaponInstance, allowedAttackFromStates, new MeleeState[]{MeleeState.ATTACKING, MeleeState.ALERT});
        }
    }

    void onHeavyAttackButtonClick(EntityPlayer player) {
        PlayerMeleeInstance weaponInstance = this.modContext.getPlayerItemInstanceRegistry().getMainHandItemInstance((EntityLivingBase)player, PlayerMeleeInstance.class);
        if (weaponInstance != null) {
            this.stateManager.changeStateFromAnyOf(this, weaponInstance, allowedAttackFromStates, new MeleeState[]{MeleeState.HEAVY_ATTACKING, MeleeState.ALERT});
        }
    }

    void onUpdate(EntityPlayer player) {
        PlayerMeleeInstance weaponInstance = this.modContext.getPlayerItemInstanceRegistry().getMainHandItemInstance((EntityLivingBase)player, PlayerMeleeInstance.class);
        if (weaponInstance != null) {
            this.stateManager.changeStateFromAnyOf(this, weaponInstance, allowedUpdateFromStates, new MeleeState[0]);
        }
    }

    private void cannotAttack(PlayerMeleeInstance meleeInstance) {
        if (meleeInstance.getPlayer() instanceof EntityPlayer) {
            ((EntityPlayer)meleeInstance.getPlayer()).func_146105_b((ITextComponent)new TextComponentString(I18n.func_135052_a((String)"gui.coolingDown", (Object[])new Object[0])), true);
        }
        meleeInstance.getPlayer().func_184185_a(this.modContext.getNoAmmoSound(), 1.0f, 1.0f);
    }

    private void attack(PlayerMeleeInstance meleeInstance, boolean isHeavyAttack) {
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            this.attackClient(meleeInstance, isHeavyAttack);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void attackClient(PlayerMeleeInstance meleeInstance, boolean isHeavyAttack) {
        RayTraceResult objectMouseOver = ClientProxy.MC.field_71476_x;
        if (objectMouseOver != null) {
            EntityPlayerSP player = ClientProxy.MC.field_71439_g;
            World world = player.field_70170_p;
            player.func_184185_a(isHeavyAttack ? meleeInstance.getWeapon().getHeavyAtackSound() : meleeInstance.getWeapon().getLightAtackSound(), 1.0f, 1.0f);
            switch (objectMouseOver.field_72313_a) {
                case ENTITY: {
                    this.attackEntity(objectMouseOver.field_72308_g, (EntityPlayer)player, meleeInstance, isHeavyAttack);
                    break;
                }
                case BLOCK: {
                    if (world.func_175623_d(objectMouseOver.func_178782_a())) break;
                    ClientProxy.MC.field_71442_b.func_180511_b(objectMouseOver.func_178782_a(), objectMouseOver.field_178784_b);
                }
            }
        }
    }

    private void attackEntity(Entity entity, EntityPlayer player, PlayerMeleeInstance instance, boolean isHeavyAttack) {
        MWC.CHANNEL.sendToServer((IMessage)new MeleeAttackMessage(instance, entity.func_145782_y(), isHeavyAttack));
        entity.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), instance.getWeapon().getDamage(isHeavyAttack));
    }

    public void serverAttack(EntityPlayer player, PlayerMeleeInstance instance, Entity entity, boolean isHeavyAttack) {
        ModReference.LOG.debug("Player {} hits {} with {} in state {} with damage {}", (Object)player, (Object)entity, (Object)instance, instance.getState(), (Object)Float.valueOf(instance.getWeapon().getDamage(isHeavyAttack)));
        float damage = instance.getWeapon().getDamage(isHeavyAttack);
        entity.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), damage);
        NetworkRegistry.TargetPoint point = new NetworkRegistry.TargetPoint(entity.field_71093_bK, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 100.0);
        double motionX = entity.field_70165_t - player.field_70165_t;
        double motionY = entity.field_70163_u - player.field_70163_u;
        double motionZ = entity.field_70161_v - player.field_70161_v;
        int count = this.getParticleCount(damage);
        ModReference.LOG.debug("Generating {} particle(s) per damage {}", (Object)count, (Object)Float.valueOf(damage));
        MWC.CHANNEL.sendToAllAround((IMessage)new BloodClientMessage(new Vector3F((float)(entity.field_70165_t - motionX / 2.0), (float)(entity.field_70163_u - motionY / 2.0) + 1.0f, (float)(entity.field_70161_v - motionZ / 2.0)), new Vector3F((float)motionX / 16.0f, (float)motionY / 16.0f, (float)motionZ / 16.0f)), point);
    }

    int getParticleCount(float damage) {
        return (int)(-0.11 * (double)(damage - 30.0f) * (double)(damage - 30.0f) + 100.0);
    }
}

