/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.grenade;

import com.paneedah.mwc.MWC;
import com.paneedah.mwc.network.NetworkPermitManager;
import com.paneedah.mwc.network.messages.GrenadeMessage;
import com.paneedah.mwc.utils.ModReference;
import com.paneedah.weaponlib.CommonModContext;
import com.paneedah.weaponlib.Explosion;
import com.paneedah.weaponlib.ModContext;
import com.paneedah.weaponlib.grenade.EntityFlashGrenade;
import com.paneedah.weaponlib.grenade.EntityGasGrenade;
import com.paneedah.weaponlib.grenade.EntityGrenade;
import com.paneedah.weaponlib.grenade.EntitySmokeGrenade;
import com.paneedah.weaponlib.grenade.GrenadeState;
import com.paneedah.weaponlib.grenade.ItemGrenade;
import com.paneedah.weaponlib.grenade.PlayerGrenadeInstance;
import com.paneedah.weaponlib.state.Aspect;
import com.paneedah.weaponlib.state.StateManager;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GrenadeAttackAspect
implements Aspect<GrenadeState, PlayerGrenadeInstance> {
    private static final long ALERT_TIMEOUT = 300L;
    private Predicate<PlayerGrenadeInstance> hasSafetyPin = instance -> instance.getWeapon().hasSafetyPin();
    private static Predicate<PlayerGrenadeInstance> reequipTimeoutExpired = instance -> System.currentTimeMillis() > instance.getStateUpdateTimestamp() + instance.getWeapon().getReequipTimeout();
    private static Predicate<PlayerGrenadeInstance> throwingCompleted = instance -> (double)System.currentTimeMillis() >= (double)instance.getStateUpdateTimestamp() + instance.getWeapon().getTotalThrowingDuration() * 1.1;
    private static Predicate<PlayerGrenadeInstance> explosionTimeoutExpired = instance -> System.currentTimeMillis() >= instance.getStateUpdateTimestamp() + (long)instance.getWeapon().getExplosionTimeout();
    private static final Set<GrenadeState> allowedAttackFromStates = new HashSet<GrenadeState>(Arrays.asList(GrenadeState.READY, GrenadeState.STRIKER_LEVER_RELEASED));
    private static final Set<GrenadeState> allowedPinOffFromStates = new HashSet<GrenadeState>(Arrays.asList(GrenadeState.SAFETY_PING_OFF));
    private static final Set<GrenadeState> allowedUpdateFromStates = new HashSet<GrenadeState>(Arrays.asList(GrenadeState.STRIKER_LEVER_RELEASED, GrenadeState.THROWING, GrenadeState.THROWN, GrenadeState.EXPLODED_IN_HANDS));
    private static final int SAFETY_IN_ALERT_TIMEOUT = 1000;
    private ModContext modContext;
    private StateManager<GrenadeState, ? super PlayerGrenadeInstance> stateManager;

    public GrenadeAttackAspect(CommonModContext modContext) {
        this.modContext = modContext;
    }

    @Override
    public void setPermitManager(NetworkPermitManager permitManager) {
    }

    @Override
    public void setStateManager(StateManager<GrenadeState, ? super PlayerGrenadeInstance> stateManager) {
        this.stateManager = stateManager;
        stateManager.in(this).change(GrenadeState.READY).to(GrenadeState.SAFETY_PING_OFF).withAction(i -> this.takeSafetyPinOff((PlayerGrenadeInstance)i)).when(this.hasSafetyPin).manual().in(this).change(GrenadeState.SAFETY_PING_OFF).to(GrenadeState.STRIKER_LEVER_RELEASED).withAction(i -> this.releaseStrikerLever((PlayerGrenadeInstance)i)).manual().in(this).change(GrenadeState.STRIKER_LEVER_RELEASED).to(GrenadeState.EXPLODED_IN_HANDS).withAction(i -> this.explode((PlayerGrenadeInstance)i)).when(explosionTimeoutExpired.and(i -> i.getWeapon().getType() == ItemGrenade.Type.REGULAR)).automatic().in(this).change(GrenadeState.READY).to(GrenadeState.THROWING).when(this.hasSafetyPin.negate()).manual().in(this).change(GrenadeState.THROWING).to(GrenadeState.THROWN).withAction(i -> this.throwIt((PlayerGrenadeInstance)i)).when(throwingCompleted).automatic().in(this).change(GrenadeState.STRIKER_LEVER_RELEASED).to(GrenadeState.THROWING).manual().in(this).change(GrenadeState.THROWN).to(GrenadeState.READY).withAction(i -> this.reequip((PlayerGrenadeInstance)i)).when(reequipTimeoutExpired).automatic().in(this).change(GrenadeState.EXPLODED_IN_HANDS).to(GrenadeState.READY).withAction(i -> this.reequip((PlayerGrenadeInstance)i)).when(reequipTimeoutExpired).automatic();
    }

    private void explode(PlayerGrenadeInstance instance) {
        ModReference.LOG.debug("Exploding!");
        MWC.CHANNEL.sendToServer((IMessage)new GrenadeMessage(instance, 0L));
    }

    private void throwIt(PlayerGrenadeInstance instance) {
        ModReference.LOG.debug("Throwing with state " + instance.getState());
        long activationTimestamp = instance.getWeapon().getType() != ItemGrenade.Type.REGULAR ? System.currentTimeMillis() : (instance.getWeapon().getExplosionTimeout() > 0 ? instance.getActivationTimestamp() : -1L);
        instance.getPlayer().func_184185_a(instance.getWeapon().getThrowSound(), 1.0f, 1.0f);
        MWC.CHANNEL.sendToServer((IMessage)new GrenadeMessage(instance, activationTimestamp));
    }

    private void reequip(PlayerGrenadeInstance instance) {
        ModReference.LOG.debug("Reequipping");
    }

    private void takeSafetyPinOff(PlayerGrenadeInstance instance) {
        instance.getPlayer().func_184185_a(instance.getWeapon().getSafetyPinOffSound(), 1.0f, 1.0f);
        ModReference.LOG.debug("Taking safety pin off");
    }

    private void releaseStrikerLever(PlayerGrenadeInstance instance) {
        ModReference.LOG.debug("Safety pin is off");
        instance.setActivationTimestamp(System.currentTimeMillis());
    }

    void onAttackButtonClick(EntityPlayer player, boolean throwingFar) {
        PlayerGrenadeInstance grenadeInstance = this.modContext.getPlayerItemInstanceRegistry().getMainHandItemInstance((EntityLivingBase)player, PlayerGrenadeInstance.class);
        if (grenadeInstance != null) {
            grenadeInstance.setThrowingFar(throwingFar);
            this.stateManager.changeStateFromAnyOf(this, grenadeInstance, allowedAttackFromStates, new GrenadeState[]{GrenadeState.SAFETY_PING_OFF, GrenadeState.THROWING});
        }
    }

    void onAttackButtonUp(EntityPlayer player, boolean throwingFar) {
        PlayerGrenadeInstance grenadeInstance = this.modContext.getPlayerItemInstanceRegistry().getMainHandItemInstance((EntityLivingBase)player, PlayerGrenadeInstance.class);
        if (grenadeInstance != null) {
            grenadeInstance.setThrowingFar(throwingFar);
            this.stateManager.changeStateFromAnyOf(this, grenadeInstance, allowedPinOffFromStates, new GrenadeState[]{GrenadeState.STRIKER_LEVER_RELEASED});
        }
    }

    void onUpdate(EntityPlayer player) {
        PlayerGrenadeInstance grenadeInstance = this.modContext.getPlayerItemInstanceRegistry().getMainHandItemInstance((EntityLivingBase)player, PlayerGrenadeInstance.class);
        if (grenadeInstance != null) {
            if (grenadeInstance.getState() == GrenadeState.STRIKER_LEVER_RELEASED && grenadeInstance.getWeapon().getType() == ItemGrenade.Type.REGULAR && System.currentTimeMillis() > grenadeInstance.getLastSafetyPinAlertTimestamp() + 1000L) {
                long remainingTimeUntilExplosion = (long)grenadeInstance.getWeapon().getExplosionTimeout() - (System.currentTimeMillis() - grenadeInstance.getActivationTimestamp());
                if (remainingTimeUntilExplosion < 0L) {
                    remainingTimeUntilExplosion = 0L;
                }
                if (grenadeInstance.getPlayer() instanceof EntityPlayer) {
                    ((EntityPlayer)grenadeInstance.getPlayer()).func_146105_b((ITextComponent)new TextComponentString("\u00a7e" + I18n.func_135052_a((String)"gui.grenadeExplodes", (Object[])new Object[]{Math.round((float)remainingTimeUntilExplosion / 1000.0f)})), true);
                }
                grenadeInstance.setLastSafetyPinAlertTimestamp(System.currentTimeMillis());
            }
            this.stateManager.changeStateFromAnyOf(this, grenadeInstance, allowedUpdateFromStates, new GrenadeState[0]);
        }
    }

    public void serverThrowGrenade(EntityPlayer player, PlayerGrenadeInstance instance, long activationTimestamp) {
        ModReference.LOG.debug("Throwing grenade");
        GrenadeAttackAspect.serverThrowGrenade(this.modContext, (EntityLivingBase)player, instance, activationTimestamp);
        if (player.field_71071_by.func_70301_a(instance.getItemInventoryIndex()) == null) {
            return;
        }
        if (!player.field_71075_bZ.field_75098_d) {
            player.field_71071_by.func_70301_a(instance.getItemInventoryIndex()).func_190918_g(1);
        }
        if (((ItemStack)player.field_71071_by.field_70462_a.get(instance.getItemInventoryIndex())).func_190916_E() <= 0) {
            player.field_71071_by.func_70304_b(instance.getItemInventoryIndex());
        }
    }

    public static void serverThrowGrenade(ModContext modContext, EntityLivingBase player, PlayerGrenadeInstance instance, long activationTimestamp) {
        if (activationTimestamp == 0L && instance.getWeapon().getType() == ItemGrenade.Type.REGULAR) {
            player.func_70097_a(DamageSource.func_188405_b((EntityLivingBase)player), 500.0f);
            Explosion.createServerSideExplosion(player.field_70170_p, player, null, player.field_70165_t, player.field_70163_u, player.field_70161_v, instance.getWeapon().getExplosionStrength(), false, true, instance.getWeapon().isDestroyingBlocks(), 1.0f, 1.0f, 1.5f, 1.0f, null, null, modContext.getExplosionSound());
        } else if (instance.getWeapon().getType() == ItemGrenade.Type.SMOKE) {
            float velocity = instance.isThrowingFar() ? instance.getWeapon().getFarVelocity() : instance.getWeapon().getVelocity();
            EntitySmokeGrenade entityGrenade = new EntitySmokeGrenade.Builder().withThrower(player).withActivationTimestamp(activationTimestamp).withGrenade(instance.getWeapon()).withSmokeAmount(instance.getWeapon().getExplosionStrength()).withActivationDelay(0L).withActiveDuration(instance.getWeapon().getActiveDuration()).withVelocity(velocity).withGravityVelocity(instance.getWeapon().getGravityVelocity()).withRotationSlowdownFactor(instance.getWeapon().getRotationSlowdownFactor()).build(modContext);
            ModReference.LOG.debug("Throwing velocity {} ", (Object)Float.valueOf(velocity));
            if (player != null) {
                player.field_70170_p.func_72838_d((Entity)entityGrenade);
            }
        } else if (instance.getWeapon().getType() == ItemGrenade.Type.GAS) {
            float velocity = instance.isThrowingFar() ? instance.getWeapon().getFarVelocity() : instance.getWeapon().getVelocity();
            EntityGasGrenade entityGrenade = new EntityGasGrenade.Builder().withThrower(player).withActivationTimestamp(activationTimestamp).withGrenade(instance.getWeapon()).withSmokeAmount(instance.getWeapon().getExplosionStrength()).withActivationDelay(0L).withActiveDuration(instance.getWeapon().getActiveDuration()).withVelocity(velocity).withGravityVelocity(instance.getWeapon().getGravityVelocity()).withRotationSlowdownFactor(instance.getWeapon().getRotationSlowdownFactor()).build(modContext);
            ModReference.LOG.debug("Throwing velocity {} ", (Object)Float.valueOf(velocity));
            if (player != null) {
                player.field_70170_p.func_72838_d((Entity)entityGrenade);
            }
        } else if (instance.getWeapon().getType() == ItemGrenade.Type.FLASH) {
            float velocity = instance.isThrowingFar() ? instance.getWeapon().getFarVelocity() : instance.getWeapon().getVelocity();
            EntityFlashGrenade entityGrenade = new EntityFlashGrenade.Builder().withThrower(player).withActivationTimestamp(activationTimestamp).withGrenade(instance.getWeapon()).withExplosionStrength(instance.getWeapon().getExplosionStrength()).withExplosionTimeout(instance.getWeapon().getExplosionTimeout()).withVelocity(velocity).withGravityVelocity(instance.getWeapon().getGravityVelocity()).withRotationSlowdownFactor(instance.getWeapon().getRotationSlowdownFactor()).withDestroyingBlocks(false).build(modContext);
            ModReference.LOG.debug("Throwing velocity {} ", (Object)Float.valueOf(velocity));
            if (player != null) {
                player.field_70170_p.func_72838_d((Entity)entityGrenade);
            }
        } else {
            float velocity = instance.isThrowingFar() ? instance.getWeapon().getFarVelocity() : instance.getWeapon().getVelocity();
            EntityGrenade entityGrenade = new EntityGrenade.Builder().withThrower(player).withActivationTimestamp(activationTimestamp).withGrenade(instance.getWeapon()).withExplosionStrength(instance.getWeapon().getExplosionStrength()).withExplosionTimeout(instance.getWeapon().getExplosionTimeout()).withVelocity(velocity).withGravityVelocity(instance.getWeapon().getGravityVelocity()).withRotationSlowdownFactor(instance.getWeapon().getRotationSlowdownFactor()).withDestroyingBlocks(instance.getWeapon().isDestroyingBlocks()).build(modContext);
            ModReference.LOG.debug("Throwing velocity {} ", (Object)Float.valueOf(velocity));
            if (player != null) {
                player.field_70170_p.func_72838_d((Entity)entityGrenade);
            }
        }
    }

    int getParticleCount(float damage) {
        return (int)(-0.11 * (double)(damage - 30.0f) * (double)(damage - 30.0f) + 100.0);
    }
}

