/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.electronics;

import com.paneedah.mwc.network.TypeRegistry;
import com.paneedah.mwc.utils.ModReference;
import com.paneedah.weaponlib.PlayerItemInstance;
import com.paneedah.weaponlib.electronics.TabletState;
import com.paneedah.weaponlib.perspective.Perspective;
import com.paneedah.weaponlib.perspective.WirelessCameraPerspective;
import com.paneedah.weaponlib.tracking.LivingEntityTracker;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;

public class PlayerTabletInstance
extends PlayerItemInstance<TabletState> {
    private static final int SERIAL_VERSION = 1;
    private int activeWatchIndex;

    public PlayerTabletInstance() {
    }

    public PlayerTabletInstance(int itemInventoryIndex, EntityLivingBase player, ItemStack itemStack) {
        super(itemInventoryIndex, player, itemStack);
    }

    public PlayerTabletInstance(int itemInventoryIndex, EntityLivingBase player) {
        super(itemInventoryIndex, player);
    }

    @Override
    public Class<? extends Perspective<?>> getRequiredPerspectiveType() {
        return WirelessCameraPerspective.class;
    }

    @Override
    public void write(ByteBuf byteBuf) {
        super.write(byteBuf);
        byteBuf.writeInt(this.activeWatchIndex);
    }

    public void setActiveWatchIndex(int activeWatchIndex) {
        if (this.activeWatchIndex != activeWatchIndex) {
            ModReference.LOG.debug("Changing active watch index to {}", (Object)activeWatchIndex);
            this.activeWatchIndex = activeWatchIndex;
            this.markDirty();
        }
    }

    public int getActiveWatchIndex() {
        return this.activeWatchIndex;
    }

    @Override
    public void read(ByteBuf byteBuf) {
        super.read(byteBuf);
        this.activeWatchIndex = byteBuf.readInt();
    }

    @Override
    protected int getSerialVersion() {
        return 1;
    }

    public void nextActiveWatchIndex() {
        LivingEntityTracker tracker = LivingEntityTracker.getTracker(this.player);
        if (tracker != null) {
            if (this.activeWatchIndex >= tracker.getTrackableEntitites().size() - 1) {
                this.setActiveWatchIndex(0);
            } else {
                this.setActiveWatchIndex(this.activeWatchIndex + 1);
            }
        }
    }

    public void previousActiveWatchIndex() {
        LivingEntityTracker tracker = LivingEntityTracker.getTracker(this.player);
        if (tracker != null) {
            if (this.activeWatchIndex == 0) {
                this.setActiveWatchIndex(tracker.getTrackableEntitites().size() - 1);
            } else {
                this.setActiveWatchIndex(this.activeWatchIndex - 1);
            }
        }
    }

    public String toString() {
        return "Tablet [" + this.getUuid() + "]";
    }

    static {
        TypeRegistry.getINSTANCE().register(PlayerTabletInstance.class);
    }
}

