/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.electronics;

import com.paneedah.mwc.renderer.ModelSourceTransforms;
import com.paneedah.mwc.renderer.StaticModelSourceRenderer;
import com.paneedah.weaponlib.AttachmentCategory;
import com.paneedah.weaponlib.CustomRenderer;
import com.paneedah.weaponlib.ModContext;
import com.paneedah.weaponlib.ModelSource;
import com.paneedah.weaponlib.Tuple;
import com.paneedah.weaponlib.animation.Transform;
import com.paneedah.weaponlib.crafting.CraftingComplexity;
import com.paneedah.weaponlib.crafting.OptionsMetadata;
import com.paneedah.weaponlib.electronics.EntityWirelessCamera;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.model.ModelBase;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class ItemWirelessCamera
extends Item
implements ModelSource {
    public static final long DEFAULT_DURATION = 300000L;
    private Builder builder;
    private ModContext modContext;
    private List<Tuple<ModelBase, String>> texturedModels = new ArrayList<Tuple<ModelBase, String>>();

    public ItemWirelessCamera(Builder builder, ModContext modContext) {
        this.builder = builder;
        this.modContext = modContext;
        this.field_77777_bU = 16;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        itemStack.func_190920_e(itemStack.func_190916_E() - 1);
        if (!world.field_72995_K && player != null) {
            player.field_70170_p.func_72838_d((Entity)new EntityWirelessCamera(this.modContext, world, player, this, this.builder.duration));
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStack);
    }

    @Override
    public List<Tuple<ModelBase, String>> getTexturedModels() {
        return this.texturedModels;
    }

    @Override
    public CustomRenderer<?> getPostRenderer() {
        return null;
    }

    public ModelBase getModel() {
        return this.texturedModels.get(0).getU();
    }

    public String getTextureName() {
        return this.texturedModels.get(0).getV();
    }

    public static class Builder {
        protected String name;
        protected ModelBase model;
        protected String textureName;
        protected ModelSourceTransforms transforms = ModelSourceTransforms.builder().entityPositioning(() -> new Transform().withPosition(-0.5, -0.55, 0.5).withScale(0.5, 0.5, 0.5).doGLDirect()).inventoryPositioning(() -> new Transform().withScale(2.25, 2.25, 2.25).withPosition(-0.8, -0.7, 0.0).doGLDirect()).build();
        protected CreativeTabs tab;
        protected AttachmentCategory attachmentCategory;
        private List<Tuple<ModelBase, String>> texturedModels = new ArrayList<Tuple<ModelBase, String>>();
        private int maxStackSize = 1;
        private CraftingComplexity craftingComplexity;
        private Object[] craftingMaterials;
        private int craftingCount = 1;
        private long duration = 300000L;

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withCreativeTab(CreativeTabs tab) {
            this.tab = tab;
            return this;
        }

        public Builder withModel(ModelBase model) {
            this.model = model;
            return this;
        }

        public Builder withTextureName(String textureName) {
            this.textureName = textureName.toLowerCase();
            return this;
        }

        public Builder withMaxStackSize(int maxStackSize) {
            this.maxStackSize = maxStackSize;
            return this;
        }

        public Builder withEntityPositioning(Runnable entityPositioning) {
            this.transforms.setEntityPositioning(entityPositioning);
            return this;
        }

        public Builder withInventoryPositioning(Runnable inventoryPositioning) {
            this.transforms.setInventoryPositioning(inventoryPositioning);
            return this;
        }

        public Builder withThirdPersonPositioning(Runnable thirdPersonPositioning) {
            this.transforms.setThirdPersonPositioning(thirdPersonPositioning);
            return this;
        }

        public Builder withFirstPersonPositioning(Runnable firstPersonPositioning) {
            this.transforms.setFirstPersonPositioning(firstPersonPositioning);
            return this;
        }

        public Builder withFirstPersonModelPositioning(Consumer<ModelBase> firstPersonModelPositioning) {
            this.transforms.setFirstPersonModelPositioning(firstPersonModelPositioning);
            return this;
        }

        public Builder withEntityModelPositioning(Consumer<ModelBase> entityModelPositioning) {
            this.transforms.setEntityModelPositioning(entityModelPositioning);
            return this;
        }

        public Builder withInventoryModelPositioning(Consumer<ModelBase> inventoryModelPositioning) {
            this.transforms.setInventoryModelPositioning(inventoryModelPositioning);
            return this;
        }

        public Builder withThirdPersonModelPositioning(Consumer<ModelBase> thirdPersonModelPositioning) {
            this.transforms.setThirdPersonModelPositioning(thirdPersonModelPositioning);
            return this;
        }

        public Builder withFirstPersonHandPositioning(Runnable leftHand, Runnable rightHand) {
            this.transforms.setFirstPersonLeftHandPositioning(leftHand);
            this.transforms.setFirstPersonRightHandPositioning(rightHand);
            return this;
        }

        public Builder withModel(ModelBase model, String textureName) {
            this.texturedModels.add(new Tuple<ModelBase, String>(model, textureName.toLowerCase()));
            return this;
        }

        public Builder withCrafting(CraftingComplexity craftingComplexity, Object ... craftingMaterials) {
            return this.withCrafting(1, craftingComplexity, craftingMaterials);
        }

        public Builder withCrafting(int craftingCount, CraftingComplexity craftingComplexity, Object ... craftingMaterials) {
            if (craftingComplexity == null) {
                throw new IllegalArgumentException("Crafting complexity not set");
            }
            if (craftingMaterials.length < 2) {
                throw new IllegalArgumentException("2 or more materials required for crafting");
            }
            if (craftingCount == 0) {
                throw new IllegalArgumentException("Invalid item count");
            }
            this.craftingComplexity = craftingComplexity;
            this.craftingMaterials = craftingMaterials;
            this.craftingCount = craftingCount;
            return this;
        }

        public Builder withDuration(long duration) {
            this.duration = duration;
            return this;
        }

        public ItemWirelessCamera build(ModContext modContext) {
            ItemWirelessCamera camera = new ItemWirelessCamera(this, modContext);
            camera.func_77655_b("mwc_" + this.name);
            camera.func_77637_a(this.tab);
            camera.field_77777_bU = this.maxStackSize;
            this.texturedModels.forEach(tm -> camera.texturedModels.add(new Tuple(tm.getU(), Builder.addFileExtension((String)tm.getV(), ".png"))));
            if (this.model != null) {
                this.texturedModels.add(new Tuple<ModelBase, String>(this.model, Builder.addFileExtension(this.textureName, ".png")));
            }
            if (this.model != null || !this.texturedModels.isEmpty()) {
                modContext.registerRenderableItem(this.name, (Item)camera, (Object)(FMLCommonHandler.instance().getSide() == Side.CLIENT ? new StaticModelSourceRenderer(this.transforms) : null));
            }
            if (this.craftingComplexity != null) {
                OptionsMetadata optionsMetadata = new OptionsMetadata.OptionMetadataBuilder().withSlotCount(9).build(this.craftingComplexity, Arrays.copyOf(this.craftingMaterials, this.craftingMaterials.length));
                List<Object> shape = modContext.getRecipeManager().createShapedRecipe(camera, this.name, optionsMetadata);
                ItemStack itemStack = new ItemStack((Item)camera);
                itemStack.func_190920_e(this.craftingCount);
                if (optionsMetadata.hasOres()) {
                    ForgeRegistries.RECIPES.register(new ShapedOreRecipe(null, itemStack, shape.toArray()).setMirrored(false).setRegistryName("mwc", itemStack.func_77973_b().func_77658_a() + "_recipe"));
                } else {
                    ForgeRegistries.RECIPES.register(new ShapedOreRecipe(null, itemStack, shape.toArray()).setMirrored(false).setRegistryName("mwc", itemStack.func_77973_b().func_77658_a() + "_recipe"));
                }
            }
            return camera;
        }

        static String addFileExtension(String s, String ext) {
            return s != null && !s.endsWith(ext) ? s + ext : s;
        }

        protected static String stripFileExtension(String str, String extension) {
            return str.endsWith(extension) ? str.substring(0, str.length() - extension.length()) : str;
        }
    }
}

