/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.electronics;

import com.paneedah.mwc.renderer.ModelSourceTransforms;
import com.paneedah.weaponlib.AttachmentBuilder;
import com.paneedah.weaponlib.AttachmentCategory;
import com.paneedah.weaponlib.ItemAttachment;
import com.paneedah.weaponlib.ModContext;
import com.paneedah.weaponlib.PlayerItemInstanceFactory;
import com.paneedah.weaponlib.Updatable;
import com.paneedah.weaponlib.animation.Transform;
import com.paneedah.weaponlib.electronics.PlayerTabletInstance;
import com.paneedah.weaponlib.electronics.TabletState;
import com.paneedah.weaponlib.perspective.PerspectiveRenderer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class ItemTablet<T>
extends ItemAttachment<T>
implements PlayerItemInstanceFactory<PlayerTabletInstance, TabletState>,
Updatable {
    private final int DEFAULT_MAX_STACK_SIZE = 1;
    private ModContext modContext;
    private Builder<T> builder;

    private ItemTablet(Builder<T> builder) {
        super(AttachmentCategory.SCOPE, builder.getModel(), builder.getTextureName(), null, null, null);
        this.builder = builder;
        this.func_77625_d(1);
    }

    @Override
    public void update(EntityPlayer player) {
    }

    @Override
    public PlayerTabletInstance createItemInstance(EntityLivingBase player, ItemStack stack, int slot) {
        PlayerTabletInstance instance = new PlayerTabletInstance(slot, player, stack);
        instance.setState(TabletState.READY);
        return instance;
    }

    public static final class Builder<T>
    extends AttachmentBuilder<T> {
        private Runnable viewfinderPositioning;

        public Builder() {
            this.transforms = ModelSourceTransforms.builder().entityPositioning(() -> new Transform().withScale(0.3, 0.3, 0.3).withPosition(-0.5, -0.5, 0.5).doGLDirect()).inventoryPositioning(() -> new Transform().withScale(1.0, 1.0, 1.0).withPosition(-0.24, 0.24, 0.0).doGLDirect()).build();
        }

        public Builder<T> withViewfinderPositioning(Runnable viewfinderPositioning) {
            this.viewfinderPositioning = viewfinderPositioning;
            return this;
        }

        @Override
        protected ItemAttachment<T> createAttachment(ModContext modContext) {
            if (this.viewfinderPositioning == null) {
                this.viewfinderPositioning = () -> {
                    GL11.glScalef((float)3.0f, (float)3.0f, (float)3.0f);
                    GL11.glTranslatef((float)0.1f, (float)0.5f, (float)0.1f);
                };
            }
            this.withPostRender(new PerspectiveRenderer(this.viewfinderPositioning));
            ItemTablet itemTablet = new ItemTablet(this);
            itemTablet.modContext = modContext;
            return itemTablet;
        }

        @Override
        public ItemAttachment<T> build(ModContext modContext) {
            return super.build(modContext);
        }
    }
}

