/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.crafting.base;

import com.paneedah.weaponlib.ClientEventHandler;
import com.paneedah.weaponlib.ModContext;
import com.paneedah.weaponlib.crafting.base.TileEntityStation;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class BlockStation
extends Block {
    protected ModContext modContext;
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;

    public BlockStation(ModContext context, String name, Material materialIn) {
        super(materialIn);
        this.modContext = context;
        if (context.isClient()) {
            ClientEventHandler.BLANKMAPPED_LIST.add(this);
        }
        this.func_149711_c(2.0f);
        this.func_149663_c(name);
        this.setRegistryName(name);
        this.func_149647_a(CreativeTabs.field_78026_f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        this.setDefaultFacing(worldIn, pos, state);
    }

    private void setDefaultFacing(World worldIn, BlockPos pos, IBlockState state) {
        if (worldIn.field_72995_K) {
            return;
        }
        IBlockState iblockstate = worldIn.func_180495_p(pos.func_177978_c());
        IBlockState iblockstate1 = worldIn.func_180495_p(pos.func_177968_d());
        IBlockState iblockstate2 = worldIn.func_180495_p(pos.func_177976_e());
        IBlockState iblockstate3 = worldIn.func_180495_p(pos.func_177974_f());
        EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        if (enumfacing == EnumFacing.NORTH && iblockstate.func_185913_b() && !iblockstate1.func_185913_b()) {
            enumfacing = EnumFacing.SOUTH;
        } else if (enumfacing == EnumFacing.SOUTH && iblockstate1.func_185913_b() && !iblockstate.func_185913_b()) {
            enumfacing = EnumFacing.NORTH;
        } else if (enumfacing == EnumFacing.WEST && iblockstate2.func_185913_b() && !iblockstate3.func_185913_b()) {
            enumfacing = EnumFacing.EAST;
        } else if (enumfacing == EnumFacing.EAST && iblockstate3.func_185913_b() && !iblockstate2.func_185913_b()) {
            enumfacing = EnumFacing.WEST;
        }
        worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)enumfacing), 2);
    }

    public abstract TileEntity createTileEntity(World var1, IBlockState var2);

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)meta);
        if (enumfacing.func_176740_k() == EnumFacing.Axis.Y) {
            enumfacing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (worldIn.field_72995_K) {
            super.func_176208_a(worldIn, pos, state, player);
            return;
        }
        TileEntityStation station = (TileEntityStation)worldIn.func_175625_s(pos);
        if (station == null) {
            return;
        }
        for (int i = 0; i < station.mainInventory.getSlots(); ++i) {
            ItemStack stack = station.mainInventory.getStackInSlot(i);
            worldIn.func_72838_d((Entity)new EntityItem(worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), stack));
        }
        super.func_176208_a(worldIn, pos, state, player);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }
}

