/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.crafting.ammopress;

import com.paneedah.weaponlib.ItemBullet;
import com.paneedah.weaponlib.crafting.CraftingEntry;
import com.paneedah.weaponlib.crafting.CraftingGroup;
import com.paneedah.weaponlib.crafting.IModernCraftingRecipe;
import com.paneedah.weaponlib.crafting.base.TileEntityStation;
import io.netty.buffer.ByteBuf;
import java.util.LinkedList;
import java.util.Objects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class TileEntityAmmoPress
extends TileEntityStation {
    public static final int BULLET_CRAFT_DURATION = 2;
    public static final int MAGAZINE_CRAFT_DURATION = 100;
    public static final int BULLETS_CRAFTED_PER_PRESS = 6;
    private boolean crafting;
    public LinkedList<ItemStack> craftStack = new LinkedList();
    private double currentWheelRotation = 0.0;
    private double prevWheelRotation = 0.0;

    public double getCurrentWheelRotation() {
        return this.currentWheelRotation;
    }

    public double getPreviousWheelRotation() {
        return this.prevWheelRotation;
    }

    public int getCraftingDurationForItem(Item item) {
        if (!(item instanceof IModernCraftingRecipe)) {
            return 0;
        }
        return this.getDismantlingTime((IModernCraftingRecipe)item);
    }

    @Override
    public int getDismantlingTime(IModernCraftingRecipe crafting) {
        CraftingGroup group = crafting.getCraftingGroup();
        if (Objects.requireNonNull(group) == CraftingGroup.BULLET) {
            return 2;
        }
        return 100;
    }

    public ItemStack getLatestStackInQueue() {
        if (this.craftStack.isEmpty()) {
            return null;
        }
        ItemStack stack = this.craftStack.peek();
        if (stack.func_190926_b()) {
            this.craftStack.pop();
            return this.getLatestStackInQueue();
        }
        return stack;
    }

    @Override
    public void writeBytesForClientSync(ByteBuf buf) {
        super.writeBytesForClientSync(buf);
        buf.writeInt(this.craftStack.size());
        for (ItemStack stack : this.craftStack) {
            ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)stack);
            buf.writeInt(stack.func_190916_E());
        }
    }

    @Override
    public void readBytesFromClientSync(ByteBuf buf) {
        super.readBytesFromClientSync(buf);
        this.craftStack.clear();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            ItemStack stack = ByteBufUtils.readItemStack((ByteBuf)buf);
            stack.func_190920_e(buf.readInt());
            this.craftStack.offer(stack);
        }
    }

    public boolean hasStack() {
        return !this.craftStack.isEmpty() && this.getLatestStackInQueue() != null;
    }

    public void addStack(ItemStack stack) {
        this.craftStack.offer(stack);
    }

    public LinkedList<ItemStack> getCraftingQueue() {
        return this.craftStack;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        NBTTagList stackNBTCompound = new NBTTagList();
        for (ItemStack stack : this.craftStack) {
            NBTTagCompound element = new NBTTagCompound();
            stack.func_77955_b(element);
            stackNBTCompound.func_74742_a((NBTBase)element);
        }
        compound.func_74782_a("craftingStack", (NBTBase)stackNBTCompound);
        return compound;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b("craftingStack")) {
            NBTTagList list = compound.func_150295_c("craftingStack", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                this.craftStack.offer(new ItemStack(list.func_150305_b(i)));
            }
        }
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.hasStack()) {
            boolean canCraftNextItem = true;
            for (CraftingEntry entry : ((IModernCraftingRecipe)this.getLatestStackInQueue().func_77973_b()).getModernRecipe()) {
                if (this.inventoryContainsEnoughItems(entry.getItem(), entry.getCount(), 22, 49)) continue;
                canCraftNextItem = false;
                break;
            }
            if (this.craftingDuration == -1 && canCraftNextItem) {
                this.craftingDuration = this.getCraftingDurationForItem(this.getLatestStackInQueue().func_77973_b());
            }
            if (this.craftingDuration != -1) {
                ++this.craftingTimer;
                this.crafting = true;
            }
            if (this.craftingTimer > this.craftingDuration) {
                this.craftingTimer = -1;
                this.prevCraftingTimer = -1;
                this.craftingDuration = -1;
                this.crafting = false;
                ItemStack stack = this.getLatestStackInQueue();
                IModernCraftingRecipe craftingRecipe = (IModernCraftingRecipe)stack.func_77973_b();
                for (CraftingEntry ingredient : craftingRecipe.getModernRecipe()) {
                    this.consumeFromInventory(ingredient.getItem(), ingredient.getCount(), 22, 49);
                }
                ItemStack splitOff = stack.func_77979_a(1);
                if (splitOff.func_77973_b() instanceof ItemBullet) {
                    splitOff.func_190920_e(splitOff.func_190916_E() * 6);
                }
                this.addStackToInventoryRange(splitOff, 0, 8);
                this.sendUpdate();
            }
        }
        if (this.field_145850_b.field_72995_K && this.hasStack() && this.crafting) {
            this.prevWheelRotation = this.currentWheelRotation;
            this.currentWheelRotation += 0.09817477042468103;
            if (this.currentWheelRotation >= Math.PI * 2) {
                this.prevWheelRotation = 0.0;
                this.currentWheelRotation = 0.0;
            }
        } else if (!(this.hasStack() && this.crafting || !this.field_145850_b.field_72995_K)) {
            double delta = (this.currentWheelRotation - this.prevWheelRotation) * 0.05;
            this.prevWheelRotation = this.currentWheelRotation;
            this.currentWheelRotation += delta;
        }
    }
}

