/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.crafting.ammopress;

import com.paneedah.mwc.MWC;
import com.paneedah.mwc.network.messages.WorkbenchServerMessage;
import com.paneedah.mwc.proxies.ClientProxy;
import com.paneedah.weaponlib.ItemBullet;
import com.paneedah.weaponlib.crafting.CraftingGroup;
import com.paneedah.weaponlib.crafting.CraftingRegistry;
import com.paneedah.weaponlib.crafting.ammopress.ContainerAmmoPress;
import com.paneedah.weaponlib.crafting.ammopress.TileEntityAmmoPress;
import com.paneedah.weaponlib.crafting.base.GUIContainerStation;
import com.paneedah.weaponlib.crafting.workbench.CustomSearchTextField;
import com.paneedah.weaponlib.crafting.workbench.GUIButtonCustom;
import com.paneedah.weaponlib.render.gui.GUIRenderHelper;
import io.redstudioragnarok.redcore.utils.MathUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GUIContainerAmmoPress
extends GUIContainerStation<TileEntityAmmoPress> {
    private static final ResourceLocation AMMO_PRESS_TEX = new ResourceLocation("mwc:textures/gui/ammosheet.png");
    private GUIButtonCustom bulletSelector;
    private GUIButtonCustom magazineSelector;
    private GUIButtonCustom grenadeSelector;
    private CustomSearchTextField quantityBox;

    public GUIContainerAmmoPress(EntityPlayer player, InventoryPlayer inventory, TileEntityAmmoPress tileEntityAmmoPress) {
        super(tileEntityAmmoPress, new ContainerAmmoPress(player, inventory, tileEntityAmmoPress));
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.quantityBox = new CustomSearchTextField(AMMO_PRESS_TEX, "Amt.", 1, 1, this.field_146289_q, this.field_147003_i + 267, this.field_147009_r + 183, 84, 13);
        this.quantityBox.func_146203_f(3);
        this.quantityBox.func_146185_a(true);
        this.quantityBox.func_146189_e(true);
        this.quantityBox.func_146193_g(0xFFFFFF);
        this.bulletSelector = new GUIButtonCustom(AMMO_PRESS_TEX, 3, this.field_147003_i + 107, this.field_147009_r + 29, 19, 20, 256, 256, "").withStandardState(0xFFFFFF, 0, 0).withHoveredState(0xFFFFFF, 19, 0).withToggledState(0xFFFFFF, 38, 0).withPageRestriction(2).makeToggleButton();
        this.magazineSelector = new GUIButtonCustom(AMMO_PRESS_TEX, 4, this.field_147003_i + 130, this.field_147009_r + 29, 19, 20, 256, 256, "").withStandardState(0xFFFFFF, 0, 20).withHoveredState(0xFFFFFF, 19, 20).withToggledState(0xFFFFFF, 38, 20).withPageRestriction(2).makeToggleButton();
        this.grenadeSelector = new GUIButtonCustom(AMMO_PRESS_TEX, 5, this.field_147003_i + 153, this.field_147009_r + 29, 19, 20, 256, 256, "").withStandardState(0xFFFFFF, 0, 40).withHoveredState(0xFFFFFF, 19, 40).withToggledState(0xFFFFFF, 38, 40).withPageRestriction(2).makeToggleButton();
        this.bulletSelector.toggleOn();
        this.func_189646_b(this.bulletSelector);
        this.func_189646_b(this.magazineSelector);
        this.func_189646_b(this.grenadeSelector);
        this.setPage(1);
    }

    @Override
    public boolean requiresMaterialsToSubmitCraftRequest() {
        return false;
    }

    @Override
    public void fillFilteredList() {
        this.filteredCraftingList.clear();
        if (this.getCraftingMode() == 1) {
            this.filteredCraftingList.addAll(CraftingRegistry.getCraftingListForGroup(CraftingGroup.BULLET));
        } else if (this.getCraftingMode() == 2) {
            this.filteredCraftingList.addAll(CraftingRegistry.getCraftingListForGroup(CraftingGroup.MAGAZINE));
        } else if (this.getCraftingMode() == 3) {
            this.filteredCraftingList.addAll(CraftingRegistry.getCraftingListForGroup(CraftingGroup.GRENADE));
        }
    }

    @Override
    public void func_73876_c() {
        super.func_73876_c();
        if (((TileEntityAmmoPress)this.tileEntity).getCraftingQueue().size() > 4) {
            this.craftButton.setErrored(true);
        } else if (this.hasSelectedCraftingPiece()) {
            this.craftButton.setErrored(false);
        }
    }

    @Override
    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        if (button == this.craftButton && !this.craftButton.isDisabled()) {
            if (this.hasSelectedCraftingPiece() && this.quantityBox.func_146179_b().length() != 0) {
                int quantity = Integer.parseInt(this.quantityBox.func_146179_b());
                MWC.CHANNEL.sendToServer((IMessage)new WorkbenchServerMessage(1, ((TileEntityAmmoPress)this.tileEntity).func_174877_v(), this.getSelectedCraftingPiece().getItemStack().func_77977_a(), this.getSelectedCraftingPiece().getCraftingGroup(), quantity));
            }
        } else if (button == this.bulletSelector) {
            ((GUIButtonCustom)button).toggleOn();
            this.magazineSelector.toggleOff();
            this.grenadeSelector.toggleOff();
            this.setCraftingMode(1);
            this.setSelectedCraftingPiece(null);
            this.fillFilteredList();
        } else if (button == this.magazineSelector) {
            ((GUIButtonCustom)button).toggleOn();
            this.bulletSelector.toggleOff();
            this.grenadeSelector.toggleOff();
            this.setCraftingMode(2);
            this.setSelectedCraftingPiece(null);
            this.fillFilteredList();
        } else if (button == this.grenadeSelector) {
            ((GUIButtonCustom)button).toggleOn();
            this.magazineSelector.toggleOff();
            this.bulletSelector.toggleOff();
            this.setCraftingMode(3);
            this.setSelectedCraftingPiece(null);
            this.fillFilteredList();
        }
    }

    @Override
    public void addCraftingInformationToTooltip(ArrayList<String> tooltip) {
        ItemStack stack = ((TileEntityAmmoPress)this.tileEntity).getLatestStackInQueue();
        tooltip.add(TextFormatting.GOLD + "Crafting: " + TextFormatting.WHITE + this.format(stack.func_77977_a()));
        int remainingTicks = ((TileEntityAmmoPress)this.tileEntity).craftingDuration - ((TileEntityAmmoPress)this.tileEntity).craftingTimer;
        tooltip.add(TextFormatting.GOLD + "Time remaining: " + TextFormatting.WHITE + String.format("%.2f", Float.valueOf((float)remainingTicks / 20.0f)) + "s");
        if (stack.func_77973_b() instanceof ItemBullet) {
            tooltip.add(TextFormatting.GOLD + "Quantity: " + TextFormatting.WHITE + stack.func_190916_E() + TextFormatting.GREEN + " -> " + stack.func_190916_E() * 6);
        } else {
            tooltip.add(TextFormatting.GOLD + "Quantity: " + TextFormatting.WHITE + stack.func_190916_E());
        }
    }

    @Override
    public void addCustomTooltipInformation(int mouseX, int mouseY, ArrayList<String> tooltip) {
        int id;
        super.addCustomTooltipInformation(mouseX, mouseY, tooltip);
        if (((TileEntityAmmoPress)this.tileEntity).hasStack() && mouseY >= this.field_147009_r && mouseY <= this.field_147009_r + 20 && (id = (mouseX - (this.field_147003_i + 200)) / 20) >= 0 && ((TileEntityAmmoPress)this.tileEntity).getCraftingQueue().size() - 1 >= id) {
            ItemStack stack = ((TileEntityAmmoPress)this.tileEntity).getCraftingQueue().get(id);
            tooltip.add(this.format(stack.func_77977_a()));
            if (stack.func_77973_b() instanceof ItemBullet) {
                tooltip.add(TextFormatting.GRAY + "Quantity: " + TextFormatting.GOLD + stack.func_190916_E() + TextFormatting.GREEN + " -> " + stack.func_190916_E() * 6);
            } else {
                tooltip.add(TextFormatting.GRAY + "Quantity: " + TextFormatting.GOLD + stack.func_190916_E());
            }
        }
        if (this.hasSelectedCraftingPiece() && this.getSelectedCraftingPiece().getItemStack().func_77973_b() instanceof ItemBullet && GUIRenderHelper.checkInBox(mouseX, mouseY, this.field_147003_i + 268, this.field_147009_r + 201, 20.0, 20.0)) {
            tooltip.add(String.format("Amount %d will make %d bullets", this.getCurrentAmountInQuantityBox(), this.getCurrentAmountInQuantityBox() * 6));
        }
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (this.getPage() == 2) {
            this.quantityBox.func_146194_f();
        }
        this.drawTooltips(mouseX, mouseY, partialTicks);
        if (this.getPage() == 2) {
            ItemStack stack;
            int i;
            LinkedList<ItemStack> queue = ((TileEntityAmmoPress)this.tileEntity).getCraftingQueue();
            GlStateManager.func_179147_l();
            for (i = 0; i < queue.size(); ++i) {
                ClientProxy.MC.func_110434_K().func_110577_a(AMMO_PRESS_TEX);
                if (GUIRenderHelper.checkInBox(mouseX, mouseY, this.field_147003_i + 200 + i * 20, this.field_147009_r, 20.0, 20.0)) {
                    GUIRenderHelper.drawTexturedRect(this.field_147003_i + 200 + i * 20, this.field_147009_r, 20.0f, 80.0f, 20.0, 20.0, 256.0, 256.0);
                    continue;
                }
                GUIRenderHelper.drawTexturedRect(this.field_147003_i + 200 + i * 20, this.field_147009_r, 0.0f, 80.0f, 20.0, 20.0, 256.0, 256.0);
            }
            for (i = 0; i < queue.size(); ++i) {
                stack = queue.get(i);
                ClientProxy.MC.func_175599_af().func_175042_a(stack, this.field_147003_i + 202 + i * 20, this.field_147009_r + 2);
            }
            for (i = 0; i < queue.size(); ++i) {
                stack = queue.get(i);
                GUIRenderHelper.drawScaledString("x" + stack.func_190916_E(), this.field_147003_i + 212 + i * 20, this.field_147009_r + 16, 0.7, 16642428);
            }
            if (this.hasSelectedCraftingPiece() && this.getSelectedCraftingPiece().getItemStack().func_77973_b() instanceof ItemBullet) {
                GUIRenderHelper.drawScaledString("x" + this.getCurrentAmountInQuantityBox() * 6, this.field_147003_i + 268, this.field_147009_r + 201, 0.7, 9954196);
            }
        }
    }

    private int getCurrentAmountInQuantityBox() {
        if (this.quantityBox.func_146179_b().length() == 0) {
            return 0;
        }
        return MathUtil.clampMaxFirst((int)Integer.parseInt(this.quantityBox.func_146179_b()), (int)1, (int)999);
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        int id;
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.quantityBox.func_146192_a(mouseX, mouseY, mouseButton);
        if (((TileEntityAmmoPress)this.tileEntity).hasStack() && mouseY >= this.field_147009_r && mouseY <= this.field_147009_r + 20 && (id = (mouseX - (this.field_147003_i + 200)) / 20) >= 0 && ((TileEntityAmmoPress)this.tileEntity).getCraftingQueue().size() - 1 >= id) {
            MWC.CHANNEL.sendToServer((IMessage)new WorkbenchServerMessage(5, ((TileEntityAmmoPress)this.tileEntity).func_174877_v(), ClientProxy.MC.field_71439_g.func_145782_y(), id));
        }
    }

    @Override
    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        boolean cancelationForQuantity = this.quantityBox.func_146179_b().length() == 0 && keyCode == 14;
        super.func_73869_a(typedChar, keyCode);
        if (Character.isDigit(typedChar) || keyCode == 14) {
            this.quantityBox.func_146201_a(typedChar, keyCode);
        }
        if (cancelationForQuantity && this.quantityBox.func_146206_l()) {
            return;
        }
        if (keyCode == 14) {
            this.fillFilteredList();
        }
    }
}

