/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.crafting;

import com.paneedah.mwc.utils.ModReference;
import com.paneedah.weaponlib.crafting.OptionsMetadata;
import com.paneedah.weaponlib.crafting.RecipeGenerator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class RecipeManager {
    private RecipeGenerator recipeGenerator = new RecipeGenerator();
    private Map<Item, List<Object>> recipes = new HashMap<Item, List<Object>>();

    public List<Object> createShapedRecipe(Item item, String name, OptionsMetadata optionsMetadata) {
        List<Object> recipe = this.recipeGenerator.createShapedRecipe(name, optionsMetadata);
        if (this.recipes.put(item, recipe) != null) {
            ModReference.LOG.warn("Duplicate recipe registered for item {}", (Object)item);
        }
        return recipe;
    }

    public List<Object> registerShapedRecipe(Item item, Object ... recipe) {
        return this.registerShapedRecipe(new ItemStack(item), recipe);
    }

    public List<Object> registerShapedRecipe(ItemStack itemStack, Object ... recipe) {
        ArrayList<Object> recipeAslist = new ArrayList<Object>(recipe.length);
        boolean hasOres = false;
        for (Object option : recipe) {
            if (option instanceof String) {
                hasOres = true;
            }
            recipeAslist.add(option);
        }
        if (hasOres) {
            ForgeRegistries.RECIPES.register(new ShapedOreRecipe(null, itemStack, recipeAslist.toArray()).setMirrored(false).setRegistryName("mwc", itemStack.func_77973_b().func_77658_a() + "_recipe"));
        } else {
            ForgeRegistries.RECIPES.register(new ShapedOreRecipe(null, itemStack, recipeAslist.toArray()).setMirrored(false).setRegistryName("mwc", itemStack.func_77973_b().func_77658_a() + "_recipe"));
        }
        if (this.recipes.put(itemStack.func_77973_b(), recipeAslist) != null) {
            ModReference.LOG.warn("Duplicate recipe registered for item {}", (Object)itemStack.func_77973_b());
        }
        return recipeAslist;
    }

    public List<Object> getRecipe(Item item) {
        return this.recipes.get(item);
    }
}

