/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.crafting;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.paneedah.mwc.proxies.ClientProxy;
import com.paneedah.mwc.utils.ModReference;
import com.paneedah.weaponlib.JSONDatabaseManager;
import com.paneedah.weaponlib.crafting.CraftingEntry;
import com.paneedah.weaponlib.crafting.CraftingGroup;
import com.paneedah.weaponlib.crafting.CraftingRegistry;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.IOUtils;

public class CraftingFileManager
extends JSONDatabaseManager {
    private static final CraftingFileManager INSTANCE = new CraftingFileManager();
    private static final File DIRECTORY = new File(Loader.instance().getConfigDir() + "/mwc/crafting");
    private static final File CACHE_DIR = new File(DIRECTORY, "cache/");
    private static final File MAIN_FILE = new File(DIRECTORY, "craftingmappings.json");
    private static final String DEFAULT_CRAFTING_MAPPINGS = "craftingmappings.json";
    private static final String CACHE_EXTENSION = ".cache";
    private byte[] currentFileHash;
    private byte[] defaultFileHash;
    private static final String NAME_KEY = "entryName";
    private static final String CRAFTING_GROUP_KEY = "craftingGroup";
    private static final String RECIPE_ARRAY_KEY = "recipe";
    private static final String ORE_DICTIONARY_BOOLEAN_KEY = "isOreDictionary";
    private static final String COUNT_KEY = "count";
    private static final String ENTRY_ITEM_NAME_KEY = "entryName";
    private static final String ORE_DICTIONARY_DEFAULT_ITEM = "defaultItem";
    private int loadingStatus = -1;

    public static CraftingFileManager getInstance() {
        return INSTANCE;
    }

    public byte[] getCurrentFileHash() {
        return this.currentFileHash;
    }

    public int getLoadingStatus() {
        return this.loadingStatus;
    }

    @Override
    public JsonObject toJSON() {
        JsonObject mainFileJSON = new JsonObject();
        JsonArray mainArray = new JsonArray();
        mainFileJSON.add("recipes", (JsonElement)mainArray);
        JsonObject obj = new JsonObject();
        mainArray.add((JsonElement)obj);
        obj.addProperty("entryName", "mwc:bullet50ae");
        obj.addProperty(CRAFTING_GROUP_KEY, CraftingGroup.BULLET.toString());
        CraftingEntry[] recipe = new CraftingEntry[]{new CraftingEntry(Blocks.field_180405_aT, 4)};
        JsonArray recipeArray = new JsonArray();
        obj.add(RECIPE_ARRAY_KEY, (JsonElement)recipeArray);
        for (CraftingEntry entry : recipe) {
            JsonObject jsonEntry = new JsonObject();
            String itemName = entry.getItem().getRegistryName().toString();
            jsonEntry.addProperty("entryName", !entry.isOreDictionary() ? itemName : entry.getOreDictionaryEntry());
            jsonEntry.addProperty(ORE_DICTIONARY_BOOLEAN_KEY, Boolean.valueOf(false));
            jsonEntry.addProperty(COUNT_KEY, (Number)entry.getCount());
            if (entry.isOreDictionary()) {
                jsonEntry.addProperty(ORE_DICTIONARY_DEFAULT_ITEM, itemName);
            }
            recipeArray.add((JsonElement)jsonEntry);
        }
        return mainFileJSON;
    }

    public ByteArrayOutputStream getCurrentFileBAOS() {
        if (this.loadingStatus == -1) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            if (this.loadingStatus == 2) {
                FileInputStream fis = new FileInputStream(MAIN_FILE);
                int avaliable = fis.available();
                for (int i = 0; i < avaliable; ++i) {
                    baos.write(fis.read());
                }
                fis.close();
            } else if (this.loadingStatus == 1) {
                InputStream is = this.getClass().getClassLoader().getResourceAsStream(DEFAULT_CRAFTING_MAPPINGS);
                for (int i = 0; i < is.available(); ++i) {
                    baos.write(is.read());
                }
                is.close();
            }
            return baos;
        }
        catch (IOException e) {
            e.printStackTrace();
            return baos;
        }
    }

    public byte[] getDefaultFileHash() {
        if (this.defaultFileHash != null) {
            return this.defaultFileHash;
        }
        this.defaultFileHash = CraftingFileManager.getDigest(this.getDefaultFileStream());
        return this.defaultFileHash;
    }

    @Override
    public void fromJSON(JsonObject object) {
        InputStreamReader reader = new InputStreamReader(Objects.requireNonNull(this.getClass().getClassLoader().getResourceAsStream(DEFAULT_CRAFTING_MAPPINGS)));
        JsonObject defaultObject = (JsonObject)GSON_MANAGER.fromJson((Reader)reader, JsonObject.class);
        JsonArray defaultArray = defaultObject.get("recipes").getAsJsonArray();
        JsonArray customArray = object.get("recipes").getAsJsonArray();
        for (int i = 0; i < defaultArray.size(); ++i) {
            JsonArray subRecipeArray;
            CraftingGroup recipeCraftingGroup;
            String recipeName;
            JsonObject defaultRecipe = (JsonObject)defaultArray.get(i);
            JsonObject customRecipe = null;
            for (int j = 0; j < customArray.size(); ++j) {
                JsonObject customRecipeTemp = (JsonObject)customArray.get(j);
                if (!customRecipeTemp.get("entryName").getAsString().equalsIgnoreCase(defaultRecipe.get("entryName").getAsString())) continue;
                customRecipe = customRecipeTemp;
                break;
            }
            if (customRecipe == null) {
                recipeName = defaultRecipe.get("entryName").getAsString();
                recipeCraftingGroup = CraftingGroup.valueOf(defaultRecipe.get(CRAFTING_GROUP_KEY).getAsString());
                subRecipeArray = defaultRecipe.get(RECIPE_ARRAY_KEY).getAsJsonArray();
            } else {
                recipeName = customRecipe.get("entryName").getAsString();
                recipeCraftingGroup = CraftingGroup.valueOf(customRecipe.get(CRAFTING_GROUP_KEY).getAsString());
                subRecipeArray = customRecipe.get(RECIPE_ARRAY_KEY).getAsJsonArray();
            }
            boolean cancellationFlag = false;
            CraftingEntry[] entryArray = new CraftingEntry[subRecipeArray.size()];
            for (int r = 0; r < subRecipeArray.size(); ++r) {
                JsonObject subRecipe = subRecipeArray.get(r).getAsJsonObject();
                boolean isOreDictionary = false;
                if (!subRecipe.has("entryName") || !subRecipe.has(COUNT_KEY)) {
                    ModReference.LOG.debug("Sub-recipe no. {} for recipe {} missing essential keys.", (Object)r, (Object)recipeName);
                    cancellationFlag = true;
                    break;
                }
                if (subRecipe.has(ORE_DICTIONARY_BOOLEAN_KEY) && (isOreDictionary = subRecipe.get(ORE_DICTIONARY_BOOLEAN_KEY).getAsBoolean()) && !subRecipe.has(ORE_DICTIONARY_DEFAULT_ITEM)) {
                    ModReference.LOG.debug("Sub-recipe no. {} for recipe {} states it is OreDictionary, but does not provide a default item.", (Object)r, (Object)recipeName);
                    cancellationFlag = true;
                    break;
                }
                if (isOreDictionary) {
                    Item defaultItem = Item.func_111206_d((String)subRecipe.get(ORE_DICTIONARY_DEFAULT_ITEM).getAsString());
                    entryArray[r] = new CraftingEntry(defaultItem, subRecipe.get("entryName").getAsString(), subRecipe.get(COUNT_KEY).getAsInt());
                    continue;
                }
                entryArray[r] = new CraftingEntry(Item.func_111206_d((String)subRecipe.get("entryName").getAsString()), subRecipe.get(COUNT_KEY).getAsInt());
            }
            if (cancellationFlag) continue;
            Item item = Item.func_111206_d((String)recipeName);
            if (item == null) {
                ModReference.LOG.error("Could not find item with name: " + recipeName);
                continue;
            }
            CraftingRegistry.registerRecipe(item, recipeCraftingGroup, entryArray);
        }
    }

    @Override
    public File getDirectory() {
        DIRECTORY.mkdirs();
        return DIRECTORY;
    }

    private void initializeJSON(InputStream is) throws JsonIOException, JsonSyntaxException {
        byte[] array;
        try {
            array = IOUtils.toByteArray((InputStream)is);
        }
        catch (IOException e) {
            throw new JsonIOException("Failed to copy array into bytes!");
        }
        if (array == null) {
            throw new JsonIOException("Failed to copy array into bytes!");
        }
        ByteArrayInputStream hashStream = new ByteArrayInputStream(array);
        ByteArrayInputStream readStream = new ByteArrayInputStream(array);
        InputStreamReader reader = new InputStreamReader(readStream);
        JsonObject extractedObject = (JsonObject)GSON_MANAGER.fromJson((Reader)reader, JsonObject.class);
        this.fromJSON(extractedObject);
        try {
            readStream.close();
            reader.close();
        }
        catch (IOException e) {
            ModReference.LOG.catching((Throwable)e);
            ModReference.LOG.error("Failed to close reader/reading stream for file!");
        }
        this.currentFileHash = CraftingFileManager.getDigest(hashStream);
    }

    public InputStream getDefaultFileStream() {
        return this.getClass().getClassLoader().getResourceAsStream(DEFAULT_CRAFTING_MAPPINGS);
    }

    @Override
    public void loadDirectory() {
        InputStream is;
        this.getDirectory();
        boolean inCustomMode = false;
        if (!MAIN_FILE.exists()) {
            ModReference.LOG.debug("No custom mappings found, switching to default mode.");
            is = this.getClass().getClassLoader().getResourceAsStream(DEFAULT_CRAFTING_MAPPINGS);
        } else {
            ModReference.LOG.debug("Detected custom mappings, using those!");
            try {
                is = new FileInputStream(MAIN_FILE);
                inCustomMode = true;
            }
            catch (FileNotFoundException e) {
                ModReference.LOG.catching((Throwable)e);
                ModReference.LOG.error("Could not find the custom mappings file! Switching to default mappings!");
                is = this.getClass().getClassLoader().getResourceAsStream(DEFAULT_CRAFTING_MAPPINGS);
            }
        }
        try {
            this.initializeJSON(is);
            this.loadingStatus = inCustomMode ? 2 : 1;
        }
        catch (JsonIOException | JsonSyntaxException e) {
            if (inCustomMode) {
                is = this.getClass().getClassLoader().getResourceAsStream(DEFAULT_CRAFTING_MAPPINGS);
                try {
                    this.initializeJSON(is);
                    ModReference.LOG.debug("Could not initialize custom JSON, succesfully loaded default mappings though!");
                    this.loadingStatus = 1;
                }
                catch (Exception e1) {
                    ModReference.LOG.error("Could not initialize custom JSON, so attempted to load default, but it failed!");
                }
            }
            ModReference.LOG.error("Attempted to load default mappings, but it failed!");
        }
    }

    public int loadJSONStore(InputStream io) {
        try {
            this.initializeJSON(io);
        }
        catch (JsonIOException e1) {
            ModReference.LOG.error("GSON had troubles reading from the Input Stream ({})", (Object)io.toString());
            ModReference.LOG.error("Check your directory permissions and ensure the system can read the file.");
            ModReference.LOG.catching((Throwable)e1);
            return -1;
        }
        catch (JsonSyntaxException e2) {
            ModReference.LOG.error("GSON had troubles parsing the file syntax for InputStream ({}).", (Object)io.toString());
            ModReference.LOG.catching((Throwable)e2);
            return -2;
        }
        return 1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SideOnly(value=Side.CLIENT)
    public boolean checkFileHashAndLoad(byte[] hash) {
        if (Arrays.equals(hash, this.getDefaultFileHash())) {
            if (this.loadJSONStore(this.getDefaultFileStream()) == 1) {
                return true;
            }
            ModReference.LOG.error("Could not load default file stream. This means we could not access a file within your jar, check if your version was sourced from CurseForge!");
            return false;
        }
        if (!CACHE_DIR.exists()) {
            return false;
        }
        File[] fileArray = CACHE_DIR.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            byte[] checkHash = CraftingFileManager.getDigest(f);
            try (FileInputStream fis = new FileInputStream(f);){
                if (Arrays.equals(hash, checkHash)) {
                    int status = this.loadJSONStore(fis);
                    boolean bl = status == 1;
                    return bl;
                }
            }
            catch (FileNotFoundException e) {
                ModReference.LOG.error("Was testing hashes against cache directory, could not find {}!", (Object)f.toString());
                ModReference.LOG.error("Does your system have permissions set to read that directory?");
            }
            catch (IOException e) {
                ModReference.LOG.error("Was unable to reset InputStream for {}", (Object)f.toString());
                ModReference.LOG.catching((Throwable)e);
            }
            ++n2;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void saveCacheAndLoad(ByteArrayOutputStream baos) {
        if (ClientProxy.MC.func_71387_A()) {
            return;
        }
        String serverIP = ClientProxy.MC.func_147104_D().field_78845_b;
        CACHE_DIR.mkdirs();
        File cache = new File(CACHE_DIR, serverIP + CACHE_EXTENSION);
        if (!cache.exists()) {
            try {
                cache.createNewFile();
            }
            catch (IOException e) {
                ModReference.LOG.error("Failed to create a new cache file {}!", (Object)cache.getName());
                ModReference.LOG.error("Check system writing priveleges for {} path.", (Object)cache.getPath());
                ModReference.LOG.catching((Throwable)e);
                return;
            }
        }
        try (FileOutputStream fos = new FileOutputStream(cache);){
            fos.write(baos.toByteArray());
            baos.close();
        }
        catch (FileNotFoundException e) {
            ModReference.LOG.error("Failed to find file {}, could not create file output stream to write to cache.", (Object)cache);
            ModReference.LOG.error("Check permissions for directory path {}", (Object)cache.getPath());
            ModReference.LOG.catching((Throwable)e);
        }
        catch (IOException e) {
            ModReference.LOG.error("Failed to write to the file output stream for file {}", (Object)cache);
            ModReference.LOG.catching((Throwable)e);
        }
    }
}

