/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.animation.jim;

import com.google.gson.JsonObject;
import com.paneedah.weaponlib.animation.jim.AnimationData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class SingleAnimation {
    private String animationName;
    private HashMap<String, AnimationData> dataMap = new HashMap();
    private int timestampCount = 0;
    private ArrayList<Float> timestamps;
    private HashMap<Float, String> sounds = new HashMap();
    private float duration;

    public SingleAnimation(String name) {
        this.animationName = name;
    }

    public float getDuration() {
        return this.duration;
    }

    public void setDuration(float duration) {
        this.duration = duration;
    }

    public void registerSound(float time, String name) {
        this.sounds.put(Float.valueOf(time), name);
    }

    public HashMap<Float, String> getSoundMap() {
        return this.sounds;
    }

    public ArrayList<Float> getTimestamps() {
        return this.timestamps;
    }

    public boolean hasBone(String name) {
        return this.dataMap.containsKey(name);
    }

    public void addBoneData(String name, JsonObject obj) {
        this.dataMap.put(name, new AnimationData(obj));
    }

    public void bake() {
        this.timestamps = new ArrayList();
        for (Map.Entry<String, AnimationData> i : this.dataMap.entrySet()) {
            i.getValue().setAppointedDuration(this.getDuration());
            ArrayList<Float> arrayList = i.getValue().getTimestamps();
            for (float f : arrayList) {
                if (this.timestamps.contains(Float.valueOf(f))) continue;
                this.timestamps.add(Float.valueOf(f));
            }
        }
        Collections.sort(this.timestamps);
        this.timestampCount = this.timestamps.size();
        for (Map.Entry<String, AnimationData> i : this.dataMap.entrySet()) {
            for (float f : this.timestamps) {
                if (i.getValue().getTimestamps().contains(Float.valueOf(f))) continue;
                i.getValue().bakeKeyframes(f);
            }
        }
        for (Map.Entry<String, AnimationData> i : this.dataMap.entrySet()) {
            AnimationData animationData = i.getValue();
            for (int t = 0; t < this.getTimestamps().size(); ++t) {
                if (t == 0) {
                    animationData.bbTransition.get(this.getTimestamps().get(t)).setTimestamp(1.0f);
                    continue;
                }
                float trueDelta = 833.0f * (this.getTimestamps().get(t).floatValue() - this.getTimestamps().get(t - 1).floatValue());
                animationData.bbTransition.get(this.getTimestamps().get(t)).setTimestamp(trueDelta);
            }
        }
        ArrayList<Float> overflowList = new ArrayList<Float>();
        for (Map.Entry<Float, String> entry : this.sounds.entrySet()) {
            overflowList.add(entry.getKey());
        }
        if (this.dataMap.containsKey("main")) {
            this.dataMap.get("main").setSounds(this.sounds, overflowList);
        }
        if (!overflowList.isEmpty()) {
            for (Map.Entry<Object, Object> entry : this.dataMap.entrySet()) {
                if (((String)entry.getKey()).equals("main")) continue;
                if (overflowList.isEmpty()) break;
                ((AnimationData)entry.getValue()).setSounds(this.sounds, overflowList);
            }
        }
    }

    public AnimationData getBone(String bone) {
        if (!this.dataMap.containsKey(bone)) {
            return new AnimationData(this.getTimestamps());
        }
        return this.dataMap.get(bone);
    }

    public String getAnimationName() {
        return this.animationName;
    }

    public void setAnimationName(String animationName) {
        this.animationName = animationName;
    }

    public HashMap<String, AnimationData> getDataMap() {
        return this.dataMap;
    }

    public void setDataMap(HashMap<String, AnimationData> dataMap) {
        this.dataMap = dataMap;
    }
}

