/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.animation.jim;

import com.paneedah.mwc.proxies.ClientProxy;
import com.paneedah.weaponlib.vehicle.jimphysics.InterpolationKit;
import java.util.LinkedList;
import net.minecraft.util.math.Vec3d;
import org.lwjgl.opengl.GL11;

public class BasicStateAnimator {
    public double time = 0.0;
    public LinkedList<Transition> callList = new LinkedList();
    public Transition goingTransition;
    public Transition currentTransition;
    public Vec3d currentPosition = Vec3d.field_186680_a;
    public Vec3d previousPosition = Vec3d.field_186680_a;
    public Vec3d currentRot = Vec3d.field_186680_a;
    public Vec3d prevRot = Vec3d.field_186680_a;
    public static final Transition ZERO_TRANSITION = new Transition(Vec3d.field_186680_a, Vec3d.field_186680_a, 0.0);
    public boolean isInAction = false;

    public void BasicStateAnimator() {
    }

    public Vec3d getInterpolatedRotation() {
        double mu = ClientProxy.MC.func_184121_ak();
        return InterpolationKit.interpolateVector(this.prevRot, this.currentRot, mu);
    }

    public Vec3d getInterpolatedPosition() {
        double mu = ClientProxy.MC.func_184121_ak();
        return InterpolationKit.interpolateVector(this.previousPosition, this.currentPosition, mu);
    }

    public void applyGLTransforms() {
        Vec3d iP = this.getInterpolatedPosition();
        Vec3d iR = this.getInterpolatedRotation();
        GL11.glTranslated((double)iP.field_72450_a, (double)iP.field_72448_b, (double)iP.field_72449_c);
        GL11.glRotated((double)iR.field_72450_a, (double)0.0, (double)0.0, (double)1.0);
        GL11.glRotated((double)iR.field_72448_b, (double)0.0, (double)1.0, (double)0.0);
        GL11.glRotated((double)iR.field_72449_c, (double)1.0, (double)0.0, (double)0.0);
    }

    public void addPause(double time) {
        Transition pauseTransition = this.callList.peekLast();
        pauseTransition.time = time;
        this.callList.offer(pauseTransition);
    }

    public void transition(Vec3d pos, Vec3d rot, double time) {
        this.callList.offer(new Transition(pos, rot, time));
    }

    public void tick() {
        if (this.callList.size() > 50) {
            this.callList.clear();
        }
        if (this.goingTransition != null && this.currentTransition == null) {
            this.currentTransition = ZERO_TRANSITION;
        }
        if (this.goingTransition != null) {
            this.time += 1.0;
            this.prevRot = this.currentRot;
            this.previousPosition = this.currentPosition;
            if (this.time > this.goingTransition.time) {
                this.currentTransition = this.goingTransition;
                this.time = 0.0;
                this.goingTransition = this.callList.isEmpty() ? null : this.callList.poll();
            } else {
                double mu = this.time / this.goingTransition.time;
                this.currentPosition = InterpolationKit.interpolateVector(this.currentTransition.pos, this.goingTransition.pos, mu);
                this.currentRot = InterpolationKit.interpolateVector(this.currentTransition.rot, this.goingTransition.rot, mu);
            }
        } else if (!this.callList.isEmpty()) {
            this.goingTransition = this.callList.poll();
        }
    }

    public static class Transition
    implements ITransitionable {
        public Vec3d pos;
        public Vec3d rot;
        public double time;

        public Transition(Vec3d pos, Vec3d rot, double time) {
            this.pos = pos;
            this.rot = rot;
            this.time = time;
        }
    }

    public static interface ITransitionable {
    }
}

