/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.animation.jim;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.paneedah.mwc.proxies.ClientProxy;
import com.paneedah.mwc.utils.ModReference;
import com.paneedah.weaponlib.animation.Transform;
import com.paneedah.weaponlib.animation.jim.AnimationData;
import com.paneedah.weaponlib.animation.jim.AnimationSet;
import com.paneedah.weaponlib.animation.jim.SingleAnimation;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.ResourceLocation;

public class BBLoader {
    public static String directory = "mwc:animations/";
    public static Gson gson = new GsonBuilder().create();
    public static String version = "1.8.0";
    public static double HANDDIVISOR = 12.6;
    public static double GENDIVISOR = 5.0;
    public static final String KEY_MAIN = "main";
    public static final String KEY_EJECT_SPENT_ROUND = "ejectspentround";
    public static final String KEY_EJECT_SPENT_ROUND_AIMED = "ejectspentroundaimed";
    public static final String KEY_COMPOUND_RELOAD_EMPTY = "reloadempty";
    public static final String KEY_COMPOUND_RELOAD = "reload";
    public static final String KEY_LOAD = "load";
    public static final String KEY_UNLOAD = "unload";
    public static final String KEY_TACTICAL_RELOAD = "reloadtactical";
    public static final String KEY_DRAW = "draw";
    public static final String KEY_INSPECT = "inspect";
    public static final String KEY_UNLOAD_EMPTY = "unloadempty";
    public static final String KEY_LOAD_EMPTY = "loadempty";
    public static final String KEY_MAGAZINE = "magazine";
    public static final String KEY_MAGIC_MAGAZINE = "magazine_extra";
    public static final String KEY_ANIMATION_LENGTH = "animation_length";
    public static final String KEY_VERSION = "format_version";
    public static final String KEY_ACTION = "action";
    public static final String KEY_BOLT_ACTION = "boltaction";
    public static Transform test = new Transform().withPosition(-2.0, 3.0, -2.0).withRotation(0.0, 0.0, 0.0).withScale(3.0, 3.0, 3.0).withRotationPoint(-0.1, 1.0, 0.0);
    private static String animationSuffix = ".animation.json";
    private static HashMap<String, AnimationSet> actualAnimations = new HashMap();

    public static JsonObject extractPath(JsonObject obj, String ... path) {
        JsonObject current = obj;
        for (String s : path) {
            current = current.get(s).getAsJsonObject();
        }
        return current;
    }

    public static int getTotalAnimations() {
        return actualAnimations.size();
    }

    public static AnimationSet getAnimationSet(String animation) {
        if (!actualAnimations.containsKey(animation)) {
            AnimationSet set = BBLoader.loadAnimationFile(animation + animationSuffix);
            if (set == null) {
                ModReference.LOG.error("Could not load animation set for animation name {}", (Object)animation);
                return null;
            }
            actualAnimations.put(animation, set);
            return set;
        }
        return actualAnimations.get(animation);
    }

    public static AnimationData getAnimation(String animation, String subName, String bone) {
        if (actualAnimations.containsKey(animation) && actualAnimations.get(animation) != null) {
            AnimationSet set = actualAnimations.get(animation);
            SingleAnimation single = set.getSingleAnimation(subName);
            if (single == null) {
                return null;
            }
            return single.getBone(bone);
        }
        AnimationSet set = BBLoader.loadAnimationFile(animation + animationSuffix);
        if (set == null) {
            ModReference.LOG.error("Could not load animation set for animation name {}", (Object)animation);
            return null;
        }
        actualAnimations.put(animation, set);
        return BBLoader.getAnimation(animation, subName, bone);
    }

    public static AnimationSet loadAnimationFile(String fileName) {
        AnimationSet animationSet = new AnimationSet();
        BufferedReader br = null;
        try {
            ResourceLocation loc = new ResourceLocation(directory + fileName);
            br = new BufferedReader(new InputStreamReader(ClientProxy.MC.func_110442_L().func_110536_a(loc).func_110527_b()));
        }
        catch (Exception e) {
            ModReference.LOG.error("Failed to create reader for file: {}", (Object)fileName);
            return null;
        }
        JsonObject masterJSON = (JsonObject)gson.fromJson((Reader)br, JsonObject.class);
        if (!masterJSON.has(KEY_VERSION)) {
            ModReference.LOG.error("Could not locate \"format_version\" key, cannot read file {} ", (Object)fileName);
            return null;
        }
        if (!masterJSON.get(KEY_VERSION).getAsString().equals(version)) {
            ModReference.LOG.error("Warning, this file is running version {}, and this version of VMW is looking for {}", (Object)masterJSON.get(KEY_VERSION).getAsString(), (Object)version);
        }
        JsonObject animationsJSON = masterJSON.get("animations").getAsJsonObject();
        for (Map.Entry entry : animationsJSON.entrySet()) {
            String animationHeader = ((String)entry.getKey()).split("\\.")[2];
            SingleAnimation anim = new SingleAnimation(animationHeader);
            JsonObject singleAnimJSON = animationsJSON.get((String)entry.getKey()).getAsJsonObject();
            float appointedDuration = singleAnimJSON.get(KEY_ANIMATION_LENGTH).getAsFloat();
            if (singleAnimJSON.has("sound_effects")) {
                JsonObject soundFX = singleAnimJSON.get("sound_effects").getAsJsonObject();
                for (Map.Entry effect : soundFX.entrySet()) {
                    anim.registerSound(Float.parseFloat((String)effect.getKey()), ((JsonElement)effect.getValue()).getAsJsonObject().get("effect").getAsString());
                }
            }
            JsonObject animJSON = singleAnimJSON.get("bones").getAsJsonObject();
            for (Map.Entry subEntry : animJSON.entrySet()) {
                JsonObject boneJSON = animJSON.get((String)subEntry.getKey()).getAsJsonObject();
                anim.addBoneData((String)subEntry.getKey(), boneJSON);
            }
            anim.setDuration(appointedDuration);
            anim.bake();
            animationSet.addSingleAnimation(anim);
        }
        return animationSet;
    }

    public static AnimationData loadAnimationData(String fileName, String animationName, String realBone) {
        ResourceLocation loc = new ResourceLocation(directory + fileName);
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader(ClientProxy.MC.func_110442_L().func_110536_a(loc).func_110527_b()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        JsonObject obj = (JsonObject)gson.fromJson(br, JsonObject.class);
        JsonObject anims = obj.get("animations").getAsJsonObject();
        String boneName = "bones";
        AnimationData dat = new AnimationData(BBLoader.extractPath(anims, animationName, "bones", realBone));
        return dat;
    }

    public static String getDirectory() {
        return directory;
    }

    public static void setDirectory(String directory) {
        BBLoader.directory = directory;
    }

    public static Gson getGson() {
        return gson;
    }

    public static void setGson(Gson gson) {
        BBLoader.gson = gson;
    }

    public static String getVersion() {
        return version;
    }

    public static void setVersion(String version) {
        BBLoader.version = version;
    }

    public static String getAnimationSuffix() {
        return animationSuffix;
    }

    public static void setAnimationSuffix(String animationSuffix) {
        BBLoader.animationSuffix = animationSuffix;
    }

    public static HashMap<String, AnimationSet> getActualAnimations() {
        return actualAnimations;
    }

    public static void setActualAnimations(HashMap<String, AnimationSet> actualAnimations) {
        BBLoader.actualAnimations = actualAnimations;
    }
}

