/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib.animation;

import com.paneedah.mwc.asm.Interceptors;
import com.paneedah.mwc.proxies.ClientProxy;
import com.paneedah.weaponlib.ModContext;
import com.paneedah.weaponlib.Pair;
import com.paneedah.weaponlib.PlayerWeaponInstance;
import com.paneedah.weaponlib.compatibility.RecoilParam;
import com.paneedah.weaponlib.numerical.LerpedValue;
import com.paneedah.weaponlib.numerical.RandomVector;
import com.paneedah.weaponlib.numerical.SpringValue;
import net.minecraft.client.entity.EntityPlayerSP;

public class ClientValueRepo {
    private static final double DELTA_T = 0.05;
    private static final double TICKER_INCREMENT = 0.01;
    private static final double RUNNING_SPEED_VALUE = 0.5;
    private static final double RUNNING_DAMPEN_VALUE = 0.6;
    private static final double FORWARD_MOVEMENT_DAMPEN_VALUE = 0.7;
    private static final double STRAFE_MOVEMENT_DAMPEN_VALUE = 0.7;
    private static final double SCOPE_INTERIA_DAMPENING = (double)0.2f;
    private static final double JUMP_VELOCITY_MULTIPLIER = 10.0;
    private static final double FORWARD_MOVEMENT_DIVISOR = 0.25;
    private static final double STRAFE_MOVEMENT_DIVISOR = 0.5;
    private static final double RANDOM_VECTOR_DAMPENING = 0.6;
    private static final double RANDOM_VECTOR_SPEED = 0.2;
    private static final float INITIAL_GUN_POWER_CUTOFF = 10.0f;
    private static final float INITIAL_GUN_POWER_MULTIPLIER = 2.0f;
    private static final float GUN_POWER_PAST_STOCK_DIVISOR = 0.4f;
    private static final double WEAPON_RECOVERY_VELOCITY_POWER = 0.25;
    public static final LerpedValue TICKER = new LerpedValue();
    public static LerpedValue strafe = new LerpedValue();
    public static LerpedValue forward = new LerpedValue();
    public static LerpedValue running = new LerpedValue();
    public static LerpedValue gunPow = new LerpedValue();
    public static LerpedValue scopeX = new LerpedValue();
    public static LerpedValue scopeY = new LerpedValue();
    public static LerpedValue slidePumpValue = new LerpedValue();
    public static float scopeXScreen;
    public static float scopeYScreen;
    public static SpringValue xInertia;
    public static SpringValue yInertia;
    public static SpringValue jumpingSpring;
    public static SpringValue weaponRecovery;
    public static RandomVector stressVec;
    public static RandomVector recoilRotationVector;
    public static boolean shouldContinueRunning;
    public static double recoilWoundY;

    public static void fireWeapon(PlayerWeaponInstance pwi) {
        RecoilParam params = pwi.getRecoilParameters();
        Pair<Double, Double> screenShakeParam = pwi.getScreenShakeParameters();
        double power = params.getWeaponPower();
        if (ClientValueRepo.gunPow.currentValue < 10.0) {
            Interceptors.nsm.impulse(screenShakeParam.getFirst());
            power *= 2.0;
        } else if (ClientValueRepo.gunPow.currentValue > params.getStockLength()) {
            power *= (double)0.4f;
            Interceptors.nsm.impulse(screenShakeParam.getFirst() * (double)0.4f);
        } else {
            Interceptors.nsm.impulse(screenShakeParam.getFirst());
        }
        ClientValueRepo.weaponRecovery.velocity += power * 0.25;
        ClientValueRepo.gunPow.currentValue += power;
        stressVec.callRandom(pwi.isAimed() ? 0.05 : 0.2);
        recoilRotationVector.callRandom(15.0);
        ClientValueRepo.slidePumpValue.currentValue += 1.0;
    }

    public static void update(ModContext context) {
        running.updatePrevious();
        strafe.updatePrevious();
        scopeX.updatePrevious();
        scopeY.updatePrevious();
        gunPow.updatePrevious();
        forward.updatePrevious();
        TICKER.updatePrevious();
        slidePumpValue.updatePrevious();
        slidePumpValue.dampen(1.0E-4);
        EntityPlayerSP player = ClientProxy.MC.field_71439_g;
        PlayerWeaponInstance pwi = context.getMainHeldWeapon();
        ClientValueRepo.TICKER.currentValue += 0.01;
        if (!player.field_71075_bZ.field_75100_b && player.field_70122_E) {
            if (!ClientProxy.MC.field_71439_g.field_70122_E) {
                ClientValueRepo.jumpingSpring.velocity += ClientProxy.MC.field_71439_g.field_70181_x * 10.0;
            }
            if (player.field_191988_bg < 0.0f) {
                strafe.add((double)player.field_191988_bg * 0.25);
            } else if (!player.func_184613_cA() && !player.field_71075_bZ.field_75100_b) {
                forward.add((double)player.field_191988_bg * 0.25);
            }
            strafe.add((double)player.field_70702_br * 0.5);
        }
        ClientValueRepo.xInertia.velocity += ClientValueRepo.strafe.currentValue;
        if (player.func_70051_ag()) {
            running.add(0.5);
        }
        strafe.dampen(0.7);
        forward.dampen(0.7);
        running.dampen(0.6);
        if (pwi != null) {
            RecoilParam recoilParameters = pwi.getRecoilParameters();
            if (ClientValueRepo.gunPow.currentValue > recoilParameters.getStockLength()) {
                gunPow.dampen(recoilParameters.getPowerRecoveryStockRate());
            } else {
                gunPow.dampen(recoilParameters.getPowerRecoveryNormalRate());
            }
        }
        recoilRotationVector.update(0.2, 0.6);
        stressVec.update(0.2, 0.6);
        if (pwi != null) {
            if (pwi.isAimed()) {
                scopeXScreen = 0.5f;
                scopeYScreen = 0.5f;
                ClientValueRepo.scopeX.currentValue *= (double)0.2f;
                ClientValueRepo.scopeY.currentValue *= (double)0.2f;
            } else {
                scopeXScreen = 0.15f;
                scopeYScreen = 0.35f;
                if (scopeX.getValue() > -20.0) {
                    scopeX.add(-0.5);
                }
                if (scopeY.getValue() < 20.0) {
                    scopeY.add(0.5);
                }
            }
        }
        weaponRecovery.update(0.05);
        jumpingSpring.update(0.05);
        xInertia.update(0.05);
        yInertia.update(0.05);
    }

    static {
        xInertia = new SpringValue(4000.0, 20.0, 350.0);
        yInertia = new SpringValue(4000.0, 20.0, 350.0);
        jumpingSpring = new SpringValue(2000.0, 40.0, 400.0);
        weaponRecovery = new SpringValue(50.0, 1.0, 3.0);
        stressVec = new RandomVector();
        recoilRotationVector = new RandomVector();
        shouldContinueRunning = false;
    }
}

