/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib;

import com.paneedah.mwc.network.TypeRegistry;
import com.paneedah.weaponlib.state.ManagedState;
import io.netty.buffer.ByteBuf;

public enum WeaponState implements ManagedState<WeaponState>
{
    DRAWING,
    READY(false),
    COMPOUND_REQUESTED,
    COMPOUND_EMTPY_REQUESTED,
    TACTICAL_RELOAD,
    COMPOUND_RELOAD,
    COMPOUND_RELOAD_EMPTY,
    COMPOUND_RELOAD_UNLOAD(null, COMPOUND_REQUESTED, null, true),
    COMPOUND_RELOAD_FINISH(null, COMPOUND_REQUESTED, null, true),
    COMPOUND_RELOAD_FINISHED(null, COMPOUND_REQUESTED, null, true),
    LOAD_REQUESTED,
    LOAD(null, LOAD_REQUESTED, null, true),
    LOAD_ITERATION,
    LOAD_ITERATION_COMPLETED,
    ALL_LOAD_ITERATIONS_COMPLETED,
    AWAIT_FURTHER_LOAD_INSTRUCTIONS,
    UNLOAD_PREPARING,
    UNLOAD_REQUESTED,
    UNLOAD(UNLOAD_PREPARING, UNLOAD_REQUESTED, READY, true),
    FIRING(9),
    RECOILED(10),
    PAUSED(10),
    EJECT_REQUIRED,
    EJECTING,
    MODIFYING_REQUESTED(1),
    MODIFYING(2, null, MODIFYING_REQUESTED, null, false),
    NEXT_ATTACHMENT_REQUESTED,
    NEXT_ATTACHMENT(2, null, NEXT_ATTACHMENT_REQUESTED, null, false),
    ALERT,
    INSPECTING;

    private static final int DEFAULT_PRIORITY = 0;
    private WeaponState preparingPhase;
    private WeaponState permitRequestedPhase;
    private WeaponState commitPhase;
    private boolean isTransient;
    private int priority = 0;

    private WeaponState() {
        this(null, null, null, true);
    }

    private WeaponState(int priority) {
        this(priority, null, null, null, true);
    }

    private WeaponState(boolean isTransient) {
        this(null, null, null, isTransient);
    }

    private WeaponState(WeaponState preparingPhase, WeaponState permitRequestedState, WeaponState transactionFinalState, boolean isTransient) {
        this(0, preparingPhase, permitRequestedState, transactionFinalState, isTransient);
    }

    private WeaponState(int priority, WeaponState preparingPhase, WeaponState permitRequestedState, WeaponState transactionFinalState, boolean isTransient) {
        this.priority = priority;
        this.preparingPhase = preparingPhase;
        this.permitRequestedPhase = permitRequestedState;
        this.commitPhase = transactionFinalState;
        this.isTransient = false;
    }

    @Override
    public boolean isTransient() {
        return this.isTransient;
    }

    @Override
    public WeaponState preparingPhase() {
        return this.preparingPhase;
    }

    @Override
    public WeaponState permitRequestedPhase() {
        return this.permitRequestedPhase;
    }

    @Override
    public WeaponState commitPhase() {
        return this.commitPhase;
    }

    public int getPriority() {
        return this.priority;
    }

    @Override
    public void read(ByteBuf byteBuf) {
    }

    @Override
    public void write(ByteBuf byteBuf) {
    }

    static {
        TypeRegistry.getINSTANCE().register(WeaponState.class);
    }
}

