/*
 * Decompiled with CFR 0.152.
 */
package com.paneedah.weaponlib;

import com.paneedah.mwc.MWC;
import com.paneedah.mwc.network.messages.BlockHitMessage;
import com.paneedah.mwc.utils.ModReference;
import com.paneedah.weaponlib.AttachmentCategory;
import com.paneedah.weaponlib.AttachmentContainer;
import com.paneedah.weaponlib.CommonRegistry;
import com.paneedah.weaponlib.CompatibleAttachment;
import com.paneedah.weaponlib.EntityShellCasing;
import com.paneedah.weaponlib.ImpactHandler;
import com.paneedah.weaponlib.Inspectable;
import com.paneedah.weaponlib.ItemAmmo;
import com.paneedah.weaponlib.ItemAttachment;
import com.paneedah.weaponlib.ItemBullet;
import com.paneedah.weaponlib.ItemMagazine;
import com.paneedah.weaponlib.ItemScope;
import com.paneedah.weaponlib.ItemSkin;
import com.paneedah.weaponlib.MaterialImpactSound;
import com.paneedah.weaponlib.ModContext;
import com.paneedah.weaponlib.Modifiable;
import com.paneedah.weaponlib.Pair;
import com.paneedah.weaponlib.PlayerItemInstanceFactory;
import com.paneedah.weaponlib.PlayerWeaponInstance;
import com.paneedah.weaponlib.Reloadable;
import com.paneedah.weaponlib.RenderContext;
import com.paneedah.weaponlib.RenderableState;
import com.paneedah.weaponlib.Tags;
import com.paneedah.weaponlib.Updatable;
import com.paneedah.weaponlib.WeaponAttachmentAspect;
import com.paneedah.weaponlib.WeaponRenderer;
import com.paneedah.weaponlib.WeaponSpawnEntity;
import com.paneedah.weaponlib.WeaponState;
import com.paneedah.weaponlib.animation.ScreenShakeAnimation;
import com.paneedah.weaponlib.animation.ScreenShakingAnimationManager;
import com.paneedah.weaponlib.animation.SpecialAttachments;
import com.paneedah.weaponlib.compatibility.RecoilParam;
import com.paneedah.weaponlib.config.BalancePackManager;
import com.paneedah.weaponlib.config.ModernConfigManager;
import com.paneedah.weaponlib.crafting.CraftingComplexity;
import com.paneedah.weaponlib.crafting.CraftingEntry;
import com.paneedah.weaponlib.crafting.CraftingGroup;
import com.paneedah.weaponlib.crafting.CraftingRegistry;
import com.paneedah.weaponlib.crafting.IModernCraftingRecipe;
import com.paneedah.weaponlib.crafting.OptionsMetadata;
import com.paneedah.weaponlib.model.Shell;
import com.paneedah.weaponlib.render.WeaponSpritesheetBuilder;
import com.paneedah.weaponlib.render.shells.ShellParticleSimulator;
import io.redstudioragnarok.redcore.vectors.Vector3F;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class Weapon
extends Item
implements PlayerItemInstanceFactory<PlayerWeaponInstance, WeaponState>,
AttachmentContainer,
Reloadable,
Inspectable,
Modifiable,
Updatable,
IModernCraftingRecipe {
    private CraftingGroup craftingGroup = CraftingGroup.GUN;
    public static final int FIREMODE_AUTO = 2;
    public static final int FIREMODE_SINGLE = 0;
    public static final int FIREMODE_BURST = 1;
    private static final long DEFAULT_RELOADING_TIMEOUT_TICKS = 10L;
    private static final long DEFAULT_UNLOADING_TIMEOUT_TICKS = 10L;
    private static final long DEFAULT_LOAD_ITERATION_TIMEOUT_TICKS = 10L;
    static final long MAX_RELOAD_TIMEOUT_TICKS = 60L;
    static final long MAX_UNLOAD_TIMEOUT_TICKS = 60L;
    private static final long DEFAULT_BURST_TIMEOUT_MILLISECONDS = 150L;
    public static final float DEFAULT_SHELL_CASING_FORWARD_OFFSET = 0.1f;
    public static final float DEFAULT_SHELL_CASING_VERTICAL_OFFSET = 0.0f;
    public static final float DEFAULT_SHELL_CASING_SIDE_OFFSET = 0.15f;
    public static final float DEFAULT_SHELL_CASING_SIDE_OFFSET_AIMED = 0.05f;
    private static final float DEFAULT_FIRE_RATE = 0.5f;
    private static final float DEFAULT_SILENCED_SHOOT_SOUND_VOLUME = 0.7f;
    private static final float DEFAULT_SHOOT_SOUND_VOLUME = 10.0f;
    public Builder builder;
    private ModContext modContext;
    private Vec3d muzzlePosition;
    private CraftingEntry[] modernRecipe;
    private SoundEvent shootSound;
    private SoundEvent endOfShootSound;
    private SoundEvent silencedShootSound;
    private SoundEvent reloadSound;
    private SoundEvent reloadIterationSound;
    private SoundEvent inspectSound;
    private SoundEvent drawSound;
    private SoundEvent allReloadIterationsCompletedSound;
    private SoundEvent unloadSound;
    private SoundEvent ejectSpentRoundSound;
    private SoundEvent burstShootSound;
    private SoundEvent silencedBurstShootSound;

    Weapon(Builder builder, ModContext modContext) {
        this.builder = builder;
        this.modContext = modContext;
        this.func_77625_d(1);
    }

    public String getName() {
        return this.builder.name;
    }

    @Override
    public CraftingGroup getCraftingGroup() {
        return this.craftingGroup;
    }

    @Override
    public ItemStack getItemStack() {
        return new ItemStack((Item)this);
    }

    @Override
    public CraftingEntry[] getModernRecipe() {
        return this.modernRecipe;
    }

    public SoundEvent getShootSound() {
        return this.shootSound;
    }

    public SoundEvent getBurstShootSound() {
        return this.burstShootSound;
    }

    public SoundEvent getSilencedBurstShootSound() {
        return this.silencedBurstShootSound;
    }

    public SoundEvent getEndOfShootSound() {
        return this.endOfShootSound;
    }

    public SoundEvent getSilencedShootSound() {
        return this.silencedShootSound;
    }

    public SoundEvent getReloadSound() {
        return this.reloadSound;
    }

    public SoundEvent getReloadIterationSound() {
        return this.reloadIterationSound;
    }

    public SoundEvent getInspectSound() {
        return this.inspectSound;
    }

    public SoundEvent getDrawSound() {
        return this.drawSound;
    }

    public SoundEvent getAllReloadIterationsCompletedSound() {
        return this.allReloadIterationsCompletedSound;
    }

    public SoundEvent getUnloadSound() {
        return this.unloadSound;
    }

    public SoundEvent getEjectSpentRoundSound() {
        return this.ejectSpentRoundSound;
    }

    public Vec3d getMuzzlePosition() {
        return this.muzzlePosition;
    }

    public boolean onEntitySwing(EntityLivingBase entityLiving, ItemStack itemStack) {
        return true;
    }

    public void toggleAiming() {
        PlayerWeaponInstance mainHandHeldWeaponInstance = this.modContext.getMainHeldWeapon();
        if (mainHandHeldWeaponInstance != null && (mainHandHeldWeaponInstance.getState() == WeaponState.READY || mainHandHeldWeaponInstance.getState() == WeaponState.PAUSED || mainHandHeldWeaponInstance.getState() == WeaponState.EJECT_REQUIRED)) {
            mainHandHeldWeaponInstance.setAimed(!mainHandHeldWeaponInstance.isAimed());
        }
    }

    public void func_77663_a(ItemStack itemStack, World world, Entity entity, int p_77663_4_, boolean active) {
    }

    public void changeRecoil(EntityLivingBase player, float factor) {
        PlayerWeaponInstance instance = this.modContext.getMainHeldWeapon();
        if (instance != null) {
            float recoil = instance.getWeapon().builder.recoil * factor;
            ModReference.LOG.debug("Changing recoil to {} for instance {}", (Object)Float.valueOf(recoil), (Object)instance);
            instance.setRecoil(recoil);
        }
    }

    public Map<ItemAttachment<Weapon>, CompatibleAttachment<Weapon>> getCompatibleAttachments() {
        return this.builder.compatibleAttachments;
    }

    @Override
    public Collection<CompatibleAttachment<? extends AttachmentContainer>> getCompatibleAttachments(AttachmentCategory ... categories) {
        Collection<CompatibleAttachment<Weapon>> c = this.builder.compatibleAttachments.values();
        List<AttachmentCategory> inputCategoryList = Arrays.asList(categories);
        return c.stream().filter(e -> inputCategoryList.contains((Object)e.getAttachment().getCategory())).collect(Collectors.toList());
    }

    String getCrosshair(PlayerWeaponInstance weaponInstance) {
        if (weaponInstance.isAimed()) {
            String crosshair = null;
            ItemAttachment<Weapon> scopeAttachment = WeaponAttachmentAspect.getActiveAttachment(AttachmentCategory.SCOPE, weaponInstance);
            if (scopeAttachment != null) {
                crosshair = scopeAttachment.getCrosshair();
            }
            if (crosshair == null) {
                crosshair = this.builder.crosshairZoomed;
            }
            return crosshair;
        }
        if (weaponInstance.getPlayer().func_70051_ag()) {
            return this.builder.crosshairRunning;
        }
        return this.builder.crosshair;
    }

    public static boolean isActiveAttachment(PlayerWeaponInstance weaponInstance, ItemAttachment<Weapon> attachment) {
        return weaponInstance != null ? WeaponAttachmentAspect.isActiveAttachment(attachment, weaponInstance) : false;
    }

    public int func_77626_a(ItemStack itemStack) {
        return 0;
    }

    int getCurrentAmmo(EntityPlayer player) {
        PlayerWeaponInstance state = this.modContext.getMainHeldWeapon();
        return state.getAmmo();
    }

    public int getAmmoCapacity() {
        return this.builder.ammoCapacity;
    }

    int getMaxBulletsPerReload() {
        return this.builder.maxBulletsPerReload;
    }

    ModelBase getAmmoModel() {
        return this.builder.ammoModel;
    }

    String getAmmoModelTextureName() {
        return this.builder.ammoModelTextureName;
    }

    ModelBase getShellCasingModel() {
        return this.builder.shellCasingModel;
    }

    String getShellCasingTextureName() {
        return this.builder.shellCasingModelTextureName;
    }

    void onSpawnEntityBlockImpact(World world, EntityPlayer player, WeaponSpawnEntity entity, RayTraceResult position) {
        if (!world.field_72995_K && this.builder.blockImpactHandler != null) {
            this.builder.blockImpactHandler.onImpact(world, player, entity, position);
        }
    }

    @Override
    public List<CompatibleAttachment<? extends AttachmentContainer>> getActiveAttachments(EntityLivingBase player, ItemStack itemStack) {
        return this.modContext.getAttachmentAspect().getActiveAttachments(player, itemStack);
    }

    long getUnloadTimeoutTicks() {
        return this.builder.unloadingTimeout;
    }

    boolean ejectSpentRoundRequired() {
        return this.builder.ejectSpentRoundRequired;
    }

    public List<ItemMagazine> getCompatibleMagazines() {
        return this.builder.compatibleAttachments.keySet().stream().filter(a -> a instanceof ItemMagazine).map(a -> (ItemMagazine)a).collect(Collectors.toList());
    }

    public WeaponRenderer getRenderer() {
        return this.builder.renderer;
    }

    public List<ItemAttachment<Weapon>> getCompatibleAttachments(Class<? extends ItemAttachment<Weapon>> target) {
        return this.builder.compatibleAttachments.entrySet().stream().filter(e -> target.isInstance(e.getKey())).map(e -> (ItemAttachment)e.getKey()).collect(Collectors.toList());
    }

    public void func_77624_a(ItemStack itemStack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (tooltip != null) {
            tooltip.add(this.builder.newSys ? "\u00a7aWeapon System Version: \u00a772" : "\u00a7aWeapon System Version: \u00a7c1");
            if (this.builder.informationProvider != null) {
                tooltip.addAll((Collection)this.builder.informationProvider.apply(itemStack));
            }
        }
    }

    @Override
    public void reloadMainHeldItemForPlayer(EntityPlayer player) {
        this.modContext.getWeaponReloadAspect().reloadMainHeldItem(player);
    }

    @Override
    public void unloadMainHeldItemForPlayer(EntityPlayer player) {
        this.modContext.getWeaponReloadAspect().unloadMainHeldItem(player);
    }

    @Override
    public void inspectMainHeldItemForPlayer(EntityPlayer player) {
        this.modContext.getWeaponReloadAspect().inspectMainHeldItem(player);
    }

    @Override
    public void update(EntityPlayer player) {
        this.modContext.getWeaponReloadAspect().updateMainHeldItem(player);
        this.modContext.getWeaponFireAspect().onUpdate(player);
        this.modContext.getAttachmentAspect().updateMainHeldItem(player);
    }

    public void tryFire(EntityPlayer player) {
        this.modContext.getWeaponFireAspect().onFireButtonDown(player);
    }

    public void tryStopFire(EntityPlayer player) {
        this.modContext.getWeaponFireAspect().onFireButtonRelease(player);
    }

    @Override
    public PlayerWeaponInstance createItemInstance(EntityLivingBase player, ItemStack itemStack, int slot) {
        PlayerWeaponInstance instance = new PlayerWeaponInstance(slot, player, itemStack);
        instance.setState(WeaponState.READY);
        instance.setRecoil(BalancePackManager.shouldChangeWeaponRecoil(instance.getWeapon()) ? (float)BalancePackManager.getNewWeaponRecoil(instance.getWeapon()) : this.builder.recoil);
        instance.setMaxShots(this.builder.maxShots.get(0));
        for (CompatibleAttachment<Weapon> compatibleAttachment : ((Weapon)itemStack.func_77973_b()).getCompatibleAttachments().values()) {
            ItemAttachment<Weapon> attachment = compatibleAttachment.getAttachment();
            if (!compatibleAttachment.isDefault() || attachment.getApply2() == null) continue;
            attachment.apply2.apply(attachment, instance);
        }
        return instance;
    }

    @Override
    public void toggleClientAttachmentSelectionMode(EntityPlayer player) {
        this.modContext.getAttachmentAspect().toggleClientAttachmentSelectionMode(player);
    }

    public boolean onDroppedByPlayer(ItemStack itemStack, EntityPlayer player) {
        PlayerWeaponInstance instance = (PlayerWeaponInstance)Tags.getInstance(itemStack);
        return instance == null || instance.getState() == WeaponState.READY;
    }

    void changeFireMode(PlayerWeaponInstance instance) {
        List<Integer> maxShotsList = BalancePackManager.getFiremodeListForWeapon(instance.getWeapon());
        Iterator<Integer> it = maxShotsList.iterator();
        while (it.hasNext() && instance.getMaxShots() != it.next().intValue()) {
        }
        int result = it.hasNext() ? it.next().intValue() : maxShotsList.get(0).intValue();
        instance.setMaxShots(result);
        String message = result == 1 ? I18n.func_135052_a((String)"gui.firearmMode.semi", (Object[])new Object[0]) : (result == Integer.MAX_VALUE ? I18n.func_135052_a((String)"gui.firearmMode.auto", (Object[])new Object[0]) : I18n.func_135052_a((String)"gui.firearmMode.burst", (Object[])new Object[0]));
        ModReference.LOG.debug("Changed fire mode of {} to {}", (Object)instance, (Object)result);
        if (instance.getPlayer() instanceof EntityPlayer) {
            ((EntityPlayer)instance.getPlayer()).func_146105_b((ITextComponent)new TextComponentString(I18n.func_135052_a((String)"gui.firearmMode", (Object[])new Object[]{message})), true);
        }
        instance.getPlayer().func_184185_a(this.modContext.getChangeFireModeSound(), 1.0f, 1.0f);
    }

    public long getTotalReloadingDuration() {
        return this.builder.renderer.getTotalReloadingDuration();
    }

    public long getPrepareFirstLoadIterationAnimationDuration() {
        return this.builder.renderer.getPrepareFirstLoadIterationAnimationDuration();
    }

    public long getAllLoadIterationAnimationsCompletedDuration() {
        return this.builder.renderer.getAllLoadIterationAnimationsCompletedDuration();
    }

    public long getTotalLoadIterationDuration() {
        return this.builder.renderer.getTotalLoadIterationDuration();
    }

    public long getTotalUnloadingDuration() {
        return this.builder.renderer.getTotalUnloadingDuration();
    }

    public long getTotalDrawingDuration() {
        return this.builder.renderer.getTotalDrawingDuration();
    }

    public boolean hasRecoilPositioning() {
        return this.builder.renderer.hasRecoilPositioning();
    }

    public void setRecoilParameters(RecoilParam param) {
        this.builder.recoilParam = param;
    }

    public RecoilParam getRecoilParameters() {
        return this.builder.recoilParam;
    }

    void incrementZoom(PlayerWeaponInstance instance) {
        ItemAttachment<Weapon> scopeItem = instance.getAttachmentItemWithCategory(AttachmentCategory.SCOPE);
        if (scopeItem instanceof ItemScope && ((ItemScope)scopeItem).isOptical()) {
            float minZoom = ((ItemScope)scopeItem).getMinZoom();
            float maxZoom = ((ItemScope)scopeItem).getMaxZoom();
            float increment = (minZoom - maxZoom) / 7.5f;
            float zoom = instance.getZoom();
            if (zoom > maxZoom) {
                zoom = Math.max(zoom - increment, maxZoom);
            }
            instance.setZoom(zoom);
            float ratio = (minZoom - zoom) / (minZoom - maxZoom);
            if (instance.getPlayer() instanceof EntityPlayer) {
                ((EntityPlayer)instance.getPlayer()).func_146105_b((ITextComponent)new TextComponentString(I18n.func_135052_a((String)"gui.currentZoom", (Object[])new Object[]{Math.round(ratio * 100.0f)})), true);
            }
            instance.getPlayer().func_184185_a(this.modContext.getZoomSound(), 1.0f, 1.0f);
            ModReference.LOG.debug("Changed optical zoom to {}", (Object)Float.valueOf(instance.getZoom()));
        } else {
            ModReference.LOG.debug("Cannot change non-optical zoom");
        }
    }

    void decrementZoom(PlayerWeaponInstance instance) {
        ItemAttachment<Weapon> scopeItem = instance.getAttachmentItemWithCategory(AttachmentCategory.SCOPE);
        if (scopeItem instanceof ItemScope && ((ItemScope)scopeItem).isOptical()) {
            float minZoom = ((ItemScope)scopeItem).getMinZoom();
            float maxZoom = ((ItemScope)scopeItem).getMaxZoom();
            float increment = (minZoom - maxZoom) / 7.5f;
            float zoom = instance.getZoom();
            if (zoom < minZoom) {
                zoom = Math.min(zoom + increment, minZoom);
            }
            instance.setZoom(zoom);
            float ratio = (minZoom - zoom) / (minZoom - maxZoom);
            if (instance.getPlayer() instanceof EntityPlayer) {
                ((EntityPlayer)instance.getPlayer()).func_146105_b((ITextComponent)new TextComponentString(I18n.func_135052_a((String)"gui.currentZoom", (Object[])new Object[]{Math.round(ratio * 100.0f)})), true);
            }
            instance.getPlayer().func_184185_a(this.modContext.getZoomSound(), 1.0f, 1.0f);
            ModReference.LOG.debug("Changed optical zoom to {}", (Object)Float.valueOf(zoom));
        } else {
            ModReference.LOG.debug("Cannot change non-optical zoom");
        }
    }

    public ItemAttachment.ApplyHandler2<Weapon> getEquivalentHandler(AttachmentCategory attachmentCategory) {
        ItemAttachment.ApplyHandler2<Weapon> handler = (a, i) -> {};
        switch (attachmentCategory) {
            case SCOPE: {
                break;
            }
            case GRIP: {
                handler = (a, i) -> i.setRecoil(BalancePackManager.shouldChangeWeaponRecoil(i.getWeapon()) ? (float)BalancePackManager.getNewWeaponRecoil(i.getWeapon()) : this.builder.recoil);
            }
        }
        return handler;
    }

    public String getTextureName() {
        return this.builder.textureNames.get(0);
    }

    public float getRecoil() {
        return BalancePackManager.shouldChangeWeaponRecoil(this) ? (float)BalancePackManager.getNewWeaponRecoil(this) : this.builder.recoil;
    }

    public ModContext getModContext() {
        return this.modContext;
    }

    public float getShellCasingVerticalOffset() {
        return this.builder.shellCasingVerticalOffset;
    }

    public float getShellCasingForwardOffset() {
        return this.builder.shellCasingForwardOffset;
    }

    public ShellParticleSimulator.Shell.Type getShellType() {
        return this.builder.shellType;
    }

    public float getShellCasingSideOffset() {
        return this.builder.shellCasingSideOffset;
    }

    public float getShellCasingSideOffsetAimed() {
        return this.builder.shellCasingSideOffsetAimed;
    }

    public boolean isShellCasingEjectEnabled() {
        return this.builder.shellCasingEjectEnabled;
    }

    public ShellCasingEjectDirection getShellCasingEjectDirection() {
        return this.builder.shellCasingEjectDirection;
    }

    public float getSilencedShootSoundVolume() {
        return this.builder.silencedShootSoundVolume;
    }

    public float getShootSoundVolume() {
        return this.builder.shootSoundVolume;
    }

    public boolean hasFlashPedals() {
        return this.builder.hasFlashPedals;
    }

    public BalancePackManager.GunConfigurationGroup getConfigurationGroup() {
        return this.builder.configGroup;
    }

    public boolean hasIteratedLoad() {
        return this.builder.hasIteratedLoad;
    }

    public float getSpawnEntityVelocity() {
        return this.builder.spawnEntitySpeed;
    }

    public float getSpawnEntityGravityVelocity() {
        return this.builder.spawnEntityGravityVelocity;
    }

    public float getSpawnEntityDamage() {
        return this.builder.spawnEntityDamage;
    }

    public float getSpawnEntityExplosionRadius() {
        return this.builder.spawnEntityExplosionRadius;
    }

    public float getInaccuracy() {
        return this.builder.inaccuracy;
    }

    public boolean isCategoryRemovable(AttachmentCategory category) {
        return !this.builder.unremovableAttachmentCategories.contains((Object)category);
    }

    public float getADSZoom() {
        return this.builder.zoom;
    }

    public boolean isDestroyingBlocks() {
        return this.builder.isDestroyingBlocks;
    }

    public float getSmokeParticleAgeCoefficient() {
        return this.builder.spawnEntitySmokeParticleAgeCoefficient;
    }

    public float getSmokeParticleScaleCoefficient() {
        return this.builder.spawnEntitySmokeParticleScaleCoefficient;
    }

    public float getParticleAgeCoefficient() {
        return this.builder.spawnEntityParticleAgeCoefficient;
    }

    public float getExplosionScaleCoefficient() {
        return this.builder.spawnEntityExplosionParticleScaleCoefficient;
    }

    public boolean isSmokeEnabled() {
        return this.builder.smokeEnabled;
    }

    public float getBleedingCoefficient() {
        return this.builder.bleedingCoefficient;
    }

    public boolean hasRocketParticles() {
        return this.builder.spawnEntityRocketParticles;
    }

    public Pair<Double, Double> getModernScreenShakeParameters() {
        return this.builder.screenShakingParameters;
    }

    public ScreenShakeAnimation.Builder getScreenShakeAnimationBuilder(RenderableState renderableState) {
        return (ScreenShakeAnimation.Builder)this.builder.screenShakingBuilders.get((Object)renderableState);
    }

    @Override
    public void setCraftingRecipe(CraftingEntry[] recipe) {
        this.modernRecipe = recipe;
    }

    @Override
    public void setCraftingGroup(CraftingGroup group) {
        this.craftingGroup = group;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return true;
    }

    static /* synthetic */ CraftingEntry[] access$1302(Weapon x0, CraftingEntry[] x1) {
        x0.modernRecipe = x1;
        return x1;
    }

    public static enum State {
        READY,
        SHOOTING,
        RELOAD_REQUESTED,
        RELOAD_CONFIRMED,
        UNLOAD_STARTED,
        UNLOAD_REQUESTED_FROM_SERVER,
        UNLOAD_CONFIRMED,
        PAUSED,
        MODIFYING,
        EJECT_SPENT_ROUND;

    }

    public static class Builder {
        public static int noRecipe = 0;
        private static final float DEFAULT_SPAWN_ENTITY_SPEED = 150.0f;
        private static final float DEFAULT_INACCURACY = 0.0f;
        private static final String DEFAULT_SHELL_CASING_TEXTURE_NAME = "weaponlib:/com/paneedah/weaponlib/resources/shell.png";
        private static final float DEFAULT_SHELL_CASING_VELOCITY = 0.1f;
        private static final float DEFAULT_SHELL_CASING_GRAVITY_VELOCITY = 0.05f;
        private static final float DEFAULT_SHELL_CASING_INACCURACY = 20.0f;
        String name;
        List<String> textureNames = new ArrayList<String>();
        int ammoCapacity = 0;
        float recoil = 1.0f;
        private boolean hasFlashPedals = false;
        private String shootSound;
        private String silencedShootSound;
        private String reloadSound;
        private String reloadIterationSound;
        private String inspectSound;
        private String drawSound;
        private String allReloadIterationsCompletedSound;
        private String unloadSound;
        private String ejectSpentRoundSound;
        private String endOfShootSound;
        private String burstShootSound;
        private String silencedBurstShootSound;
        private BalancePackManager.GunConfigurationGroup configGroup = BalancePackManager.GunConfigurationGroup.NONE;
        private Vec3d muzzlePosition = new Vec3d(-0.3, -1.0, -5.3);
        private String exceededMaxShotsSound;
        ItemAmmo ammo;
        float fireRate = 0.5f;
        private CreativeTabs creativeTab;
        private WeaponRenderer renderer;
        List<Integer> maxShots = new ArrayList<Integer>();
        String crosshair;
        String crosshairRunning;
        String crosshairZoomed;
        BiFunction<Weapon, EntityLivingBase, ? extends WeaponSpawnEntity> spawnEntityWith;
        BiFunction<PlayerWeaponInstance, EntityLivingBase, ? extends EntityShellCasing> spawnShellWith;
        private float spawnEntityDamage;
        private boolean spawnEntityRocketParticles;
        private float spawnEntityExplosionRadius;
        private boolean isDestroyingBlocks = true;
        private float spawnEntityGravityVelocity;
        private float spawnEntityParticleAgeCoefficient = 1.0f;
        private float spawnEntitySmokeParticleAgeCoefficient = 1.0f;
        private float spawnEntityExplosionParticleScaleCoefficient = 1.5f;
        private float spawnEntitySmokeParticleScaleCoefficient = 1.0f;
        public long reloadingTimeout = 10L;
        long loadIterationTimeout = 10L;
        boolean crosshairFullScreen = false;
        boolean crosshairZoomedFullScreen = false;
        Map<ItemAttachment<Weapon>, CompatibleAttachment<Weapon>> compatibleAttachments = new HashMap<ItemAttachment<Weapon>, CompatibleAttachment<Weapon>>();
        ModelBase ammoModel;
        String ammoModelTextureName;
        ModelBase shellCasingModel;
        String shellCasingModelTextureName;
        private float spawnEntitySpeed = 150.0f;
        private Class<? extends WeaponSpawnEntity> spawnEntityClass;
        ImpactHandler blockImpactHandler;
        long pumpTimeoutMilliseconds;
        long burstTimeoutMilliseconds = 150L;
        private float inaccuracy = 0.0f;
        int pellets = 1;
        boolean smokeEnabled = true;
        float bleedingCoefficient = 1.0f;
        String explosionParticleTexture;
        String smokeParticleTexture;
        float flashIntensity = 0.2f;
        Supplier<Float> flashScale = () -> Float.valueOf(1.0f);
        Supplier<Float> flashOffsetX = () -> Float.valueOf(0.0f);
        Supplier<Float> flashOffsetY = () -> Float.valueOf(0.0f);
        Supplier<Float> smokeOffsetX = () -> Float.valueOf(0.0f);
        Supplier<Float> smokeOffsetY = () -> Float.valueOf(0.0f);
        long unloadingTimeout = 10L;
        private boolean ejectSpentRoundRequired;
        public int maxBulletsPerReload;
        private Function<ItemStack, List<String>> informationProvider;
        private CraftingComplexity craftingComplexity;
        private Object[] craftingMaterials;
        private String gunType = "LAUNCHER";
        private float shellCasingForwardOffset = 0.1f;
        private float shellCasingVerticalOffset = 0.0f;
        private float shellCasingSideOffset = 0.15f;
        private float shellCasingSideOffsetAimed = 0.05f;
        public boolean shellCasingEjectEnabled = true;
        public RecoilParam recoilParam = new RecoilParam();
        private boolean hasIteratedLoad;
        private ShellCasingEjectDirection shellCasingEjectDirection = ShellCasingEjectDirection.RIGHT;
        private float silencedShootSoundVolume = 0.7f;
        private float shootSoundVolume = 10.0f;
        private Object[] craftingRecipe;
        private CraftingEntry[] modernCraftingRecipe;
        public boolean isOneClickBurstAllowed;
        String flashTexture;
        private ShellParticleSimulator.Shell.Type shellType = ShellParticleSimulator.Shell.Type.ASSAULT;
        private Set<AttachmentCategory> unremovableAttachmentCategories = new HashSet<AttachmentCategory>();
        private Map<RenderableState, ScreenShakeAnimation.Builder> screenShakingBuilders = new HashMap<RenderableState, ScreenShakeAnimation.Builder>();
        private float zoom;
        protected Pair<Double, Double> screenShakingParameters = new Pair<Double, Double>(100.0, 1.0);
        private boolean newSys = false;
        private int[][] guiPositions = new int[][]{{-43, 86}, {97, 96}, {92, 34}, {14, -55}, {164, -26}, {145, 67}, {60, 110}, {0, -50}, {-100, -50}, {-29, 44}, {50, 100}};

        public Builder() {
            ScreenShakeAnimation.Builder defaultShootingStateScreenShakingBuilder = new ScreenShakeAnimation.Builder().withState(ScreenShakingAnimationManager.State.SHOOTING).withRotationAttenuation(0.5f).withTranslationAttenuation(0.05f).withZRotationCoefficient(2.0f).withTransitionDuration(50L);
            this.screenShakingBuilders.put(RenderableState.SHOOTING, defaultShootingStateScreenShakingBuilder);
        }

        public Builder withConfigGroup(BalancePackManager.GunConfigurationGroup group) {
            this.gunType = String.valueOf((Object)group);
            this.configGroup = group;
            return this;
        }

        public Builder withWeaponType(String type) {
            this.gunType = type;
            return this;
        }

        public String getWeaponType() {
            return this.gunType;
        }

        public Builder hasGUIPositions(int[][] gp) {
            this.guiPositions = gp;
            return this;
        }

        public List<Integer> getMaxShots() {
            return this.maxShots;
        }

        public int[][] getGUIPositions() {
            return this.guiPositions;
        }

        public float getFirerate() {
            return this.fireRate;
        }

        public float getInaccuracy() {
            return this.inaccuracy;
        }

        public Builder hasFlashPedals() {
            this.hasFlashPedals = true;
            return this;
        }

        public Builder useNewSystem() {
            this.newSys = true;
            return this;
        }

        public Builder withShellType(ShellParticleSimulator.Shell.Type type) {
            this.shellType = type;
            return this;
        }

        public boolean isUsingNewSystem() {
            return this.newSys;
        }

        public Builder withEjectRoundRequired() {
            this.ejectSpentRoundRequired = true;
            return this;
        }

        @Deprecated
        public Builder withInformationProvider(Function<ItemStack, List<String>> informationProvider) {
            return this;
        }

        public Builder withReloadingTime(long reloadingTime) {
            this.reloadingTimeout = reloadingTime;
            return this;
        }

        public Builder withUnloadingTime(long unloadingTime) {
            this.unloadingTimeout = unloadingTime;
            return this;
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withRecoilParam(RecoilParam param) {
            this.recoilParam = param;
            return this;
        }

        public Builder withAmmoCapacity(int ammoCapacity) {
            this.ammoCapacity = ammoCapacity;
            return this;
        }

        public Builder withMaxBulletsPerReload(int maxBulletsPerReload) {
            this.maxBulletsPerReload = maxBulletsPerReload;
            return this;
        }

        public Builder withIteratedLoad() {
            this.hasIteratedLoad = true;
            return this;
        }

        public Builder withRecoil(float recoil) {
            this.recoil = recoil;
            return this;
        }

        public Builder withZoom(float zoom) {
            this.zoom = zoom;
            return this;
        }

        public Builder withAmmo(ItemAmmo ammo) {
            this.ammo = ammo;
            return this;
        }

        public Builder withMaxShots(int ... maxShots) {
            for (int m : maxShots) {
                this.maxShots.add(m);
            }
            return this;
        }

        public Builder withOneClickBurst() {
            this.isOneClickBurstAllowed = true;
            return this;
        }

        public Builder withBurstTimeout(long burstTimeoutMilliseconds) {
            this.burstTimeoutMilliseconds = burstTimeoutMilliseconds;
            return this;
        }

        public Builder withFireRate(float fireRate) {
            if (fireRate >= 1.0f || fireRate <= 0.0f) {
                throw new IllegalArgumentException("Invalid fire rate " + fireRate);
            }
            this.fireRate = fireRate;
            return this;
        }

        public Builder withTextureNames(String ... textureNames) {
            for (String textureName : textureNames) {
                this.textureNames.add(textureName.toLowerCase() + ".png");
            }
            return this;
        }

        public Builder withCrosshair(String crosshair) {
            this.crosshair = "mwc:textures/crosshairs/" + crosshair.toLowerCase() + ".png";
            return this;
        }

        public Builder withCrosshair(String crosshair, boolean fullScreen) {
            this.crosshair = "mwc:textures/crosshairs/" + crosshair.toLowerCase() + ".png";
            this.crosshairFullScreen = fullScreen;
            return this;
        }

        public Builder withCrosshairRunning(String crosshairRunning) {
            this.crosshairRunning = "mwc:textures/crosshairs/" + crosshairRunning.toLowerCase() + ".png";
            return this;
        }

        public Builder withCrosshairZoomed(String crosshairZoomed) {
            return this.withCrosshairZoomed(crosshairZoomed, true);
        }

        public Builder withCrosshairZoomed(String crosshairZoomed, boolean fullScreen) {
            this.crosshairZoomed = "mwc:textures/crosshairs/" + crosshairZoomed.toLowerCase() + ".png";
            this.crosshairZoomedFullScreen = fullScreen;
            return this;
        }

        public Builder withMuzzlePosition(Vec3d pos) {
            this.muzzlePosition = pos;
            return this;
        }

        public Builder withShootSound(String shootSound) {
            this.shootSound = shootSound.toLowerCase();
            return this;
        }

        public Builder withEndOfShootSound(String endOfShootSound) {
            this.endOfShootSound = endOfShootSound.toLowerCase();
            return this;
        }

        public Builder withEjectSpentRoundSound(String ejectSpentRoundSound) {
            this.ejectSpentRoundSound = ejectSpentRoundSound.toLowerCase();
            return this;
        }

        public Builder withSilencedShootSound(String silencedShootSound) {
            this.silencedShootSound = silencedShootSound.toLowerCase();
            return this;
        }

        public Builder withBurstShootSound(String burstShootSound) {
            this.burstShootSound = burstShootSound.toLowerCase();
            return this;
        }

        public Builder withSilencedBurstShootSound(String silencedBurstShootSound) {
            this.silencedBurstShootSound = silencedBurstShootSound.toLowerCase();
            return this;
        }

        public Builder withReloadSound(String reloadSound) {
            this.reloadSound = reloadSound.toLowerCase();
            return this;
        }

        public Builder withReloadIterationSound(String reloadIterationSound) {
            this.reloadIterationSound = reloadIterationSound.toLowerCase();
            return this;
        }

        public Builder withInspectSound(String inspectSound) {
            this.inspectSound = inspectSound.toLowerCase();
            return this;
        }

        public Builder withDrawSound(String drawSound) {
            this.drawSound = drawSound.toLowerCase();
            return this;
        }

        public Builder withAllReloadIterationsCompletedSound(String allReloadIterationCompletedSound) {
            this.allReloadIterationsCompletedSound = allReloadIterationCompletedSound.toLowerCase();
            return this;
        }

        public Builder withUnloadSound(String unloadSound) {
            this.unloadSound = unloadSound.toLowerCase();
            return this;
        }

        public Builder withShootSoundVolume(float volume) {
            this.shootSoundVolume = volume;
            return this;
        }

        public Builder withSilenceShootSoundVolume(float volume) {
            this.silencedShootSoundVolume = volume;
            return this;
        }

        public Builder withExceededMaxShotsSound(String shootSound) {
            this.exceededMaxShotsSound = shootSound.toLowerCase();
            return this;
        }

        public Builder withCreativeTab(CreativeTabs creativeTab) {
            this.creativeTab = creativeTab;
            return this;
        }

        public Builder withSpawnEntityRocketParticles() {
            this.spawnEntityRocketParticles = true;
            return this;
        }

        public Builder withSpawnEntityDamage(float spawnEntityDamage) {
            this.spawnEntityDamage = spawnEntityDamage;
            return this;
        }

        public Builder withSpawnEntitySpeed(float spawnEntitySpeed) {
            this.spawnEntitySpeed = spawnEntitySpeed;
            return this;
        }

        public Builder withSpawnEntityExplosionRadius(float spawnEntityExplosionRadius) {
            this.spawnEntityExplosionRadius = spawnEntityExplosionRadius;
            return this;
        }

        public Builder withDestroyingBlocks(boolean isDestroyingBlocks) {
            this.isDestroyingBlocks = isDestroyingBlocks;
            return this;
        }

        public Builder withSpawnEntityGravityVelocity(float spawnEntityGravityVelocity) {
            this.spawnEntityGravityVelocity = spawnEntityGravityVelocity;
            return this;
        }

        public Builder withSpawnEntityParticleAgeCoefficient(float spawnEntityParticleAgeCoefficient) {
            this.spawnEntityParticleAgeCoefficient = spawnEntityParticleAgeCoefficient;
            return this;
        }

        public Builder withSpawnEntitySmokeParticleAgeCoefficient(float spawnEntitySmokeParticleAgeCoefficient) {
            this.spawnEntitySmokeParticleAgeCoefficient = spawnEntitySmokeParticleAgeCoefficient;
            return this;
        }

        public Builder withSpawnEntityExplosionParticleScaleCoefficient(float spawnEntityExplosionParticleScaleCoefficient) {
            this.spawnEntityExplosionParticleScaleCoefficient = spawnEntityExplosionParticleScaleCoefficient;
            return this;
        }

        public Builder withSpawnEntitySmokeParticleScaleCoefficient(float spawnEntitySmokeParticleScaleCoefficient) {
            this.spawnEntitySmokeParticleScaleCoefficient = spawnEntitySmokeParticleScaleCoefficient;
            return this;
        }

        public Builder withInaccuracy(float inaccuracy) {
            this.inaccuracy = inaccuracy;
            return this;
        }

        public Builder withRenderer(WeaponRenderer renderer) {
            this.renderer = renderer;
            return this;
        }

        public Builder withCompatibleBullet(ItemBullet bullet, Consumer<ModelBase> positioner) {
            this.compatibleAttachments.put(bullet, new CompatibleAttachment<Weapon>(bullet, positioner));
            return this;
        }

        public Builder withUnremovableAttachmentCategories(AttachmentCategory ... categories) {
            for (AttachmentCategory category : categories) {
                this.unremovableAttachmentCategories.add(category);
            }
            return this;
        }

        public Builder withCompatibleAttachment(ItemAttachment<Weapon> attachment, ItemAttachment.ApplyHandler2<Weapon> applyHandler, ItemAttachment.ApplyHandler2<Weapon> removeHandler) {
            this.compatibleAttachments.put(attachment, new CompatibleAttachment<Weapon>(attachment, applyHandler, removeHandler));
            return this;
        }

        public Builder withCompatibleAttachment(ItemAttachment<Weapon> attachment, BiConsumer<EntityLivingBase, ItemStack> positioning, Consumer<ModelBase> modelPositioning) {
            this.compatibleAttachments.put(attachment, new CompatibleAttachment<Weapon>(attachment, positioning, modelPositioning, false));
            return this;
        }

        public Builder withCompatibleAttachment(ItemAttachment<Weapon> attachment, Consumer<RenderContext<RenderableState>> positioning, Consumer<ModelBase> modelPositioning, boolean isDefault, boolean isPermanent) {
            this.compatibleAttachments.put(attachment, new CompatibleAttachment<Weapon>(attachment, positioning, modelPositioning, isDefault, isPermanent));
            return this;
        }

        public Builder withCompatibleAttachment(ItemAttachment<Weapon> attachment, BiConsumer<EntityLivingBase, ItemStack> positioning) {
            this.compatibleAttachments.put(attachment, new CompatibleAttachment<Weapon>(attachment, positioning, null, false));
            return this;
        }

        public Builder withCompatibleAttachment(ItemAttachment<Weapon> attachment, Consumer<ModelBase> positioner) {
            this.compatibleAttachments.put(attachment, new CompatibleAttachment<Weapon>(attachment, positioner));
            return this;
        }

        public Builder withCompatibleAttachment(ItemAttachment<Weapon> attachment, boolean isDefault, BiConsumer<EntityLivingBase, ItemStack> positioning, Consumer<ModelBase> modelPositioning) {
            this.compatibleAttachments.put(attachment, new CompatibleAttachment<Weapon>(attachment, positioning, modelPositioning, isDefault));
            return this;
        }

        public Builder withCompatibleAttachment(ItemAttachment<Weapon> attachment, boolean isDefault, boolean isPermanent, BiConsumer<EntityLivingBase, ItemStack> positioning, Consumer<ModelBase> modelPositioning) {
            this.compatibleAttachments.put(attachment, new CompatibleAttachment<Weapon>(attachment, positioning, modelPositioning, isDefault, isPermanent));
            return this;
        }

        public Builder withCompatibleAttachment(ItemAttachment<Weapon> attachment, boolean isDefault, Consumer<ModelBase> positioner) {
            this.compatibleAttachments.put(attachment, new CompatibleAttachment<Weapon>(attachment, positioner, isDefault));
            return this;
        }

        public Builder withSpawnEntityModel(ModelBase ammoModel) {
            this.ammoModel = ammoModel;
            return this;
        }

        public Builder withSpawnEntityModelTexture(String ammoModelTextureName) {
            this.ammoModelTextureName = "mwc:textures/models/" + ammoModelTextureName.toLowerCase() + ".png";
            return this;
        }

        public Builder withSpawnEntityBlockImpactHandler(ImpactHandler impactHandler) {
            this.blockImpactHandler = impactHandler;
            return this;
        }

        public Builder withShellCasingEjectEnabled(boolean shellCasingEjectEnabled) {
            this.shellCasingEjectEnabled = shellCasingEjectEnabled;
            return this;
        }

        public Builder withShellCasingModel(ModelBase shellCasingModel) {
            this.shellCasingModel = shellCasingModel;
            return this;
        }

        public Builder withShellCasingModelTexture(String shellModelTextureName) {
            this.shellCasingModelTextureName = "mwc:textures/models/" + shellModelTextureName.toLowerCase() + ".png";
            return this;
        }

        public Builder withShellCasingForwardOffset(float shellCasingForwardOffset) {
            this.shellCasingForwardOffset = shellCasingForwardOffset;
            return this;
        }

        public Builder withShellCasingVerticalOffset(float shellCasingVerticalOffset) {
            this.shellCasingVerticalOffset = shellCasingVerticalOffset;
            return this;
        }

        public Builder withShellCasingSideOffset(float shellCasingSideOffset) {
            this.shellCasingSideOffset = shellCasingSideOffset;
            return this;
        }

        public Builder withShellCasingSideOffsetAimed(float shellCasingSideOffsetAimed) {
            this.shellCasingSideOffsetAimed = shellCasingSideOffsetAimed;
            return this;
        }

        public Builder withShellCasingEjectDirection(ShellCasingEjectDirection shellCasingEjectDirection) {
            this.shellCasingEjectDirection = shellCasingEjectDirection;
            return this;
        }

        public Builder withPumpTimeout(long pumpTimeoutMilliseconds) {
            this.pumpTimeoutMilliseconds = pumpTimeoutMilliseconds;
            return this;
        }

        public Builder withPellets(int pellets) {
            if (pellets < 1) {
                throw new IllegalArgumentException("Pellet count must be >= 1");
            }
            this.pellets = pellets;
            return this;
        }

        public Builder withSmoke(boolean smokeEnabled) {
            this.smokeEnabled = smokeEnabled;
            return this;
        }

        public Builder withFlashIntensity(float flashIntensity) {
            if (flashIntensity < 0.0f || flashIntensity > 1.0f) {
                throw new IllegalArgumentException("Invalid flash intencity");
            }
            this.flashIntensity = flashIntensity;
            return this;
        }

        public Builder withFlashScale(Supplier<Float> flashScale) {
            this.flashScale = flashScale;
            return this;
        }

        public Builder withFlashOffsetX(Supplier<Float> flashOffsetX) {
            this.flashOffsetX = flashOffsetX;
            return this;
        }

        public Builder withFlashOffsetY(Supplier<Float> flashOffsetY) {
            this.flashOffsetY = flashOffsetY;
            return this;
        }

        public Builder withFlashTexture(String flashTexture) {
            this.flashTexture = "mwc:textures/particle/" + flashTexture.toLowerCase() + ".png";
            return this;
        }

        public Builder withSmokeOffsetX(Supplier<Float> smokeOffsetX) {
            this.smokeOffsetX = smokeOffsetX;
            return this;
        }

        public Builder withSmokeOffsetY(Supplier<Float> smokeOffsetY) {
            this.smokeOffsetY = smokeOffsetY;
            return this;
        }

        @Deprecated
        public Builder withCrafting(CraftingComplexity craftingComplexity, Object ... craftingMaterials) {
            if (craftingComplexity == null) {
                throw new IllegalArgumentException("Crafting complexity not set");
            }
            if (craftingMaterials.length < 2) {
                throw new IllegalArgumentException("2 or more materials required for crafting");
            }
            this.craftingComplexity = craftingComplexity;
            this.craftingMaterials = craftingMaterials;
            return this;
        }

        public Builder withTest() {
            return this;
        }

        public Builder withModernRecipe(CraftingEntry ... itemStacks) {
            this.modernCraftingRecipe = itemStacks;
            return this;
        }

        public Builder withCraftingRecipe(Object ... craftingRecipe) {
            this.craftingRecipe = craftingRecipe;
            return this;
        }

        public Builder withBleedingCoefficient(float bleedingCoefficient) {
            this.bleedingCoefficient = bleedingCoefficient;
            return this;
        }

        public Builder withExplosionParticleTexture(String explosionParticleTexture) {
            if (explosionParticleTexture.endsWith(".png") && explosionParticleTexture.length() > 4) {
                explosionParticleTexture = explosionParticleTexture.substring(0, explosionParticleTexture.length() - 4);
            }
            this.explosionParticleTexture = "mwc:textures/particle/" + explosionParticleTexture.toLowerCase() + ".png";
            return this;
        }

        public Builder withSmokeParticleTexture(String smokeParticleTexture) {
            if (smokeParticleTexture.endsWith(".png") && smokeParticleTexture.length() > 4) {
                smokeParticleTexture = smokeParticleTexture.substring(0, smokeParticleTexture.length() - 4);
            }
            this.smokeParticleTexture = "mwc:textures/particle/" + smokeParticleTexture.toLowerCase() + ".png";
            return this;
        }

        public Builder withScreenShaking(RenderableState state, float zRotationCoefficient) {
            ScreenShakeAnimation.Builder defaultShootingStateScreenShakingBuilder = new ScreenShakeAnimation.Builder().withState(state).withRotationAttenuation(0.5f).withTranslationAttenuation(0.05f).withZRotationCoefficient(zRotationCoefficient).withTransitionDuration(50L);
            this.screenShakingBuilders.put(RenderableState.SHOOTING, defaultShootingStateScreenShakingBuilder);
            return this;
        }

        public Builder withModernScreenShaking(double intensity, double speedModifier) {
            this.screenShakingParameters = new Pair<Double, Double>(intensity, speedModifier);
            return this;
        }

        public Builder withScreenShaking(RenderableState state, float xRotationCoefficient, float yRotationCoefficient, float zRotationCoefficient) {
            ScreenShakeAnimation.Builder defaultShootingStateScreenShakingBuilder = new ScreenShakeAnimation.Builder().withState(state).withRotationAttenuation(0.5f).withTranslationAttenuation(0.05f).withXRotationCoefficient(xRotationCoefficient).withYRotationCoefficient(yRotationCoefficient).withZRotationCoefficient(zRotationCoefficient).withTransitionDuration(50L);
            this.screenShakingBuilders.put(RenderableState.SHOOTING, defaultShootingStateScreenShakingBuilder);
            return this;
        }

        public Weapon build(ModContext modContext) {
            if (this.name == null) {
                throw new IllegalStateException("Weapon name not provided");
            }
            if (this.shootSound == null) {
                this.shootSound = this.name;
            }
            if (this.silencedShootSound == null) {
                this.silencedShootSound = this.shootSound;
            }
            if (this.reloadSound == null) {
                this.reloadSound = "reload";
            }
            if (this.unloadSound == null) {
                this.unloadSound = "unload";
            }
            if (this.spawnEntityClass == null) {
                this.spawnEntityClass = WeaponSpawnEntity.class;
            }
            for (ItemSkin skin : CommonRegistry.gunSkins) {
                this.withCompatibleAttachment((ItemAttachment<Weapon>)skin, (ModelBase c) -> {});
            }
            if (this.spawnEntityWith == null) {
                int explosionParticleTextureId = modContext.registerTexture(this.explosionParticleTexture);
                int smokeParticleTextureId = modContext.registerTexture(this.smokeParticleTexture);
                this.spawnEntityWith = (weapon, player) -> {
                    double damage = this.spawnEntityDamage;
                    if (BalancePackManager.hasActiveBalancePack()) {
                        if (BalancePackManager.shouldChangeWeaponDamage(weapon)) {
                            damage = BalancePackManager.getNewWeaponDamage(weapon);
                        }
                        damage *= BalancePackManager.getGroupDamageMultiplier(weapon.getConfigurationGroup());
                        damage *= BalancePackManager.getGlobalDamageMultiplier();
                    }
                    WeaponSpawnEntity bullet = new WeaponSpawnEntity((Weapon)weapon, player.field_70170_p, (EntityLivingBase)player, this.spawnEntitySpeed, this.spawnEntityGravityVelocity, this.inaccuracy, (float)damage, this.spawnEntityExplosionRadius, this.isDestroyingBlocks, this.spawnEntityRocketParticles, this.spawnEntityParticleAgeCoefficient, this.spawnEntitySmokeParticleAgeCoefficient, this.spawnEntityExplosionParticleScaleCoefficient, this.spawnEntitySmokeParticleScaleCoefficient, explosionParticleTextureId, smokeParticleTextureId);
                    bullet.setPositionAndDirection(true);
                    return bullet;
                };
            }
            if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
                WeaponSpritesheetBuilder.registerSprite(this.name);
                this.renderer.name = this.name;
            }
            if (this.shellCasingModel == null) {
                this.shellCasingModel = new Shell();
            }
            if (this.shellCasingModelTextureName == null) {
                this.shellCasingModelTextureName = DEFAULT_SHELL_CASING_TEXTURE_NAME;
            }
            if (this.spawnShellWith == null) {
                this.spawnShellWith = (weaponInstance, player) -> {
                    EntityShellCasing shell = new EntityShellCasing((PlayerWeaponInstance)weaponInstance, player.field_70170_p, (EntityLivingBase)player, 0.1f, 0.05f, 20.0f);
                    shell.setPositionAndDirection(true);
                    return shell;
                };
            }
            if (this.crosshairRunning == null) {
                this.crosshairRunning = this.crosshair;
            }
            if (this.crosshairZoomed == null) {
                this.crosshairZoomed = this.crosshair;
            }
            if (this.blockImpactHandler == null) {
                this.blockImpactHandler = (world, player, entity, position) -> {
                    IBlockState iBlockState = world.func_180495_p(new BlockPos(position.func_178782_a().func_177958_n(), position.func_178782_a().func_177956_o(), position.func_178782_a().func_177952_p()));
                    if (ModernConfigManager.bulletBreakGlass && iBlockState.func_185904_a() == Material.field_151592_s) {
                        world.func_175655_b(new BlockPos((Vec3i)new BlockPos(position.func_178782_a().func_177958_n(), position.func_178782_a().func_177956_o(), position.func_178782_a().func_177952_p())), true);
                    } else {
                        MWC.CHANNEL.sendToAllAround((IMessage)new BlockHitMessage(position.func_178782_a(), new Vector3F(position.field_72307_f), position.field_178784_b), new NetworkRegistry.TargetPoint(entity.field_71093_bK, (double)position.func_178782_a().func_177958_n(), (double)position.func_178782_a().func_177956_o(), (double)position.func_178782_a().func_177952_p(), 100.0));
                        MaterialImpactSound materialImpactSound = modContext.getMaterialImpactSound(iBlockState, entity);
                        if (materialImpactSound != null) {
                            world.func_184148_a(null, (double)position.func_178782_a().func_177958_n(), (double)position.func_178782_a().func_177956_o(), (double)position.func_178782_a().func_177952_p(), materialImpactSound.getSound(), SoundCategory.BLOCKS, materialImpactSound.getVolume(), 1.0f);
                        }
                    }
                };
            }
            if (this.maxBulletsPerReload == 0) {
                this.maxBulletsPerReload = this.ammoCapacity;
            }
            if (this.maxShots.isEmpty()) {
                this.maxShots.add(Integer.MAX_VALUE);
            }
            Weapon weapon2 = new Weapon(this, modContext);
            weapon2.shootSound = modContext.registerSound(this.shootSound);
            if (this.endOfShootSound != null) {
                weapon2.endOfShootSound = modContext.registerSound(this.endOfShootSound);
            }
            weapon2.muzzlePosition = this.muzzlePosition;
            weapon2.burstShootSound = modContext.registerSound(this.burstShootSound);
            weapon2.silencedBurstShootSound = modContext.registerSound(this.silencedBurstShootSound);
            weapon2.reloadSound = modContext.registerSound(this.reloadSound);
            weapon2.reloadIterationSound = modContext.registerSound(this.reloadIterationSound);
            weapon2.inspectSound = modContext.registerSound(this.inspectSound);
            weapon2.drawSound = modContext.registerSound(this.drawSound);
            weapon2.allReloadIterationsCompletedSound = modContext.registerSound(this.allReloadIterationsCompletedSound);
            weapon2.unloadSound = modContext.registerSound(this.unloadSound);
            weapon2.silencedShootSound = modContext.registerSound(this.silencedShootSound);
            if (this.ejectSpentRoundSound != null) {
                weapon2.ejectSpentRoundSound = modContext.registerSound(this.ejectSpentRoundSound);
            }
            weapon2.func_77637_a(this.creativeTab);
            weapon2.func_77655_b(this.name);
            if (this.ammo != null) {
                this.ammo.addCompatibleWeapon(weapon2);
            }
            this.withCompatibleAttachment(SpecialAttachments.MagicMag, true, (ModelBase model) -> {});
            for (ItemAttachment<Weapon> attachment : this.compatibleAttachments.keySet()) {
                attachment.addCompatibleWeapon(weapon2);
            }
            modContext.registerWeapon(this.name, weapon2, this.renderer);
            if (this.craftingRecipe != null && this.craftingRecipe.length >= 2) {
                ItemStack itemStack = new ItemStack((Item)weapon2);
                List<Object> registeredRecipe = modContext.getRecipeManager().registerShapedRecipe(weapon2, this.craftingRecipe);
                boolean hasOres = Arrays.stream(this.craftingRecipe).anyMatch(r -> r instanceof String);
                if (hasOres) {
                    ForgeRegistries.RECIPES.register(new ShapedOreRecipe(null, itemStack, registeredRecipe.toArray()).setMirrored(false).setRegistryName("mwc", itemStack.func_77973_b().func_77658_a() + "_recipe"));
                } else {
                    ForgeRegistries.RECIPES.register(new ShapedOreRecipe(null, itemStack, registeredRecipe.toArray()).setMirrored(false).setRegistryName("mwc", itemStack.func_77973_b().func_77658_a() + "_recipe"));
                }
            } else if (this.craftingComplexity != null) {
                OptionsMetadata optionsMetadata = new OptionsMetadata.OptionMetadataBuilder().withSlotCount(9).build(this.craftingComplexity, Arrays.copyOf(this.craftingMaterials, this.craftingMaterials.length));
                List<Object> shape = modContext.getRecipeManager().createShapedRecipe(weapon2, weapon2.getName(), optionsMetadata);
                if (optionsMetadata.hasOres()) {
                    ForgeRegistries.RECIPES.register(new ShapedOreRecipe(null, new ItemStack((Item)weapon2), shape.toArray()).setMirrored(false).setRegistryName("mwc", new ItemStack((Item)weapon2).func_77973_b().func_77658_a() + "_recipe"));
                } else {
                    ForgeRegistries.RECIPES.register(new ShapedOreRecipe(null, new ItemStack((Item)weapon2), shape.toArray()).setMirrored(false).setRegistryName("mwc", new ItemStack((Item)weapon2).func_77973_b().func_77658_a() + "_recipe"));
                }
            } else {
                ++noRecipe;
            }
            Weapon.access$1302(weapon2, this.modernCraftingRecipe);
            this.informationProvider = stack -> {
                TextFormatting plate = TextFormatting.GREEN;
                TextFormatting plain = TextFormatting.GRAY;
                ArrayList<String> descriptionBuilder = new ArrayList<String>();
                descriptionBuilder.add(plate + "Type: " + plain + this.gunType);
                descriptionBuilder.add(plate + "Damage: " + plain + String.format("%.1f", BalancePackManager.getNetGunDamage(weapon2)));
                descriptionBuilder.add(plate + "Firerate: " + plain + Math.round(BalancePackManager.getFirerate(weapon2) * 100.0f) + "/100");
                boolean cartridgeDriven = false;
                String catridgeName = "";
                for (Map.Entry<ItemAttachment<Weapon>, CompatibleAttachment<Weapon>> i : this.compatibleAttachments.entrySet()) {
                    if (i.getValue().getAttachment().getCategory() != AttachmentCategory.BULLET) continue;
                    cartridgeDriven = true;
                    catridgeName = new TextComponentTranslation(i.getValue().getAttachment().func_77658_a() + ".name", new Object[0]).func_150254_d();
                }
                if (!cartridgeDriven) {
                    descriptionBuilder.add(plate + "Magazines:");
                    ArrayList<ItemMagazine> mags = new ArrayList<ItemMagazine>();
                    weapon2.getCompatibleAttachments(AttachmentCategory.MAGAZINE).forEach(c -> mags.add((ItemMagazine)c.getAttachment()));
                    mags.sort((a, b) -> a.getCapacity() - b.getCapacity());
                    mags.forEach(c -> descriptionBuilder.add(plain + I18n.func_135052_a((String)(c.func_77658_a() + ".name"), (Object[])new Object[0])));
                } else {
                    descriptionBuilder.add(plate + "Cartridge: " + plain + catridgeName);
                }
                return descriptionBuilder;
            };
            CraftingRegistry.registerHook(weapon2);
            return weapon2;
        }
    }

    public static class ScreenShaking {
        private float zRotationCoefficient;

        public ScreenShaking(float zRotationCoefficient) {
            this.zRotationCoefficient = zRotationCoefficient;
        }

        public float getZRotationCoefficient() {
            return this.zRotationCoefficient;
        }
    }

    public static enum ShellCasingEjectDirection {
        LEFT,
        RIGHT;

    }
}

